/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.impl.writer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.util.JavaDataModel;
import org.apache.orc.OrcConf;
import org.apache.orc.OrcProto;
import org.apache.orc.StringColumnStatistics;
import org.apache.orc.TypeDescription;
import org.apache.orc.impl.CryptoUtils;
import org.apache.orc.impl.Dictionary;
import org.apache.orc.impl.DynamicIntArray;
import org.apache.orc.impl.IntegerWriter;
import org.apache.orc.impl.OutStream;
import org.apache.orc.impl.PositionedOutputStream;
import org.apache.orc.impl.StreamName;
import org.apache.orc.impl.StringHashTableDictionary;
import org.apache.orc.impl.StringRedBlackTree;
import org.apache.orc.impl.writer.TreeWriterBase;
import org.apache.orc.impl.writer.WriterContext;
import org.apache.orc.impl.writer.WriterEncryptionVariant;

public abstract class StringBaseTreeWriter
extends TreeWriterBase {
    private final OutStream stringOutput;
    protected final IntegerWriter lengthOutput;
    private final IntegerWriter rowOutput;
    protected final DynamicIntArray rows = new DynamicIntArray();
    protected final PositionedOutputStream directStreamOutput;
    private final List<OrcProto.RowIndexEntry> savedRowIndex = new ArrayList<OrcProto.RowIndexEntry>();
    private final boolean buildIndex;
    private final List<Long> rowIndexValueCount = new ArrayList<Long>();
    private final double dictionaryKeySizeThreshold;
    protected Dictionary dictionary;
    protected boolean useDictionaryEncoding = true;
    private boolean isDirectV2 = true;
    private boolean doneDictionaryCheck;
    private final boolean strideDictionaryCheck;

    private static Dictionary createDict(Configuration conf) {
        String dictImpl = conf.get(OrcConf.DICTIONARY_IMPL.getAttribute(), OrcConf.DICTIONARY_IMPL.getDefaultValue().toString()).toUpperCase();
        switch (Dictionary.IMPL.valueOf(dictImpl)) {
            case RBTREE: {
                return new StringRedBlackTree(4096);
            }
            case HASH: {
                return new StringHashTableDictionary(4096);
            }
        }
        throw new UnsupportedOperationException("Unknown implementation:" + dictImpl);
    }

    StringBaseTreeWriter(TypeDescription schema, WriterEncryptionVariant encryption, WriterContext context) throws IOException {
        super(schema, encryption, context);
        Configuration conf = context.getConfiguration();
        this.dictionary = StringBaseTreeWriter.createDict(conf);
        this.isDirectV2 = this.isNewWriteFormat(context);
        this.directStreamOutput = context.createStream(new StreamName(this.id, OrcProto.Stream.Kind.DATA, encryption));
        this.stringOutput = context.createStream(new StreamName(this.id, OrcProto.Stream.Kind.DICTIONARY_DATA, encryption));
        this.lengthOutput = this.createIntegerWriter(context.createStream(new StreamName(this.id, OrcProto.Stream.Kind.LENGTH, encryption)), false, this.isDirectV2, context);
        this.rowOutput = this.createIntegerWriter(this.directStreamOutput, false, this.isDirectV2, context);
        if (this.rowIndexPosition != null) {
            this.recordPosition(this.rowIndexPosition);
        }
        this.rowIndexValueCount.add(0L);
        this.buildIndex = context.buildIndex();
        this.dictionaryKeySizeThreshold = context.getDictionaryKeySizeThreshold(this.id);
        this.strideDictionaryCheck = OrcConf.ROW_INDEX_STRIDE_DICTIONARY_CHECK.getBoolean(conf);
        if (this.dictionaryKeySizeThreshold <= 0.0) {
            this.useDictionaryEncoding = false;
            this.doneDictionaryCheck = true;
            this.recordDirectStreamPosition();
        } else {
            this.doneDictionaryCheck = false;
        }
    }

    private void checkDictionaryEncoding() {
        if (!this.doneDictionaryCheck) {
            float ratio = this.rows.size() > 0 ? (float)this.dictionary.size() / (float)this.rows.size() : 0.0f;
            this.useDictionaryEncoding = !this.isDirectV2 || (double)ratio <= this.dictionaryKeySizeThreshold;
            this.doneDictionaryCheck = true;
        }
    }

    @Override
    public void writeStripe(int requiredIndexEntries) throws IOException {
        this.checkDictionaryEncoding();
        if (!this.useDictionaryEncoding) {
            this.stringOutput.suppress();
        }
        super.writeStripe(requiredIndexEntries);
        this.dictionary.clear();
        this.savedRowIndex.clear();
        this.rowIndexValueCount.clear();
        if (this.rowIndexPosition != null) {
            this.recordPosition(this.rowIndexPosition);
        }
        this.rowIndexValueCount.add(0L);
        if (!this.useDictionaryEncoding) {
            this.recordDirectStreamPosition();
        }
    }

    private void flushDictionary() throws IOException {
        final int[] dumpOrder = new int[this.dictionary.size()];
        if (this.useDictionaryEncoding) {
            this.dictionary.visit(new Dictionary.Visitor(){
                private int currentId = 0;

                @Override
                public void visit(Dictionary.VisitorContext context) throws IOException {
                    context.writeBytes(StringBaseTreeWriter.this.stringOutput);
                    StringBaseTreeWriter.this.lengthOutput.write(context.getLength());
                    dumpOrder[context.getOriginalPosition()] = this.currentId++;
                }
            });
        } else {
            this.stringOutput.suppress();
        }
        int length = this.rows.size();
        int rowIndexEntry = 0;
        OrcProto.RowIndex.Builder rowIndex = this.getRowIndex();
        for (int i = 0; i <= length; ++i) {
            if (this.buildIndex) {
                while ((long)i == this.rowIndexValueCount.get(rowIndexEntry) && rowIndexEntry < this.savedRowIndex.size()) {
                    OrcProto.RowIndexEntry.Builder base = this.savedRowIndex.get(rowIndexEntry++).toBuilder();
                    if (this.useDictionaryEncoding) {
                        this.rowOutput.getPosition(new TreeWriterBase.RowIndexPositionRecorder(base));
                    } else {
                        TreeWriterBase.RowIndexPositionRecorder posn = new TreeWriterBase.RowIndexPositionRecorder(base);
                        this.directStreamOutput.getPosition(posn);
                        this.lengthOutput.getPosition(posn);
                    }
                    rowIndex.addEntry(base.build());
                }
            }
            if (i == length) continue;
            if (this.useDictionaryEncoding) {
                this.rowOutput.write(dumpOrder[this.rows.get(i)]);
                continue;
            }
            int writeLen = this.dictionary.writeTo(this.directStreamOutput, this.rows.get(i));
            this.lengthOutput.write(writeLen);
        }
        this.rows.clear();
    }

    @Override
    OrcProto.ColumnEncoding.Builder getEncoding() {
        OrcProto.ColumnEncoding.Builder result = super.getEncoding();
        if (this.useDictionaryEncoding) {
            result.setDictionarySize(this.dictionary.size());
            if (this.isDirectV2) {
                result.setKind(OrcProto.ColumnEncoding.Kind.DICTIONARY_V2);
            } else {
                result.setKind(OrcProto.ColumnEncoding.Kind.DICTIONARY);
            }
        } else if (this.isDirectV2) {
            result.setKind(OrcProto.ColumnEncoding.Kind.DIRECT_V2);
        } else {
            result.setKind(OrcProto.ColumnEncoding.Kind.DIRECT);
        }
        return result;
    }

    @Override
    public void createRowIndexEntry() throws IOException {
        this.getStripeStatistics().merge(this.indexStatistics);
        OrcProto.RowIndexEntry.Builder rowIndexEntry = this.getRowIndexEntry();
        rowIndexEntry.setStatistics(this.indexStatistics.serialize());
        this.indexStatistics.reset();
        OrcProto.RowIndexEntry base = rowIndexEntry.build();
        this.savedRowIndex.add(base);
        rowIndexEntry.clear();
        this.addBloomFilterEntry();
        this.recordPosition(this.rowIndexPosition);
        this.rowIndexValueCount.add(Long.valueOf(this.rows.size()));
        if (this.strideDictionaryCheck) {
            this.checkDictionaryEncoding();
        }
        if (!this.useDictionaryEncoding) {
            if (this.rows.size() > 0) {
                this.flushDictionary();
                this.recordDirectStreamPosition();
            } else {
                this.recordDirectStreamPosition();
                this.getRowIndex().addEntry(base);
            }
        }
    }

    private void recordDirectStreamPosition() throws IOException {
        if (this.rowIndexPosition != null) {
            this.directStreamOutput.getPosition(this.rowIndexPosition);
            this.lengthOutput.getPosition(this.rowIndexPosition);
        }
    }

    @Override
    public long estimateMemory() {
        long parent = super.estimateMemory();
        if (this.useDictionaryEncoding) {
            return parent + this.dictionary.getSizeInBytes() + (long)this.rows.getSizeInBytes();
        }
        return parent + this.lengthOutput.estimateMemory() + this.directStreamOutput.getBufferSize();
    }

    @Override
    public long getRawDataSize() {
        StringColumnStatistics scs = (StringColumnStatistics)((Object)this.fileStatistics);
        long numVals = this.fileStatistics.getNumberOfValues();
        if (numVals == 0L) {
            return 0L;
        }
        int avgSize = (int)(scs.getSum() / numVals);
        return numVals * (long)JavaDataModel.get().lengthForStringOfLength(avgSize);
    }

    @Override
    public void flushStreams() throws IOException {
        super.flushStreams();
        this.checkDictionaryEncoding();
        if (this.useDictionaryEncoding) {
            this.flushDictionary();
            this.stringOutput.flush();
            this.lengthOutput.flush();
            this.rowOutput.flush();
        } else {
            if (this.rows.size() > 0) {
                this.flushDictionary();
            }
            this.stringOutput.suppress();
            this.directStreamOutput.flush();
            this.lengthOutput.flush();
        }
    }

    @Override
    public void prepareStripe(int stripeId) {
        super.prepareStripe(stripeId);
        Consumer<byte[]> updater = CryptoUtils.modifyIvForStripe(stripeId);
        this.stringOutput.changeIv(updater);
        this.lengthOutput.changeIv(updater);
        this.rowOutput.changeIv(updater);
        this.directStreamOutput.changeIv(updater);
    }
}

