/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.api;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hive.metastore.api.HiveObjectRef;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.PrivilegeGrantInfo;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.annotation.Nullable;
import org.apache.thrift.meta_data.EnumMetaData;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class HiveObjectPrivilege
implements TBase<HiveObjectPrivilege, _Fields>,
Serializable,
Cloneable,
Comparable<HiveObjectPrivilege> {
    private static final TStruct STRUCT_DESC = new TStruct("HiveObjectPrivilege");
    private static final TField HIVE_OBJECT_FIELD_DESC = new TField("hiveObject", 12, 1);
    private static final TField PRINCIPAL_NAME_FIELD_DESC = new TField("principalName", 11, 2);
    private static final TField PRINCIPAL_TYPE_FIELD_DESC = new TField("principalType", 8, 3);
    private static final TField GRANT_INFO_FIELD_DESC = new TField("grantInfo", 12, 4);
    private static final TField AUTHORIZER_FIELD_DESC = new TField("authorizer", 11, 5);
    private static final SchemeFactory STANDARD_SCHEME_FACTORY = new HiveObjectPrivilegeStandardSchemeFactory();
    private static final SchemeFactory TUPLE_SCHEME_FACTORY = new HiveObjectPrivilegeTupleSchemeFactory();
    @Nullable
    private HiveObjectRef hiveObject;
    @Nullable
    private String principalName;
    @Nullable
    private PrincipalType principalType;
    @Nullable
    private PrivilegeGrantInfo grantInfo;
    @Nullable
    private String authorizer;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public HiveObjectPrivilege() {
    }

    public HiveObjectPrivilege(HiveObjectRef hiveObject, String principalName, PrincipalType principalType, PrivilegeGrantInfo grantInfo, String authorizer) {
        this();
        this.hiveObject = hiveObject;
        this.principalName = principalName;
        this.principalType = principalType;
        this.grantInfo = grantInfo;
        this.authorizer = authorizer;
    }

    public HiveObjectPrivilege(HiveObjectPrivilege other) {
        if (other.isSetHiveObject()) {
            this.hiveObject = new HiveObjectRef(other.hiveObject);
        }
        if (other.isSetPrincipalName()) {
            this.principalName = other.principalName;
        }
        if (other.isSetPrincipalType()) {
            this.principalType = other.principalType;
        }
        if (other.isSetGrantInfo()) {
            this.grantInfo = new PrivilegeGrantInfo(other.grantInfo);
        }
        if (other.isSetAuthorizer()) {
            this.authorizer = other.authorizer;
        }
    }

    public HiveObjectPrivilege deepCopy() {
        return new HiveObjectPrivilege(this);
    }

    public void clear() {
        this.hiveObject = null;
        this.principalName = null;
        this.principalType = null;
        this.grantInfo = null;
        this.authorizer = null;
    }

    @Nullable
    public HiveObjectRef getHiveObject() {
        return this.hiveObject;
    }

    public void setHiveObject(@Nullable HiveObjectRef hiveObject) {
        this.hiveObject = hiveObject;
    }

    public void unsetHiveObject() {
        this.hiveObject = null;
    }

    public boolean isSetHiveObject() {
        return this.hiveObject != null;
    }

    public void setHiveObjectIsSet(boolean value) {
        if (!value) {
            this.hiveObject = null;
        }
    }

    @Nullable
    public String getPrincipalName() {
        return this.principalName;
    }

    public void setPrincipalName(@Nullable String principalName) {
        this.principalName = principalName;
    }

    public void unsetPrincipalName() {
        this.principalName = null;
    }

    public boolean isSetPrincipalName() {
        return this.principalName != null;
    }

    public void setPrincipalNameIsSet(boolean value) {
        if (!value) {
            this.principalName = null;
        }
    }

    @Nullable
    public PrincipalType getPrincipalType() {
        return this.principalType;
    }

    public void setPrincipalType(@Nullable PrincipalType principalType) {
        this.principalType = principalType;
    }

    public void unsetPrincipalType() {
        this.principalType = null;
    }

    public boolean isSetPrincipalType() {
        return this.principalType != null;
    }

    public void setPrincipalTypeIsSet(boolean value) {
        if (!value) {
            this.principalType = null;
        }
    }

    @Nullable
    public PrivilegeGrantInfo getGrantInfo() {
        return this.grantInfo;
    }

    public void setGrantInfo(@Nullable PrivilegeGrantInfo grantInfo) {
        this.grantInfo = grantInfo;
    }

    public void unsetGrantInfo() {
        this.grantInfo = null;
    }

    public boolean isSetGrantInfo() {
        return this.grantInfo != null;
    }

    public void setGrantInfoIsSet(boolean value) {
        if (!value) {
            this.grantInfo = null;
        }
    }

    @Nullable
    public String getAuthorizer() {
        return this.authorizer;
    }

    public void setAuthorizer(@Nullable String authorizer) {
        this.authorizer = authorizer;
    }

    public void unsetAuthorizer() {
        this.authorizer = null;
    }

    public boolean isSetAuthorizer() {
        return this.authorizer != null;
    }

    public void setAuthorizerIsSet(boolean value) {
        if (!value) {
            this.authorizer = null;
        }
    }

    public void setFieldValue(_Fields field, @Nullable Object value) {
        switch (field) {
            case HIVE_OBJECT: {
                if (value == null) {
                    this.unsetHiveObject();
                    break;
                }
                this.setHiveObject((HiveObjectRef)value);
                break;
            }
            case PRINCIPAL_NAME: {
                if (value == null) {
                    this.unsetPrincipalName();
                    break;
                }
                this.setPrincipalName((String)value);
                break;
            }
            case PRINCIPAL_TYPE: {
                if (value == null) {
                    this.unsetPrincipalType();
                    break;
                }
                this.setPrincipalType((PrincipalType)((Object)value));
                break;
            }
            case GRANT_INFO: {
                if (value == null) {
                    this.unsetGrantInfo();
                    break;
                }
                this.setGrantInfo((PrivilegeGrantInfo)value);
                break;
            }
            case AUTHORIZER: {
                if (value == null) {
                    this.unsetAuthorizer();
                    break;
                }
                this.setAuthorizer((String)value);
            }
        }
    }

    @Nullable
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case HIVE_OBJECT: {
                return this.getHiveObject();
            }
            case PRINCIPAL_NAME: {
                return this.getPrincipalName();
            }
            case PRINCIPAL_TYPE: {
                return this.getPrincipalType();
            }
            case GRANT_INFO: {
                return this.getGrantInfo();
            }
            case AUTHORIZER: {
                return this.getAuthorizer();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case HIVE_OBJECT: {
                return this.isSetHiveObject();
            }
            case PRINCIPAL_NAME: {
                return this.isSetPrincipalName();
            }
            case PRINCIPAL_TYPE: {
                return this.isSetPrincipalType();
            }
            case GRANT_INFO: {
                return this.isSetGrantInfo();
            }
            case AUTHORIZER: {
                return this.isSetAuthorizer();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that instanceof HiveObjectPrivilege) {
            return this.equals((HiveObjectPrivilege)that);
        }
        return false;
    }

    public boolean equals(HiveObjectPrivilege that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_hiveObject = this.isSetHiveObject();
        boolean that_present_hiveObject = that.isSetHiveObject();
        if (this_present_hiveObject || that_present_hiveObject) {
            if (!this_present_hiveObject || !that_present_hiveObject) {
                return false;
            }
            if (!this.hiveObject.equals(that.hiveObject)) {
                return false;
            }
        }
        boolean this_present_principalName = this.isSetPrincipalName();
        boolean that_present_principalName = that.isSetPrincipalName();
        if (this_present_principalName || that_present_principalName) {
            if (!this_present_principalName || !that_present_principalName) {
                return false;
            }
            if (!this.principalName.equals(that.principalName)) {
                return false;
            }
        }
        boolean this_present_principalType = this.isSetPrincipalType();
        boolean that_present_principalType = that.isSetPrincipalType();
        if (this_present_principalType || that_present_principalType) {
            if (!this_present_principalType || !that_present_principalType) {
                return false;
            }
            if (!this.principalType.equals((Object)that.principalType)) {
                return false;
            }
        }
        boolean this_present_grantInfo = this.isSetGrantInfo();
        boolean that_present_grantInfo = that.isSetGrantInfo();
        if (this_present_grantInfo || that_present_grantInfo) {
            if (!this_present_grantInfo || !that_present_grantInfo) {
                return false;
            }
            if (!this.grantInfo.equals(that.grantInfo)) {
                return false;
            }
        }
        boolean this_present_authorizer = this.isSetAuthorizer();
        boolean that_present_authorizer = that.isSetAuthorizer();
        if (this_present_authorizer || that_present_authorizer) {
            if (!this_present_authorizer || !that_present_authorizer) {
                return false;
            }
            if (!this.authorizer.equals(that.authorizer)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 8191 + (this.isSetHiveObject() ? 131071 : 524287);
        if (this.isSetHiveObject()) {
            hashCode = hashCode * 8191 + this.hiveObject.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetPrincipalName() ? 131071 : 524287);
        if (this.isSetPrincipalName()) {
            hashCode = hashCode * 8191 + this.principalName.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetPrincipalType() ? 131071 : 524287);
        if (this.isSetPrincipalType()) {
            hashCode = hashCode * 8191 + this.principalType.getValue();
        }
        hashCode = hashCode * 8191 + (this.isSetGrantInfo() ? 131071 : 524287);
        if (this.isSetGrantInfo()) {
            hashCode = hashCode * 8191 + this.grantInfo.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetAuthorizer() ? 131071 : 524287);
        if (this.isSetAuthorizer()) {
            hashCode = hashCode * 8191 + this.authorizer.hashCode();
        }
        return hashCode;
    }

    @Override
    public int compareTo(HiveObjectPrivilege other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.compare(this.isSetHiveObject(), other.isSetHiveObject());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetHiveObject() && (lastComparison = TBaseHelper.compareTo((Comparable)this.hiveObject, (Comparable)other.hiveObject)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetPrincipalName(), other.isSetPrincipalName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetPrincipalName() && (lastComparison = TBaseHelper.compareTo((String)this.principalName, (String)other.principalName)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetPrincipalType(), other.isSetPrincipalType());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetPrincipalType() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.principalType), (Comparable)((Object)other.principalType))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetGrantInfo(), other.isSetGrantInfo());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetGrantInfo() && (lastComparison = TBaseHelper.compareTo((Comparable)this.grantInfo, (Comparable)other.grantInfo)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetAuthorizer(), other.isSetAuthorizer());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetAuthorizer() && (lastComparison = TBaseHelper.compareTo((String)this.authorizer, (String)other.authorizer)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Nullable
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        HiveObjectPrivilege.scheme(iprot).read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        HiveObjectPrivilege.scheme(oprot).write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("HiveObjectPrivilege(");
        boolean first = true;
        sb.append("hiveObject:");
        if (this.hiveObject == null) {
            sb.append("null");
        } else {
            sb.append(this.hiveObject);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("principalName:");
        if (this.principalName == null) {
            sb.append("null");
        } else {
            sb.append(this.principalName);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("principalType:");
        if (this.principalType == null) {
            sb.append("null");
        } else {
            sb.append((Object)this.principalType);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("grantInfo:");
        if (this.grantInfo == null) {
            sb.append("null");
        } else {
            sb.append(this.grantInfo);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("authorizer:");
        if (this.authorizer == null) {
            sb.append("null");
        } else {
            sb.append(this.authorizer);
        }
        first = false;
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.hiveObject != null) {
            this.hiveObject.validate();
        }
        if (this.grantInfo != null) {
            this.grantInfo.validate();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private static <S extends IScheme> S scheme(TProtocol proto) {
        return (S)(StandardScheme.class.equals((Object)proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.HIVE_OBJECT, new FieldMetaData("hiveObject", 3, (FieldValueMetaData)new StructMetaData(12, HiveObjectRef.class)));
        tmpMap.put(_Fields.PRINCIPAL_NAME, new FieldMetaData("principalName", 3, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.PRINCIPAL_TYPE, new FieldMetaData("principalType", 3, (FieldValueMetaData)new EnumMetaData(16, PrincipalType.class)));
        tmpMap.put(_Fields.GRANT_INFO, new FieldMetaData("grantInfo", 3, (FieldValueMetaData)new StructMetaData(12, PrivilegeGrantInfo.class)));
        tmpMap.put(_Fields.AUTHORIZER, new FieldMetaData("authorizer", 3, new FieldValueMetaData(11)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(HiveObjectPrivilege.class, metaDataMap);
    }

    public static enum _Fields implements TFieldIdEnum
    {
        HIVE_OBJECT(1, "hiveObject"),
        PRINCIPAL_NAME(2, "principalName"),
        PRINCIPAL_TYPE(3, "principalType"),
        GRANT_INFO(4, "grantInfo"),
        AUTHORIZER(5, "authorizer");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return HIVE_OBJECT;
                }
                case 2: {
                    return PRINCIPAL_NAME;
                }
                case 3: {
                    return PRINCIPAL_TYPE;
                }
                case 4: {
                    return GRANT_INFO;
                }
                case 5: {
                    return AUTHORIZER;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        @Nullable
        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }

    private static class HiveObjectPrivilegeStandardSchemeFactory
    implements SchemeFactory {
        private HiveObjectPrivilegeStandardSchemeFactory() {
        }

        public HiveObjectPrivilegeStandardScheme getScheme() {
            return new HiveObjectPrivilegeStandardScheme();
        }
    }

    private static class HiveObjectPrivilegeTupleSchemeFactory
    implements SchemeFactory {
        private HiveObjectPrivilegeTupleSchemeFactory() {
        }

        public HiveObjectPrivilegeTupleScheme getScheme() {
            return new HiveObjectPrivilegeTupleScheme();
        }
    }

    private static class HiveObjectPrivilegeTupleScheme
    extends TupleScheme<HiveObjectPrivilege> {
        private HiveObjectPrivilegeTupleScheme() {
        }

        public void write(TProtocol prot, HiveObjectPrivilege struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            BitSet optionals = new BitSet();
            if (struct.isSetHiveObject()) {
                optionals.set(0);
            }
            if (struct.isSetPrincipalName()) {
                optionals.set(1);
            }
            if (struct.isSetPrincipalType()) {
                optionals.set(2);
            }
            if (struct.isSetGrantInfo()) {
                optionals.set(3);
            }
            if (struct.isSetAuthorizer()) {
                optionals.set(4);
            }
            oprot.writeBitSet(optionals, 5);
            if (struct.isSetHiveObject()) {
                struct.hiveObject.write((TProtocol)oprot);
            }
            if (struct.isSetPrincipalName()) {
                oprot.writeString(struct.principalName);
            }
            if (struct.isSetPrincipalType()) {
                oprot.writeI32(struct.principalType.getValue());
            }
            if (struct.isSetGrantInfo()) {
                struct.grantInfo.write((TProtocol)oprot);
            }
            if (struct.isSetAuthorizer()) {
                oprot.writeString(struct.authorizer);
            }
        }

        public void read(TProtocol prot, HiveObjectPrivilege struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            BitSet incoming = iprot.readBitSet(5);
            if (incoming.get(0)) {
                struct.hiveObject = new HiveObjectRef();
                struct.hiveObject.read((TProtocol)iprot);
                struct.setHiveObjectIsSet(true);
            }
            if (incoming.get(1)) {
                struct.principalName = iprot.readString();
                struct.setPrincipalNameIsSet(true);
            }
            if (incoming.get(2)) {
                struct.principalType = PrincipalType.findByValue(iprot.readI32());
                struct.setPrincipalTypeIsSet(true);
            }
            if (incoming.get(3)) {
                struct.grantInfo = new PrivilegeGrantInfo();
                struct.grantInfo.read((TProtocol)iprot);
                struct.setGrantInfoIsSet(true);
            }
            if (incoming.get(4)) {
                struct.authorizer = iprot.readString();
                struct.setAuthorizerIsSet(true);
            }
        }
    }

    private static class HiveObjectPrivilegeStandardScheme
    extends StandardScheme<HiveObjectPrivilege> {
        private HiveObjectPrivilegeStandardScheme() {
        }

        public void read(TProtocol iprot, HiveObjectPrivilege struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 12) {
                            struct.hiveObject = new HiveObjectRef();
                            struct.hiveObject.read(iprot);
                            struct.setHiveObjectIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 11) {
                            struct.principalName = iprot.readString();
                            struct.setPrincipalNameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 8) {
                            struct.principalType = PrincipalType.findByValue(iprot.readI32());
                            struct.setPrincipalTypeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 12) {
                            struct.grantInfo = new PrivilegeGrantInfo();
                            struct.grantInfo.read(iprot);
                            struct.setGrantInfoIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 11) {
                            struct.authorizer = iprot.readString();
                            struct.setAuthorizerIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, HiveObjectPrivilege struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.hiveObject != null) {
                oprot.writeFieldBegin(HIVE_OBJECT_FIELD_DESC);
                struct.hiveObject.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.principalName != null) {
                oprot.writeFieldBegin(PRINCIPAL_NAME_FIELD_DESC);
                oprot.writeString(struct.principalName);
                oprot.writeFieldEnd();
            }
            if (struct.principalType != null) {
                oprot.writeFieldBegin(PRINCIPAL_TYPE_FIELD_DESC);
                oprot.writeI32(struct.principalType.getValue());
                oprot.writeFieldEnd();
            }
            if (struct.grantInfo != null) {
                oprot.writeFieldBegin(GRANT_INFO_FIELD_DESC);
                struct.grantInfo.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.authorizer != null) {
                oprot.writeFieldBegin(AUTHORIZER_FIELD_DESC);
                oprot.writeString(struct.authorizer);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }
}

