/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.hll;

import java.util.Arrays;
import java.util.List;
import org.apache.datasketches.hive.common.BytesWritableHelper;
import org.apache.datasketches.hll.HllSketch;
import org.apache.datasketches.memory.Memory;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.io.BytesWritable;

@Description(name="SketchToEstimateAndErrorBounds", value="_FUNC_(sketch, kappa)", extended="Returns an estimate of distinct count and error bounds from a given HllSketch. Optional kappa is a number of standard deviations from the mean: 1, 2 or 3 (default 2). The result is three double values: estimate, lower bound and upper bound.")
public class SketchToEstimateAndErrorBoundsUDF
extends UDF {
    private static final int DEFAULT_KAPPA = 2;

    public List<Double> evaluate(BytesWritable serializedSketch) {
        return this.evaluate(serializedSketch, 2);
    }

    public List<Double> evaluate(BytesWritable serializedSketch, int kappa) {
        if (serializedSketch == null) {
            return null;
        }
        HllSketch sketch = HllSketch.wrap((Memory)BytesWritableHelper.wrapAsMemory(serializedSketch));
        return Arrays.asList(sketch.getEstimate(), sketch.getLowerBound(kappa), sketch.getUpperBound(kappa));
    }
}

