/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn.jdbc.queries;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.apache.hadoop.hive.metastore.DatabaseProduct;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.txn.jdbc.QueryHandler;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class DbTimeHandler
implements QueryHandler<Timestamp> {
    @Override
    public String getParameterizedQueryString(DatabaseProduct databaseProduct) throws MetaException {
        return databaseProduct.getDBTime();
    }

    @Override
    public SqlParameterSource getQueryParameters() {
        return new MapSqlParameterSource();
    }

    public Timestamp extractData(ResultSet rs) throws SQLException, DataAccessException {
        if (rs.next()) {
            return rs.getTimestamp(1);
        }
        throw new EmptyResultDataAccessException("Could not obtain DB time", 1);
    }
}

