/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn.jdbc.functions;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hive.metastore.api.FindNextCompactRequest;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.txn.entities.CompactionInfo;
import org.apache.hadoop.hive.metastore.txn.jdbc.MultiDataSourceJdbcResource;
import org.apache.hadoop.hive.metastore.txn.jdbc.TransactionalFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class NextCompactionFunction
implements TransactionalFunction<CompactionInfo> {
    private static final Logger LOG = LoggerFactory.getLogger(NextCompactionFunction.class);
    private static final String updateStatement = "UPDATE \"COMPACTION_QUEUE\" SET  \"CQ_WORKER_ID\" = :workerId,  \"CQ_WORKER_VERSION\" = :workerVersion,  \"CQ_START\" = :now,  \"CQ_STATE\" = :newState WHERE \"CQ_ID\" = :id AND \"CQ_STATE\"= :oldState";
    private final FindNextCompactRequest request;
    private final Timestamp currentDbTime;
    private final long poolTimeout;

    public NextCompactionFunction(FindNextCompactRequest request, Timestamp currentDbTime, long poolTimeout) {
        this.request = request;
        this.currentDbTime = currentDbTime;
        this.poolTimeout = poolTimeout;
    }

    @Override
    public CompactionInfo execute(MultiDataSourceJdbcResource jdbcResource) throws MetaException {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT \"CQ_ID\", \"CQ_DATABASE\", \"CQ_TABLE\", \"CQ_PARTITION\", \"CQ_TYPE\", \"CQ_WORKER_ID\", \"CQ_WORKER_VERSION\", \"CQ_POOL_NAME\", \"CQ_NUMBER_OF_BUCKETS\", \"CQ_ORDER_BY\", \"CQ_TBLPROPERTIES\" FROM \"COMPACTION_QUEUE\" WHERE \"CQ_STATE\" = :state AND ");
        boolean hasPoolName = StringUtils.isNotBlank((CharSequence)this.request.getPoolName());
        if (hasPoolName) {
            sb.append("\"CQ_POOL_NAME\"= :poolName");
        } else {
            sb.append("\"CQ_POOL_NAME\" IS NULL OR  \"CQ_ENQUEUE_TIME\" < (").append(TxnUtils.getEpochFn(jdbcResource.getDatabaseProduct())).append(" - ").append(this.poolTimeout).append(")");
        }
        sb.append(" ORDER BY \"CQ_ID\" ASC");
        MapSqlParameterSource params = new MapSqlParameterSource().addValue("state", (Object)Character.toString('i'), 1);
        if (StringUtils.isNotBlank((CharSequence)this.request.getPoolName())) {
            params.addValue("poolName", (Object)this.request.getPoolName());
        }
        final NamedParameterJdbcTemplate jdbcTemplate = jdbcResource.getJdbcTemplate();
        return (CompactionInfo)jdbcTemplate.query(sb.toString(), (SqlParameterSource)params, (ResultSetExtractor)new ResultSetExtractor<CompactionInfo>(){

            public CompactionInfo extractData(ResultSet rs) throws SQLException, DataAccessException {
                while (rs.next()) {
                    CompactionInfo info = new CompactionInfo();
                    info.id = rs.getLong("CQ_ID");
                    info.dbname = rs.getString("CQ_DATABASE");
                    info.tableName = rs.getString("CQ_TABLE");
                    info.partName = rs.getString("CQ_PARTITION");
                    info.type = TxnUtils.dbCompactionType2ThriftType(rs.getString("CQ_TYPE").charAt(0));
                    info.workerId = rs.getString("CQ_WORKER_ID");
                    info.workerVersion = rs.getString("CQ_WORKER_VERSION");
                    info.poolName = rs.getString("CQ_POOL_NAME");
                    info.numberOfBuckets = rs.getInt("CQ_NUMBER_OF_BUCKETS");
                    info.orderByClause = rs.getString("CQ_ORDER_BY");
                    info.properties = rs.getString("CQ_TBLPROPERTIES");
                    int updCount = jdbcTemplate.update(NextCompactionFunction.updateStatement, (SqlParameterSource)new MapSqlParameterSource().addValue("id", (Object)info.id).addValue("workerId", (Object)NextCompactionFunction.this.request.getWorkerId()).addValue("workerVersion", (Object)NextCompactionFunction.this.request.getWorkerVersion()).addValue("now", (Object)NextCompactionFunction.this.currentDbTime.getTime()).addValue("newState", (Object)Character.toString('w'), 1).addValue("oldState", (Object)Character.toString('i'), 1));
                    if (updCount == 1) {
                        return info;
                    }
                    if (updCount == 0) {
                        LOG.debug("Compaction item ({}) already picked up another Worker {} (version: {})", new Object[]{info, info.workerId, info.workerVersion});
                        continue;
                    }
                    LOG.error("Unable to set to cq_state={} for compaction record: {}. updCnt={}. workerId={}. workerVersion={}", new Object[]{Character.valueOf('w'), info, updCount, NextCompactionFunction.this.request.getWorkerId(), NextCompactionFunction.this.request.getWorkerVersion()});
                    throw new SQLException("Update failed for compaction: " + info);
                }
                LOG.debug("No compactions found ready to compact");
                return null;
            }
        });
    }
}

