/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn.jdbc.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.hadoop.hive.metastore.DatabaseProduct;
import org.apache.hadoop.hive.metastore.txn.TxnHandler;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.txn.jdbc.ConditionalCommand;
import org.apache.hadoop.hive.metastore.txn.jdbc.ParameterizedBatchCommand;
import org.apache.hadoop.hive.metastore.txn.jdbc.ParameterizedCommand;
import org.springframework.jdbc.core.ParameterizedPreparedStatementSetter;

public class AddWriteIdsToMinHistoryCommand
implements ParameterizedBatchCommand<Object[]>,
ConditionalCommand {
    private static final String MIN_HISTORY_WRITE_ID_INSERT_QUERY = "INSERT INTO \"MIN_HISTORY_WRITE_ID\" (\"MH_TXNID\", \"MH_DATABASE\", \"MH_TABLE\", \"MH_WRITEID\") VALUES (?, ?, ?, ?)";
    private final List<Object[]> params = new ArrayList<Object[]>();

    public AddWriteIdsToMinHistoryCommand(long txnId, Map<String, Long> minOpenWriteIds) {
        for (Map.Entry<String, Long> validWriteId : minOpenWriteIds.entrySet()) {
            String[] names = TxnUtils.getDbTableName(validWriteId.getKey());
            this.params.add(new Object[]{txnId, names[0], names[1], validWriteId.getValue()});
        }
    }

    @Override
    public String getParameterizedQueryString(DatabaseProduct databaseProduct) {
        return MIN_HISTORY_WRITE_ID_INSERT_QUERY;
    }

    @Override
    public List<Object[]> getQueryParameters() {
        return this.params;
    }

    @Override
    public ParameterizedPreparedStatementSetter<Object[]> getPreparedStatementSetter() {
        return (ps, argument) -> {
            ps.setLong(1, (Long)argument[0]);
            ps.setString(2, argument[1].toString());
            ps.setString(3, argument[2].toString());
            ps.setLong(4, (Long)argument[3]);
        };
    }

    @Override
    public Function<Integer, Boolean> resultPolicy() {
        return ParameterizedCommand.EXACTLY_ONE_ROW;
    }

    @Override
    public boolean shouldBeUsed(DatabaseProduct databaseProduct) {
        return TxnHandler.ConfVars.useMinHistoryWriteId();
    }

    @Override
    public void onError(DatabaseProduct databaseProduct, Exception e) {
        if (databaseProduct.isTableNotExistsError(e)) {
            TxnHandler.ConfVars.setUseMinHistoryWriteId(false);
        }
    }
}

