/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn.jdbc;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.DatabaseProduct;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.datasource.DataSourceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoPoolConnectionPool
implements DataSource {
    private static final Logger LOG = LoggerFactory.getLogger(NoPoolConnectionPool.class);
    private final Configuration conf;
    private final DatabaseProduct dbProduct;
    private Driver driver;
    private String connString;
    private String user;
    private String passwd;

    public NoPoolConnectionPool(Configuration conf, DatabaseProduct dbProduct) {
        this.conf = conf;
        this.dbProduct = dbProduct;
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.user == null) {
            this.user = DataSourceProvider.getMetastoreJdbcUser(this.conf);
            this.passwd = DataSourceProvider.getMetastoreJdbcPasswd(this.conf);
        }
        return this.getConnection(this.user, this.passwd);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        if (this.driver == null) {
            String driverName = MetastoreConf.getVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CONNECTION_DRIVER);
            if (driverName == null || driverName.equals("")) {
                String msg = "JDBC driver for transaction db not set in configuration file, need to set " + MetastoreConf.ConfVars.CONNECTION_DRIVER.getVarname();
                LOG.error(msg);
                throw new RuntimeException(msg);
            }
            try {
                LOG.info("Going to load JDBC driver {}", (Object)driverName);
                this.driver = (Driver)Class.forName(driverName).newInstance();
            }
            catch (InstantiationException e) {
                throw new RuntimeException("Unable to instantiate driver " + driverName + ", " + e.getMessage(), e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Unable to access driver " + driverName + ", " + e.getMessage(), e);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Unable to find driver " + driverName + ", " + e.getMessage(), e);
            }
            this.connString = MetastoreConf.getVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CONNECT_URL_KEY);
        }
        try {
            String prepareStmt;
            LOG.info("Connecting to transaction db with connection string {}", (Object)this.connString);
            Properties connectionProps = new Properties();
            connectionProps.setProperty("user", username);
            connectionProps.setProperty("password", password);
            Connection conn = this.driver.connect(this.connString, connectionProps);
            String string = prepareStmt = this.dbProduct != null ? this.dbProduct.getPrepareTxnStmt() : null;
            if (prepareStmt != null) {
                try (Statement stmt = conn.createStatement();){
                    stmt.execute(prepareStmt);
                }
            }
            conn.setAutoCommit(false);
            return conn;
        }
        catch (SQLException e) {
            throw new RuntimeException("Unable to connect to transaction manager using " + this.connString + ", " + e.getMessage(), e);
        }
    }

    @Override
    public PrintWriter getLogWriter() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setLogWriter(PrintWriter out) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setLoginTimeout(int seconds) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getLoginTimeout() {
        throw new UnsupportedOperationException();
    }

    @Override
    public java.util.logging.Logger getParentLogger() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        throw new UnsupportedOperationException();
    }
}

