/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.model;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.jdo.JDODetachedFieldAccessException;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.annotations.NotPersistent;
import org.apache.hadoop.hive.metastore.model.MColumn;
import org.apache.hadoop.hive.metastore.model.MFieldSchema;
import org.datanucleus.enhancement.Detachable;
import org.datanucleus.enhancement.ExecutionContextReference;
import org.datanucleus.enhancement.Persistable;
import org.datanucleus.enhancement.StateManager;
import org.datanucleus.enhancer.EnhancementHelper;
import org.datanucleus.identity.LongId;

public class MColumnDescriptor
implements Detachable,
Persistable {
    private List<MColumn> fields;
    @NotPersistent
    private List<MFieldSchema> columns;
    private long id;
    protected transient StateManager dnStateManager;
    protected transient byte dnFlags;
    protected Object[] dnDetachedState;
    private static final String[] dnFieldNames = MColumnDescriptor.__dnFieldNamesInit();
    private static final int dnInheritedFieldCount = MColumnDescriptor.__dnGetInheritedFieldCount();

    public MColumnDescriptor() {
    }

    public MColumnDescriptor(List<MFieldSchema> cols) {
        this.fields = cols.stream().map(schema -> new MColumn(this, schema.getName(), schema.getType(), schema.getComment())).collect(Collectors.toList());
    }

    public List<MColumn> getFields() {
        return MColumnDescriptor.dnGetfields(this);
    }

    public List<MFieldSchema> getCols() {
        if (this.columns != null) {
            return this.columns;
        }
        this.columns = new ArrayList<MFieldSchema>();
        if (MColumnDescriptor.dnGetfields(this) != null) {
            this.columns = MColumnDescriptor.dnGetfields(this).stream().map(column -> new MFieldSchema(column.getName(), column.getType(), column.getComment())).collect(Collectors.toList());
        }
        return this.columns;
    }

    public long getId() {
        return MColumnDescriptor.dnGetid(this);
    }

    static {
        EnhancementHelper.registerClass((Class)MColumnDescriptor.___dn$loadClass("org.apache.hadoop.hive.metastore.model.MColumnDescriptor"), (Persistable)new MColumnDescriptor());
    }

    public void dnCopyKeyFieldsFromObjectId(Persistable.ObjectIdFieldConsumer fc, Object oid) {
        if (fc == null) {
            throw new IllegalArgumentException("ObjectIdFieldConsumer is null");
        }
        if (!(oid instanceof LongId)) {
            throw new ClassCastException("oid is not instanceof org.datanucleus.identity.LongId");
        }
        LongId o = (LongId)oid;
        fc.storeLongField(1, o.getKey());
    }

    protected void dnCopyKeyFieldsFromObjectId(Object oid) {
        if (!(oid instanceof LongId)) {
            throw new ClassCastException("key class is not org.datanucleus.identity.LongId or null");
        }
        LongId o = (LongId)oid;
        this.id = o.getKey();
    }

    public void dnCopyKeyFieldsToObjectId(Object oid) {
        throw new JDOFatalInternalException("It's illegal to call dnCopyKeyFieldsToObjectId for a class with single-field identity.");
    }

    public void dnCopyKeyFieldsToObjectId(Persistable.ObjectIdFieldSupplier fs, Object paramObject) {
        throw new JDOFatalInternalException("It's illegal to call dnCopyKeyFieldsToObjectId for a class with single-field identity.");
    }

    public final Object dnGetObjectId() {
        if (this.dnStateManager != null) {
            return this.dnStateManager.getObjectId((Persistable)this);
        }
        if (!this.dnIsDetached()) {
            return null;
        }
        return this.dnDetachedState[0];
    }

    public final Object dnGetVersion() {
        if (this.dnStateManager != null) {
            return this.dnStateManager.getVersion((Persistable)this);
        }
        if (!this.dnIsDetached()) {
            return null;
        }
        return this.dnDetachedState[1];
    }

    protected final void dnPreSerialize() {
        if (this.dnStateManager != null) {
            this.dnStateManager.preSerialize((Persistable)this);
        }
    }

    public final ExecutionContextReference dnGetExecutionContext() {
        return this.dnStateManager != null ? this.dnStateManager.getExecutionContextReference() : null;
    }

    public final StateManager dnGetStateManager() {
        return this.dnStateManager;
    }

    public final Object dnGetTransactionalObjectId() {
        return this.dnStateManager != null ? this.dnStateManager.getTransactionalObjectId((Persistable)this) : null;
    }

    public final boolean dnIsDeleted() {
        return this.dnStateManager != null ? this.dnStateManager.isDeleted((Persistable)this) : false;
    }

    public final boolean dnIsDirty() {
        if (this.dnStateManager != null) {
            return this.dnStateManager.isDirty((Persistable)this);
        }
        if (!this.dnIsDetached()) {
            return false;
        }
        return ((BitSet)this.dnDetachedState[3]).length() > 0;
    }

    public final boolean dnIsNew() {
        return this.dnStateManager != null ? this.dnStateManager.isNew((Persistable)this) : false;
    }

    public final boolean dnIsPersistent() {
        return this.dnStateManager != null ? this.dnStateManager.isPersistent((Persistable)this) : false;
    }

    public final boolean dnIsTransactional() {
        return this.dnStateManager != null ? this.dnStateManager.isTransactional((Persistable)this) : false;
    }

    public void dnMakeDirty(String fieldName) {
        if (this.dnStateManager != null) {
            this.dnStateManager.makeDirty((Persistable)this, fieldName);
        }
        if (this.dnIsDetached() && fieldName != null) {
            String fldName = null;
            fldName = fieldName.indexOf(46) >= 0 ? fieldName.substring(fieldName.lastIndexOf(46) + 1) : fieldName;
            int i = 0;
            while (i < dnFieldNames.length) {
                if (dnFieldNames[i].equals(fldName)) {
                    if (((BitSet)this.dnDetachedState[2]).get(i + dnInheritedFieldCount)) {
                        ((BitSet)this.dnDetachedState[3]).set(i + dnInheritedFieldCount);
                        return;
                    }
                    throw new JDODetachedFieldAccessException("You have just attempted to access a field/property that hasn't been detached. Please detach it first before performing this operation");
                }
                ++i;
            }
        }
    }

    public Object dnNewObjectIdInstance() {
        return new LongId(this.getClass(), this.id);
    }

    public Object dnNewObjectIdInstance(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (!(key instanceof String)) {
            return new LongId(this.getClass(), (Long)key);
        }
        return new LongId(this.getClass(), (String)key);
    }

    public final void dnProvideFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argment is null");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.dnProvideField(indices[i]);
            } while (--i >= 0);
        }
    }

    public final void dnReplaceFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argument is null");
        }
        int i = indices.length;
        if (i > 0) {
            int j = 0;
            do {
                this.dnReplaceField(indices[j]);
            } while (++j < i);
        }
    }

    public final void dnReplaceFlags() {
        if (this.dnStateManager != null) {
            this.dnFlags = this.dnStateManager.replacingFlags((Persistable)this);
        }
    }

    public final synchronized void dnReplaceStateManager(StateManager sm) {
        if (this.dnStateManager != null) {
            this.dnStateManager = this.dnStateManager.replacingStateManager((Persistable)this, sm);
        } else {
            this.dnStateManager = sm;
            this.dnFlags = 1;
        }
    }

    public final synchronized void dnReplaceDetachedState() {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        this.dnDetachedState = this.dnStateManager.replacingDetachedState((Detachable)this, this.dnDetachedState);
    }

    public boolean dnIsDetached() {
        return this.dnStateManager == null && this.dnDetachedState != null;
    }

    public Persistable dnNewInstance(StateManager sm) {
        MColumnDescriptor result = new MColumnDescriptor();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        return result;
    }

    public Persistable dnNewInstance(StateManager sm, Object obj) {
        MColumnDescriptor result = new MColumnDescriptor();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        result.dnCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    public void dnReplaceField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.fields = (List)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 1: {
                this.id = this.dnStateManager.replacingLongField((Persistable)this, index);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void dnProvideField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.dnStateManager.providedObjectField((Persistable)this, index, this.fields);
                break;
            }
            case 1: {
                this.dnStateManager.providedLongField((Persistable)this, index, this.id);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    protected final void dnCopyField(MColumnDescriptor obj, int index) {
        switch (index) {
            case 0: {
                this.fields = obj.fields;
                break;
            }
            case 1: {
                this.id = obj.id;
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void dnCopyFields(Object obj, int[] indices) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof MColumnDescriptor)) {
            throw new IllegalArgumentException("object is not an object of type org.apache.hadoop.hive.metastore.model.MColumnDescriptor");
        }
        MColumnDescriptor other = (MColumnDescriptor)obj;
        if (this.dnStateManager != other.dnStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.dnCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __dnFieldNamesInit() {
        return new String[]{"fields", "id"};
    }

    protected static int __dnGetInheritedFieldCount() {
        return 0;
    }

    protected static int dnGetManagedFieldCount() {
        return 2;
    }

    public static Class ___dn$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private static List dnGetfields(MColumnDescriptor objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 0)) {
            return (List)objPC.dnStateManager.getObjectField((Persistable)objPC, 0, objPC.fields);
        }
        if (objPC.dnIsDetached() && !((BitSet)objPC.dnDetachedState[2]).get(0) && !((BitSet)objPC.dnDetachedState[3]).get(0)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"fields\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.fields;
    }

    private static void dnSetfields(MColumnDescriptor objPC, List val) {
        if (objPC.dnStateManager == null) {
            objPC.fields = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 0, objPC.fields, (Object)val);
        }
        if (objPC.dnIsDetached()) {
            ((BitSet)objPC.dnDetachedState[3]).set(0);
        }
    }

    private static long dnGetid(MColumnDescriptor objPC) {
        return objPC.id;
    }

    private static void dnSetid(MColumnDescriptor objPC, long val) {
        if (objPC.dnStateManager == null) {
            objPC.id = val;
        } else {
            objPC.dnStateManager.setLongField((Persistable)objPC, 1, objPC.id, val);
        }
        if (objPC.dnIsDetached()) {
            ((BitSet)objPC.dnDetachedState[3]).set(1);
        }
    }
}

