/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.cache;

import java.lang.invoke.StringConcatFactory;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.SkewedInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.cache.SharedCache;
import org.apache.hadoop.hive.metastore.utils.StringUtils;

public class CacheUtils {
    private static final String delimit = "\u0001";
    protected static final String HIVE_ENGINE = "hive";

    public static String buildCatalogKey(String catName) {
        return catName;
    }

    public static String buildDbKey(String catName, String dbName) {
        return CacheUtils.buildKey(catName.toLowerCase(), dbName.toLowerCase());
    }

    public static String buildDbKeyWithDelimiterSuffix(String catName, String dbName) {
        return StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001\u0002", delimit}, (String)CacheUtils.buildKey(catName.toLowerCase(), dbName.toLowerCase()));
    }

    public static String buildPartitionCacheKey(List<String> partVals) {
        return CollectionUtils.isNotEmpty(partVals) ? String.join((CharSequence)delimit, partVals) : "";
    }

    public static String buildTableKey(String catName, String dbName, String tableName) {
        return CacheUtils.buildKey(StringUtils.normalizeIdentifier((String)catName), StringUtils.normalizeIdentifier((String)dbName), StringUtils.normalizeIdentifier((String)tableName));
    }

    public static String buildTableColKey(String catName, String dbName, String tableName, String colName) {
        return CacheUtils.buildKey(catName, dbName, tableName, colName);
    }

    public static String buildKey(String ... elements) {
        return org.apache.commons.lang3.StringUtils.join((Object[])elements, (String)delimit);
    }

    public static String[] splitDbName(String key) {
        String[] names = key.split(delimit);
        assert (names.length == 2);
        return names;
    }

    public static String buildPartitonColStatsCacheKey(List<String> partVals, String colName) {
        return StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001\u0002\u0001", delimit}, (String)CacheUtils.buildPartitionCacheKey(partVals), colName);
    }

    static Table assemble(SharedCache.TableWrapper wrapper, SharedCache sharedCache) {
        Table t = wrapper.getTable().deepCopy();
        if (wrapper.getSdHash() != null) {
            StorageDescriptor sdCopy = sharedCache.getSdFromCache(wrapper.getSdHash()).deepCopy();
            if (sdCopy.getBucketCols() == null) {
                sdCopy.setBucketCols(Collections.emptyList());
            }
            if (sdCopy.getSortCols() == null) {
                sdCopy.setSortCols(Collections.emptyList());
            }
            if (sdCopy.getSkewedInfo() == null) {
                sdCopy.setSkewedInfo(new SkewedInfo(Collections.emptyList(), Collections.emptyList(), Collections.emptyMap()));
            }
            sdCopy.setLocation(wrapper.getLocation());
            sdCopy.setParameters(wrapper.getParameters());
            t.setSd(sdCopy);
        }
        return t;
    }

    static Partition assemble(SharedCache.PartitionWrapper wrapper, SharedCache sharedCache) {
        Partition p = wrapper.getPartition().deepCopy();
        if (wrapper.getSdHash() != null) {
            StorageDescriptor sdCopy = sharedCache.getSdFromCache(wrapper.getSdHash()).deepCopy();
            if (sdCopy.getBucketCols() == null) {
                sdCopy.setBucketCols(Collections.emptyList());
            }
            if (sdCopy.getSortCols() == null) {
                sdCopy.setSortCols(Collections.emptyList());
            }
            if (sdCopy.getSkewedInfo() == null) {
                sdCopy.setSkewedInfo(new SkewedInfo(Collections.emptyList(), Collections.emptyList(), Collections.emptyMap()));
            }
            sdCopy.setLocation(wrapper.getLocation());
            sdCopy.setParameters(wrapper.getParameters());
            p.setSd(sdCopy);
        }
        return p;
    }

    public static boolean matches(String name, String pattern) {
        String[] subpatterns;
        for (String string : subpatterns = pattern.trim().split("\\|")) {
            String string2 = "(?i)" + string.replaceAll("\\?", ".{1}").replaceAll("\\*", ".*").replaceAll("\\^", "\\\\^").replaceAll("\\$", "\\\\$");
            if (!Pattern.matches(string2, StringUtils.normalizeIdentifier((String)name))) continue;
            return true;
        }
        return false;
    }
}

