/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.secretsmanager.caching.cache;

import com.amazonaws.secretsmanager.caching.SecretCacheConfiguration;
import com.amazonaws.secretsmanager.caching.cache.LRUCache;
import com.amazonaws.secretsmanager.caching.cache.SecretCacheObject;
import com.amazonaws.secretsmanager.caching.cache.SecretCacheVersion;
import com.amazonaws.services.secretsmanager.AWSSecretsManager;
import com.amazonaws.services.secretsmanager.model.DescribeSecretRequest;
import com.amazonaws.services.secretsmanager.model.DescribeSecretResult;
import com.amazonaws.services.secretsmanager.model.GetSecretValueResult;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;

public class SecretCacheItem
extends SecretCacheObject<DescribeSecretResult> {
    private LRUCache<String, SecretCacheVersion> versions = new LRUCache(10);
    private long nextRefreshTime = 0L;

    public SecretCacheItem(String secretId, AWSSecretsManager client, SecretCacheConfiguration config) {
        super(secretId, client, config);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof SecretCacheItem) {
            return Objects.equals(this.secretId, ((SecretCacheItem)obj).secretId);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return String.format("%s", this.secretId).hashCode();
    }

    @Override
    public String toString() {
        return String.format("SecretCacheItem: %s", this.secretId);
    }

    @Override
    protected boolean isRefreshNeeded() {
        if (super.isRefreshNeeded()) {
            return true;
        }
        if (null != this.exception) {
            return false;
        }
        return System.currentTimeMillis() >= this.nextRefreshTime;
    }

    @Override
    protected DescribeSecretResult executeRefresh() {
        DescribeSecretResult describeSecretResult = this.client.describeSecret(this.updateUserAgent(new DescribeSecretRequest().withSecretId(this.secretId)));
        long ttl = this.config.getCacheItemTTL();
        this.nextRefreshTime = System.currentTimeMillis() + ThreadLocalRandom.current().nextLong(ttl / 2L, ttl + 1L);
        return describeSecretResult;
    }

    private SecretCacheVersion getVersion(DescribeSecretResult describeResult) {
        if (null == describeResult) {
            return null;
        }
        if (null == describeResult.getVersionIdsToStages()) {
            return null;
        }
        Optional<String> currentVersionId = describeResult.getVersionIdsToStages().entrySet().stream().filter(Objects::nonNull).filter(x -> x.getValue() != null).filter(x -> ((List)x.getValue()).contains(this.config.getVersionStage())).map(x -> (String)x.getKey()).findFirst();
        if (currentVersionId.isPresent()) {
            SecretCacheVersion version = this.versions.get(currentVersionId.get());
            if (null == version) {
                this.versions.putIfAbsent(currentVersionId.get(), new SecretCacheVersion(this.secretId, currentVersionId.get(), this.client, this.config));
                version = this.versions.get(currentVersionId.get());
            }
            return version;
        }
        return null;
    }

    @Override
    protected GetSecretValueResult getSecretValue(DescribeSecretResult describeResult) {
        SecretCacheVersion version = this.getVersion(describeResult);
        if (null == version) {
            return null;
        }
        return version.getSecretValue();
    }
}

