/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.secretsmanager.caching;

import com.amazonaws.secretsmanager.caching.SecretCacheConfiguration;
import com.amazonaws.secretsmanager.caching.cache.LRUCache;
import com.amazonaws.secretsmanager.caching.cache.SecretCacheItem;
import com.amazonaws.services.secretsmanager.AWSSecretsManager;
import com.amazonaws.services.secretsmanager.AWSSecretsManagerClientBuilder;
import com.amazonaws.services.secretsmanager.model.GetSecretValueResult;
import java.nio.ByteBuffer;

public class SecretCache
implements AutoCloseable {
    private final LRUCache<String, SecretCacheItem> cache;
    private final SecretCacheConfiguration config;
    private final AWSSecretsManager client;

    public SecretCache() {
        this(AWSSecretsManagerClientBuilder.standard());
    }

    public SecretCache(AWSSecretsManagerClientBuilder builder) {
        this(null == builder ? (AWSSecretsManager)AWSSecretsManagerClientBuilder.standard().build() : (AWSSecretsManager)builder.build());
    }

    public SecretCache(AWSSecretsManager client) {
        this(new SecretCacheConfiguration().withClient(client));
    }

    public SecretCache(SecretCacheConfiguration config) {
        if (null == config) {
            config = new SecretCacheConfiguration();
        }
        this.cache = new LRUCache(config.getMaxCacheSize());
        this.config = config;
        this.client = config.getClient() != null ? config.getClient() : (AWSSecretsManager)AWSSecretsManagerClientBuilder.standard().build();
    }

    private SecretCacheItem getCachedSecret(String secretId) {
        SecretCacheItem secret = this.cache.get(secretId);
        if (null == secret) {
            this.cache.putIfAbsent(secretId, new SecretCacheItem(secretId, this.client, this.config));
            secret = this.cache.get(secretId);
        }
        return secret;
    }

    public String getSecretString(String secretId) {
        SecretCacheItem secret = this.getCachedSecret(secretId);
        GetSecretValueResult gsv = secret.getSecretValue();
        if (null == gsv) {
            return null;
        }
        return gsv.getSecretString();
    }

    public ByteBuffer getSecretBinary(String secretId) {
        SecretCacheItem secret = this.getCachedSecret(secretId);
        GetSecretValueResult gsv = secret.getSecretValue();
        if (null == gsv) {
            return null;
        }
        return gsv.getSecretBinary();
    }

    public boolean refreshNow(String secretId) throws InterruptedException {
        SecretCacheItem secret = this.getCachedSecret(secretId);
        return secret.refreshNow();
    }

    @Override
    public void close() {
        this.cache.clear();
    }
}

