/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.authorization.checker;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.pac4j.core.authorization.authorizer.Authorizer;
import org.pac4j.core.authorization.authorizer.CsrfAuthorizer;
import org.pac4j.core.authorization.authorizer.IsAnonymousAuthorizer;
import org.pac4j.core.authorization.authorizer.IsAuthenticatedAuthorizer;
import org.pac4j.core.authorization.authorizer.IsFullyAuthenticatedAuthorizer;
import org.pac4j.core.authorization.authorizer.IsRememberedAuthorizer;
import org.pac4j.core.authorization.checker.AuthorizationChecker;
import org.pac4j.core.client.Client;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.util.CommonHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAuthorizationChecker
implements AuthorizationChecker {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultAuthorizationChecker.class);
    static final CsrfAuthorizer CSRF_AUTHORIZER = new CsrfAuthorizer();
    static final IsAnonymousAuthorizer IS_ANONYMOUS_AUTHORIZER = new IsAnonymousAuthorizer();
    static final IsAuthenticatedAuthorizer IS_AUTHENTICATED_AUTHORIZER = new IsAuthenticatedAuthorizer();
    static final IsFullyAuthenticatedAuthorizer IS_FULLY_AUTHENTICATED_AUTHORIZER = new IsFullyAuthenticatedAuthorizer();
    static final IsRememberedAuthorizer IS_REMEMBERED_AUTHORIZER = new IsRememberedAuthorizer();

    @Override
    public boolean isAuthorized(WebContext context, List<UserProfile> profiles, String authorizersValue, Map<String, Authorizer> authorizersMap, List<Client<? extends Credentials>> clients) {
        ArrayList<Authorizer> authorizers = new ArrayList<Authorizer>();
        String authorizerNames = authorizersValue;
        if (CommonHelper.isBlank(authorizerNames)) {
            authorizerNames = this.computeDefaultAuthorizers(clients);
        }
        String[] names = authorizerNames.split(",");
        int nb = names.length;
        for (int i = 0; i < nb; ++i) {
            String name = names[i].trim();
            if ("csrfCheck".equalsIgnoreCase(name)) {
                authorizers.add(CSRF_AUTHORIZER);
                continue;
            }
            if ("isAnonymous".equalsIgnoreCase(name)) {
                authorizers.add(IS_ANONYMOUS_AUTHORIZER);
                continue;
            }
            if ("isAuthenticated".equalsIgnoreCase(name)) {
                authorizers.add(IS_AUTHENTICATED_AUTHORIZER);
                continue;
            }
            if ("isFullyAuthenticated".equalsIgnoreCase(name)) {
                authorizers.add(IS_FULLY_AUTHENTICATED_AUTHORIZER);
                continue;
            }
            if ("isRemembered".equalsIgnoreCase(name)) {
                authorizers.add(IS_REMEMBERED_AUTHORIZER);
                continue;
            }
            if ("none".equalsIgnoreCase(name)) continue;
            CommonHelper.assertNotNull("authorizersMap", authorizersMap);
            Authorizer result = null;
            for (Map.Entry<String, Authorizer> entry : authorizersMap.entrySet()) {
                if (!CommonHelper.areEqualsIgnoreCaseAndTrim(entry.getKey(), name)) continue;
                result = entry.getValue();
                break;
            }
            CommonHelper.assertNotNull("authorizersMap['" + name + "']", result);
            authorizers.add(result);
        }
        return this.isAuthorized(context, profiles, authorizers);
    }

    protected String computeDefaultAuthorizers(List<Client<? extends Credentials>> clients) {
        for (Client<? extends Credentials> client : clients) {
            if (!(client instanceof IndirectClient)) continue;
            return "csrfCheck";
        }
        return "none";
    }

    protected boolean isAuthorized(WebContext context, List<UserProfile> profiles, List<Authorizer> authorizers) {
        CommonHelper.assertTrue(CommonHelper.isNotEmpty(profiles), "profiles must not be null or empty");
        if (CommonHelper.isNotEmpty(authorizers)) {
            for (Authorizer authorizer : authorizers) {
                boolean isAuthorized = authorizer.isAuthorized(context, profiles);
                LOGGER.debug("Checking authorizer: {} -> {}", (Object)authorizer, (Object)isAuthorized);
                if (isAuthorized) continue;
                return false;
            }
        }
        return true;
    }
}

