/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.support;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Order;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.PathBuilder;
import com.querydsl.core.types.dsl.SimplePath;
import com.querydsl.jpa.EclipseLinkTemplates;
import com.querydsl.jpa.HQLTemplates;
import com.querydsl.jpa.JPQLQuery;
import com.querydsl.jpa.JPQLTemplates;
import com.querydsl.jpa.impl.AbstractJPAQuery;
import com.querydsl.jpa.impl.JPAQuery;
import jakarta.persistence.EntityManager;
import java.util.List;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.provider.PersistenceProvider;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.querydsl.QSort;
import org.springframework.util.Assert;

public class Querydsl {
    private final EntityManager em;
    private final PersistenceProvider provider;
    private final PathBuilder<?> builder;

    public Querydsl(EntityManager em, PathBuilder<?> builder) {
        Assert.notNull((Object)em, (String)"EntityManager must not be null");
        Assert.notNull(builder, (String)"PathBuilder must not be null");
        this.em = em;
        this.provider = PersistenceProvider.fromEntityManager(em);
        this.builder = builder;
    }

    public <T> AbstractJPAQuery<T, JPAQuery<T>> createQuery() {
        return switch (this.provider) {
            case PersistenceProvider.ECLIPSELINK -> new JPAQuery(this.em, (JPQLTemplates)EclipseLinkTemplates.DEFAULT);
            case PersistenceProvider.HIBERNATE -> new JPAQuery(this.em, (JPQLTemplates)HQLTemplates.DEFAULT);
            default -> new JPAQuery(this.em);
        };
    }

    public AbstractJPAQuery<Object, JPAQuery<Object>> createQuery(EntityPath<?> ... paths) {
        Assert.notNull(paths, (String)"Paths must not be null");
        return (AbstractJPAQuery)this.createQuery().from(paths);
    }

    public <T> JPQLQuery<T> applyPagination(Pageable pageable, JPQLQuery<T> query) {
        Assert.notNull((Object)pageable, (String)"Pageable must not be null");
        Assert.notNull(query, (String)"JPQLQuery must not be null");
        if (pageable.isUnpaged()) {
            return query;
        }
        query.offset(pageable.getOffset());
        query.limit((long)pageable.getPageSize());
        return this.applySorting(pageable.getSort(), query);
    }

    public <T> JPQLQuery<T> applySorting(Sort sort, JPQLQuery<T> query) {
        Assert.notNull((Object)sort, (String)"Sort must not be null");
        Assert.notNull(query, (String)"Query must not be null");
        if (sort.isUnsorted()) {
            return query;
        }
        if (sort instanceof QSort) {
            QSort qsort = (QSort)sort;
            return this.addOrderByFrom(qsort, query);
        }
        return this.addOrderByFrom(sort, query);
    }

    private <T> JPQLQuery<T> addOrderByFrom(QSort qsort, JPQLQuery<T> query) {
        List orderSpecifiers = qsort.getOrderSpecifiers();
        return (JPQLQuery)query.orderBy(orderSpecifiers.toArray(new OrderSpecifier[0]));
    }

    private <T> JPQLQuery<T> addOrderByFrom(Sort sort, JPQLQuery<T> query) {
        Assert.notNull((Object)sort, (String)"Sort must not be null");
        Assert.notNull(query, (String)"Query must not be null");
        for (Sort.Order order : sort) {
            query.orderBy(new OrderSpecifier[]{this.toOrderSpecifier(order)});
        }
        return query;
    }

    private OrderSpecifier<?> toOrderSpecifier(Sort.Order order) {
        return new OrderSpecifier(order.isAscending() ? Order.ASC : Order.DESC, this.buildOrderPropertyPathFrom(order), this.toQueryDslNullHandling(order.getNullHandling()));
    }

    private OrderSpecifier.NullHandling toQueryDslNullHandling(Sort.NullHandling nullHandling) {
        Assert.notNull((Object)nullHandling, (String)"NullHandling must not be null");
        return switch (nullHandling) {
            case Sort.NullHandling.NULLS_FIRST -> OrderSpecifier.NullHandling.NullsFirst;
            case Sort.NullHandling.NULLS_LAST -> OrderSpecifier.NullHandling.NullsLast;
            default -> OrderSpecifier.NullHandling.Default;
        };
    }

    private Expression<?> buildOrderPropertyPathFrom(Sort.Order order) {
        Assert.notNull((Object)order, (String)"Order must not be null");
        PropertyPath path = PropertyPath.from((String)order.getProperty(), (Class)this.builder.getType());
        SimplePath sortPropertyExpression = this.builder;
        while (path != null) {
            sortPropertyExpression = !path.hasNext() && order.isIgnoreCase() && String.class.equals((Object)path.getType()) ? Expressions.stringPath((Path)((Path)sortPropertyExpression), (String)path.getSegment()).lower() : Expressions.path((Class)path.getType(), (Path)((Path)sortPropertyExpression), (String)path.getSegment());
            path = path.next();
        }
        return sortPropertyExpression;
    }

    Expression<?> createExpression(String property) {
        Assert.notNull((Object)property, (String)"Property must not be null");
        PropertyPath path = PropertyPath.from((String)property, (Class)this.builder.getType());
        SimplePath sortPropertyExpression = this.builder;
        while (path != null) {
            sortPropertyExpression = !path.hasNext() && String.class.equals((Object)path.getType()) ? Expressions.stringPath((Path)((Path)sortPropertyExpression), (String)path.getSegment()) : Expressions.path((Class)path.getType(), (Path)((Path)sortPropertyExpression), (String)path.getSegment());
            path = path.next();
        }
        return sortPropertyExpression;
    }
}

