/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.nio.ByteBuffer;
import java.util.HashMap;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, SmallTests.class})
public class TestTableName {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestTableName.class);
    private static String[] emptyNames = new String[]{"", " "};
    private static String[] invalidNamespace = new String[]{":a", "%:a"};
    private static String[] legalTableNames = new String[]{"foo", "with-dash_under.dot", "_under_start_ok", "with-dash.with_underscore", "02-01-2012.my_table_01-02", "xyz._mytable_", "9_9_0.table_02", "dot1.dot2.table", "new.-mytable", "with-dash.with.dot", "legal..t2", "legal..legal.t2", "trailingdots..", "trailing.dots...", "ns:mytable", "ns:_mytable_", "ns:my_table_01-02"};
    private static String[] illegalTableNames = new String[]{".dot_start_illegal", "-dash_start_illegal", "spaces not ok", "-dash-.start_illegal", "new.table with space", "01 .table", "ns:-illegaldash", "new:.illegaldot", "new:illegalcolon1:", "new:illegalcolon1:2"};
    private static Names[] names = new Names[]{new Names("n1", "n1"), new Names("n2", "n2"), new Names("table1", "table1"), new Names("table2", "table2"), new Names("table2", "table1"), new Names("table1", "table2"), new Names("n1", "table1"), new Names("n1", "table1"), new Names("n2", "table2"), new Names("n2", "table2")};

    @Test
    public void testInvalidNamespace() {
        for (String tn : invalidNamespace) {
            Assert.assertThrows(IllegalArgumentException.class, () -> TableName.isLegalFullyQualifiedTableName((byte[])Bytes.toBytes((String)tn)));
        }
    }

    @Test
    public void testEmptyNamespaceName() {
        for (String nn : emptyNames) {
            Assert.assertThrows(IllegalArgumentException.class, () -> TableName.isLegalNamespaceName((byte[])Bytes.toBytes((String)nn)));
        }
    }

    @Test
    public void testEmptyTableName() {
        for (String tn : emptyNames) {
            Assert.assertThrows(IllegalArgumentException.class, () -> TableName.isLegalFullyQualifiedTableName((byte[])Bytes.toBytes((String)tn)));
        }
    }

    @Test
    public void testLegalHTableNames() {
        for (String tn : legalTableNames) {
            TableName.isLegalFullyQualifiedTableName((byte[])Bytes.toBytes((String)tn));
        }
    }

    @Test
    public void testIllegalHTableNames() {
        for (String tn : illegalTableNames) {
            Assert.assertThrows(IllegalArgumentException.class, () -> TableName.isLegalFullyQualifiedTableName((byte[])Bytes.toBytes((String)tn)));
        }
    }

    @Test
    public void testValueOf() {
        HashMap<String, TableName> inCache = new HashMap<String, TableName>();
        for (Names name : names) {
            inCache.put(name.nn, TableName.valueOf((String)name.ns, (String)name.tn));
        }
        for (Names name : names) {
            Assert.assertSame(inCache.get(name.nn), (Object)this.validateNames(TableName.valueOf((String)name.ns, (String)name.tn), name));
            Assert.assertSame(inCache.get(name.nn), (Object)this.validateNames(TableName.valueOf((byte[])name.nsb, (byte[])name.tnb), name));
            Assert.assertSame(inCache.get(name.nn), (Object)this.validateNames(TableName.valueOf((String)name.nn), name));
            Assert.assertSame(inCache.get(name.nn), (Object)this.validateNames(TableName.valueOf((byte[])name.nnb), name));
            Assert.assertSame(inCache.get(name.nn), (Object)this.validateNames(TableName.valueOf((ByteBuffer)ByteBuffer.wrap(name.nsb), (ByteBuffer)ByteBuffer.wrap(name.tnb)), name));
        }
    }

    private TableName validateNames(TableName expected, Names names) {
        Assert.assertEquals((Object)expected.getNameAsString(), (Object)names.nn);
        Assert.assertArrayEquals((byte[])expected.getName(), (byte[])names.nnb);
        Assert.assertEquals((Object)expected.getQualifierAsString(), (Object)names.tn);
        Assert.assertArrayEquals((byte[])expected.getQualifier(), (byte[])names.tnb);
        Assert.assertEquals((Object)expected.getNamespaceAsString(), (Object)names.ns);
        Assert.assertArrayEquals((byte[])expected.getNamespace(), (byte[])names.nsb);
        return expected;
    }

    static class Names {
        String ns;
        byte[] nsb;
        String tn;
        byte[] tnb;
        String nn;
        byte[] nnb;

        Names(String ns, String tn) {
            this.ns = ns;
            this.nsb = Bytes.toBytes((String)ns);
            this.tn = tn;
            this.tnb = Bytes.toBytes((String)tn);
            this.nn = this.ns + ":" + this.tn;
            this.nnb = Bytes.toBytes((String)this.nn);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Names)) {
                return false;
            }
            Names names = (Names)o;
            if (!this.ns.equals(names.ns)) {
                return false;
            }
            return this.tn.equals(names.tn);
        }

        public int hashCode() {
            int result = this.ns.hashCode();
            result = 31 * result + this.tn.hashCode();
            return result;
        }
    }
}

