/*
 * Decompiled with CFR 0.152.
 */
package org.agrona;

import java.io.File;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import org.agrona.BufferUtil;
import org.agrona.IoUtil;
import org.agrona.LangUtil;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.UnsafeBuffer;

public class MarkFile
implements AutoCloseable {
    private final int versionFieldOffset;
    private final int timestampFieldOffset;
    private final File parentDir;
    private final File markFile;
    private final MappedByteBuffer mappedBuffer;
    private final UnsafeBuffer buffer;
    private volatile boolean isClosed = false;

    public MarkFile(File directory, String filename, boolean warnIfDirectoryExists, boolean dirDeleteOnStart, int versionFieldOffset, int timestampFieldOffset, int totalFileLength, long timeoutMs, EpochClock epochClock, IntConsumer versionCheck, Consumer<String> logger) {
        MarkFile.validateOffsets(versionFieldOffset, timestampFieldOffset);
        MarkFile.ensureDirectoryExists(directory, filename, warnIfDirectoryExists, dirDeleteOnStart, versionFieldOffset, timestampFieldOffset, timeoutMs, epochClock, versionCheck, logger);
        this.parentDir = directory;
        this.markFile = new File(directory, filename);
        this.mappedBuffer = IoUtil.mapNewFile(this.markFile, totalFileLength);
        this.buffer = new UnsafeBuffer(this.mappedBuffer);
        this.versionFieldOffset = versionFieldOffset;
        this.timestampFieldOffset = timestampFieldOffset;
    }

    public MarkFile(File markFile, boolean shouldPreExist, int versionFieldOffset, int timestampFieldOffset, int totalFileLength, long timeoutMs, EpochClock epochClock, IntConsumer versionCheck, Consumer<String> logger) {
        MarkFile.validateOffsets(versionFieldOffset, timestampFieldOffset);
        this.parentDir = markFile.getParentFile();
        this.markFile = markFile;
        this.mappedBuffer = MarkFile.mapNewOrExistingMarkFile(markFile, shouldPreExist, versionFieldOffset, timestampFieldOffset, totalFileLength, timeoutMs, epochClock, versionCheck, logger);
        this.buffer = new UnsafeBuffer(this.mappedBuffer);
        this.versionFieldOffset = versionFieldOffset;
        this.timestampFieldOffset = timestampFieldOffset;
    }

    public MarkFile(File directory, String filename, int versionFieldOffset, int timestampFieldOffset, long timeoutMs, EpochClock epochClock, IntConsumer versionCheck, Consumer<String> logger) {
        MarkFile.validateOffsets(versionFieldOffset, timestampFieldOffset);
        this.parentDir = directory;
        this.markFile = new File(directory, filename);
        this.mappedBuffer = MarkFile.mapExistingMarkFile(this.markFile, versionFieldOffset, timestampFieldOffset, timeoutMs, epochClock, versionCheck, logger);
        this.buffer = new UnsafeBuffer(this.mappedBuffer);
        this.versionFieldOffset = versionFieldOffset;
        this.timestampFieldOffset = timestampFieldOffset;
    }

    public MarkFile(MappedByteBuffer mappedBuffer, int versionFieldOffset, int timestampFieldOffset) {
        MarkFile.validateOffsets(versionFieldOffset, timestampFieldOffset);
        this.parentDir = null;
        this.markFile = null;
        this.mappedBuffer = mappedBuffer;
        this.buffer = new UnsafeBuffer(mappedBuffer);
        this.versionFieldOffset = versionFieldOffset;
        this.timestampFieldOffset = timestampFieldOffset;
    }

    public MarkFile(UnsafeBuffer buffer, int versionFieldOffset, int timestampFieldOffset) {
        MarkFile.validateOffsets(versionFieldOffset, timestampFieldOffset);
        this.parentDir = null;
        this.markFile = null;
        this.mappedBuffer = null;
        this.buffer = buffer;
        this.versionFieldOffset = versionFieldOffset;
        this.timestampFieldOffset = timestampFieldOffset;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public void close() {
        if (!this.isClosed) {
            if (null != this.mappedBuffer) {
                BufferUtil.free(this.mappedBuffer);
            }
            this.isClosed = true;
        }
    }

    public void signalReady(int version) {
        this.buffer.putIntOrdered(this.versionFieldOffset, version);
    }

    public int versionVolatile() {
        return this.buffer.getIntVolatile(this.versionFieldOffset);
    }

    public int versionWeak() {
        return this.buffer.getInt(this.versionFieldOffset);
    }

    public void timestampOrdered(long timestamp) {
        this.buffer.putLongOrdered(this.timestampFieldOffset, timestamp);
    }

    public long timestampVolatile() {
        return this.buffer.getLongVolatile(this.timestampFieldOffset);
    }

    public long timestampWeak() {
        return this.buffer.getLong(this.timestampFieldOffset);
    }

    public void deleteDirectory(boolean ignoreFailures) {
        IoUtil.delete(this.parentDir, ignoreFailures);
    }

    public File parentDirectory() {
        return this.parentDir;
    }

    public File markFile() {
        return this.markFile;
    }

    public MappedByteBuffer mappedByteBuffer() {
        return this.mappedBuffer;
    }

    public UnsafeBuffer buffer() {
        return this.buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ensureDirectoryExists(File directory, String filename, boolean warnIfDirectoryExists, boolean dirDeleteOnStart, int versionFieldOffset, int timestampFieldOffset, long timeoutMs, EpochClock epochClock, IntConsumer versionCheck, Consumer<String> logger) {
        File markFile = new File(directory, filename);
        if (directory.isDirectory()) {
            if (warnIfDirectoryExists && null != logger) {
                logger.accept("WARNING: " + directory + " already exists.");
            }
            if (!dirDeleteOnStart) {
                int offset = Math.min(versionFieldOffset, timestampFieldOffset);
                int length = Math.max(versionFieldOffset, timestampFieldOffset) + 8 - offset;
                MappedByteBuffer byteBuffer = MarkFile.mapExistingFile(markFile, logger, offset, length);
                try {
                    if (MarkFile.isActive(byteBuffer, epochClock, timeoutMs, versionFieldOffset, timestampFieldOffset, versionCheck, logger)) {
                        throw new IllegalStateException("active Mark file detected");
                    }
                }
                finally {
                    BufferUtil.free(byteBuffer);
                }
            }
            IoUtil.delete(directory, false);
        }
        IoUtil.ensureDirectoryExists(directory, directory.toString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static MappedByteBuffer waitForFileMapping(Consumer<String> logger, File markFile, long deadlineMs, EpochClock epochClock) {
        try {
            long size;
            Throwable throwable;
            FileChannel fileChannel;
            while (true) {
                block20: {
                    fileChannel = FileChannel.open(markFile.toPath(), StandardOpenOption.READ, StandardOpenOption.WRITE);
                    throwable = null;
                    size = fileChannel.size();
                    if (size >= 12L) break;
                    if (epochClock.time() > deadlineMs) {
                        throw new IllegalStateException("Mark file is created but not populated");
                    }
                    fileChannel.close();
                    MarkFile.sleep(16L);
                    if (fileChannel == null) continue;
                    if (throwable == null) break block20;
                    try {
                        fileChannel.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    continue;
                }
                fileChannel.close();
            }
            try {
                if (null != logger) {
                    logger.accept("INFO: Mark file exists: " + markFile);
                }
                MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, size);
                return mappedByteBuffer;
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                throw throwable4;
            }
            finally {
                if (fileChannel != null) {
                    if (throwable != null) {
                        try {
                            fileChannel.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        fileChannel.close();
                    }
                }
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException("cannot open mark file", ex);
        }
    }

    public static MappedByteBuffer mapExistingMarkFile(File markFile, int versionFieldOffset, int timestampFieldOffset, long timeoutMs, EpochClock epochClock, IntConsumer versionCheck, Consumer<String> logger) {
        long deadlineMs = epochClock.time() + timeoutMs;
        while (!markFile.exists() || markFile.length() < (long)(timestampFieldOffset + 8)) {
            if (epochClock.time() > deadlineMs) {
                throw new IllegalStateException("Mark file not created: " + markFile.getName());
            }
            MarkFile.sleep(16L);
        }
        MappedByteBuffer byteBuffer = MarkFile.waitForFileMapping(logger, markFile, deadlineMs, epochClock);
        if (byteBuffer.capacity() < timestampFieldOffset + 8) {
            throw new IllegalStateException("Mark file mapping is to small: capacity=" + byteBuffer.capacity());
        }
        try {
            int version;
            UnsafeBuffer buffer = new UnsafeBuffer(byteBuffer);
            while (0 == (version = buffer.getIntVolatile(versionFieldOffset))) {
                if (epochClock.time() > deadlineMs) {
                    throw new IllegalStateException("Mark file is created but not initialised");
                }
                MarkFile.sleep(1L);
            }
            versionCheck.accept(version);
            while (0L == buffer.getLongVolatile(timestampFieldOffset)) {
                if (epochClock.time() > deadlineMs) {
                    throw new IllegalStateException("no non-zero timestamp detected");
                }
                MarkFile.sleep(1L);
            }
        }
        catch (Throwable ex) {
            BufferUtil.free(byteBuffer);
            LangUtil.rethrowUnchecked(ex);
        }
        return byteBuffer;
    }

    public static MappedByteBuffer mapNewOrExistingMarkFile(File markFile, boolean shouldPreExist, int versionFieldOffset, int timestampFieldOffset, long totalFileLength, long timeoutMs, EpochClock epochClock, IntConsumer versionCheck, Consumer<String> logger) {
        MappedByteBuffer byteBuffer = null;
        try (FileChannel channel = FileChannel.open(markFile.toPath(), StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.SPARSE);){
            byteBuffer = channel.map(FileChannel.MapMode.READ_WRITE, 0L, totalFileLength);
            UnsafeBuffer buffer = new UnsafeBuffer(byteBuffer);
            if (shouldPreExist) {
                int version = buffer.getIntVolatile(versionFieldOffset);
                if (null != logger) {
                    logger.accept("INFO: Mark file exists: " + markFile);
                }
                versionCheck.accept(version);
                long timestampMs = buffer.getLongVolatile(timestampFieldOffset);
                long timestampAgeMs = epochClock.time() - timestampMs;
                if (null != logger) {
                    logger.accept("INFO: heartbeat timestampMs=" + timestampMs + " ageMs=" + timestampAgeMs);
                }
                if (timestampAgeMs < timeoutMs) {
                    throw new IllegalStateException("active Mark file detected");
                }
            }
        }
        catch (Exception ex) {
            if (null != byteBuffer) {
                BufferUtil.free(byteBuffer);
            }
            throw new RuntimeException(ex);
        }
        return byteBuffer;
    }

    public static MappedByteBuffer mapExistingFile(File markFile, Consumer<String> logger, long offset, long length) {
        if (markFile.exists()) {
            if (null != logger) {
                logger.accept("INFO: Mark file exists: " + markFile);
            }
            return IoUtil.mapExistingFile(markFile, markFile.toString(), offset, length);
        }
        return null;
    }

    public static boolean isActive(MappedByteBuffer byteBuffer, EpochClock epochClock, long timeoutMs, int versionFieldOffset, int timestampFieldOffset, IntConsumer versionCheck, Consumer<String> logger) {
        int version;
        if (null == byteBuffer) {
            return false;
        }
        UnsafeBuffer buffer = new UnsafeBuffer(byteBuffer);
        long deadlineMs = epochClock.time() + timeoutMs;
        while (0 == (version = buffer.getIntVolatile(versionFieldOffset))) {
            if (epochClock.time() > deadlineMs) {
                throw new IllegalStateException("Mark file is created but not initialised");
            }
            MarkFile.sleep(1L);
        }
        versionCheck.accept(version);
        long timestampMs = buffer.getLongVolatile(timestampFieldOffset);
        long nowMs = epochClock.time();
        long timestampAgeMs = nowMs - timestampMs;
        if (null != logger) {
            logger.accept("INFO: heartbeat timestampMs=" + timestampMs + " ageMs=" + timestampAgeMs);
        }
        return timestampAgeMs <= timeoutMs;
    }

    protected static void sleep(long durationMs) {
        try {
            Thread.sleep(durationMs);
        }
        catch (InterruptedException ignore) {
            Thread.currentThread().interrupt();
        }
    }

    private static void validateOffsets(int versionFieldOffset, int timestampFieldOffset) {
        if (versionFieldOffset + 4 > timestampFieldOffset) {
            throw new IllegalArgumentException("version field must precede the timestamp field");
        }
    }
}

