/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.mapreduce.CopyTableTestBase;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MapReduceTests;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MapReduceTests.class, LargeTests.class})
public class TestCopyTableToPeerCluster
extends CopyTableTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCopyTableToPeerCluster.class);
    private static final HBaseTestingUtility UTIL1 = new HBaseTestingUtility();
    private static final HBaseTestingUtility UTIL2 = new HBaseTestingUtility();

    @BeforeClass
    public static void beforeClass() throws Exception {
        UTIL1.startMiniCluster(3);
        UTIL2.startMiniCluster(3);
    }

    @AfterClass
    public static void afterClass() throws Exception {
        UTIL1.shutdownMiniCluster();
        UTIL2.shutdownMiniCluster();
    }

    @Override
    protected Table createSourceTable(TableDescriptor desc) throws Exception {
        return UTIL1.createTable(desc, (byte[][])null);
    }

    @Override
    protected Table createTargetTable(TableDescriptor desc) throws Exception {
        return UTIL2.createTable(desc, (byte[][])null);
    }

    @Override
    protected void dropSourceTable(TableName tableName) throws Exception {
        UTIL1.deleteTable(tableName);
    }

    @Override
    protected void dropTargetTable(TableName tableName) throws Exception {
        UTIL2.deleteTable(tableName);
    }

    @Override
    protected String[] getPeerClusterOptions() throws Exception {
        return new String[]{"--peer.adr=" + UTIL2.getClusterKey()};
    }

    @Test
    public void testCopyTable() throws Exception {
        this.doCopyTableTest(UTIL1.getConfiguration(), false);
    }

    @Test
    public void testCopyTableWithMob() throws Exception {
        this.doCopyTableTestWithMob(UTIL1.getConfiguration(), false);
    }

    @Test
    public void testStartStopRow() throws Exception {
        this.testStartStopRow(UTIL1.getConfiguration());
    }

    @Test
    public void testRenameFamily() throws Exception {
        this.testRenameFamily(UTIL1.getConfiguration());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBulkLoadNotSupported() throws Exception {
        TableName tableName1 = TableName.valueOf((String)(this.name.getMethodName() + "1"));
        TableName tableName2 = TableName.valueOf((String)(this.name.getMethodName() + "2"));
        try (Table t1 = UTIL1.createTable(tableName1, FAMILY_A);
             Table t2 = UTIL2.createTable(tableName2, FAMILY_A);){
            Assert.assertFalse((boolean)this.runCopy(UTIL1.getConfiguration(), new String[]{"--new.name=" + tableName2.getNameAsString(), "--bulkload", "--peer.adr=" + UTIL2.getClusterKey(), tableName1.getNameAsString()}));
        }
        finally {
            UTIL1.deleteTable(tableName1);
            UTIL2.deleteTable(tableName2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSnapshotNotSupported() throws Exception {
        TableName tableName1 = TableName.valueOf((String)(this.name.getMethodName() + "1"));
        TableName tableName2 = TableName.valueOf((String)(this.name.getMethodName() + "2"));
        String snapshot = tableName1.getNameAsString() + "_snapshot";
        try (Table t1 = UTIL1.createTable(tableName1, FAMILY_A);
             Table t2 = UTIL2.createTable(tableName2, FAMILY_A);){
            UTIL1.getAdmin().snapshot(snapshot, tableName1);
            Assert.assertFalse((boolean)this.runCopy(UTIL1.getConfiguration(), new String[]{"--new.name=" + tableName2.getNameAsString(), "--snapshot", "--peer.adr=" + UTIL2.getClusterKey(), snapshot}));
        }
        finally {
            UTIL1.getAdmin().deleteSnapshot(snapshot);
            UTIL1.deleteTable(tableName1);
            UTIL2.deleteTable(tableName2);
        }
    }
}

