/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.tool;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.tmpl.tool.CanaryStatusTmpl;
import org.apache.hadoop.hbase.tool.CanaryTool;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestCanaryStatusServlet {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCanaryStatusServlet.class);

    @Test
    public void testFailures() throws IOException {
        CanaryTool.RegionStdOutSink regionStdOutSink = new CanaryTool.RegionStdOutSink();
        ServerName serverName1 = ServerName.valueOf((String)"staging-st04.server:22600", (long)1584180761635L);
        TableName fakeTableName1 = TableName.valueOf((String)"fakeTableName1");
        RegionInfo regionInfo1 = RegionInfoBuilder.newBuilder((TableName)fakeTableName1).build();
        ServerName serverName2 = ServerName.valueOf((String)"staging-st05.server:22600", (long)1584180761636L);
        TableName fakeTableName2 = TableName.valueOf((String)"fakeTableName2");
        RegionInfo regionInfo2 = RegionInfoBuilder.newBuilder((TableName)fakeTableName2).build();
        regionStdOutSink.publishReadFailure(serverName1, regionInfo1, (Exception)new IOException());
        regionStdOutSink.publishWriteFailure(serverName2, regionInfo2, (Exception)new IOException());
        CanaryStatusTmpl tmpl = new CanaryStatusTmpl();
        StringWriter renderResultWriter = new StringWriter();
        tmpl.render((Writer)renderResultWriter, regionStdOutSink);
        String renderResult = renderResultWriter.toString();
        Assert.assertTrue((boolean)renderResult.contains("staging-st04.server,22600"));
        Assert.assertTrue((boolean)renderResult.contains("fakeTableName1"));
        Assert.assertTrue((boolean)renderResult.contains("staging-st05.server,22600"));
        Assert.assertTrue((boolean)renderResult.contains("fakeTableName2"));
    }

    @Test
    public void testReadFailuresOnly() throws IOException {
        CanaryTool.RegionStdOutSink regionStdOutSink = new CanaryTool.RegionStdOutSink();
        ServerName serverName1 = ServerName.valueOf((String)"staging-st04.server:22600", (long)1584180761635L);
        TableName fakeTableName1 = TableName.valueOf((String)"fakeTableName1");
        RegionInfo regionInfo1 = RegionInfoBuilder.newBuilder((TableName)fakeTableName1).build();
        regionStdOutSink.publishReadFailure(serverName1, regionInfo1, (Exception)new IOException());
        CanaryStatusTmpl tmpl = new CanaryStatusTmpl();
        StringWriter renderResultWriter = new StringWriter();
        tmpl.render((Writer)renderResultWriter, regionStdOutSink);
        String renderResult = renderResultWriter.toString();
        Assert.assertTrue((boolean)renderResult.contains("staging-st04.server,22600"));
        Assert.assertTrue((boolean)renderResult.contains("fakeTableName1"));
    }

    @Test
    public void testWriteFailuresOnly() throws IOException {
        CanaryTool.RegionStdOutSink regionStdOutSink = new CanaryTool.RegionStdOutSink();
        ServerName serverName2 = ServerName.valueOf((String)"staging-st05.server:22600", (long)1584180761636L);
        TableName fakeTableName2 = TableName.valueOf((String)"fakeTableName2");
        RegionInfo regionInfo2 = RegionInfoBuilder.newBuilder((TableName)fakeTableName2).build();
        regionStdOutSink.publishReadFailure(serverName2, regionInfo2, (Exception)new IOException());
        CanaryStatusTmpl tmpl = new CanaryStatusTmpl();
        StringWriter renderResultWriter = new StringWriter();
        tmpl.render((Writer)renderResultWriter, regionStdOutSink);
        String renderResult = renderResultWriter.toString();
        Assert.assertTrue((boolean)renderResult.contains("staging-st05.server,22600"));
        Assert.assertTrue((boolean)renderResult.contains("fakeTableName2"));
    }

    @Test
    public void testNoFailures() throws IOException {
        CanaryTool.RegionStdOutSink regionStdOutSink = new CanaryTool.RegionStdOutSink();
        CanaryStatusTmpl tmpl = new CanaryStatusTmpl();
        StringWriter renderResultWriter = new StringWriter();
        tmpl.render((Writer)renderResultWriter, regionStdOutSink);
        String renderResult = renderResultWriter.toString();
        Assert.assertTrue((boolean)renderResult.contains("Total Failed Servers: 0"));
        Assert.assertTrue((boolean)renderResult.contains("Total Failed Tables: 0"));
    }
}

