/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.io.Closeable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.TestReplicationBase;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSyncUp;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hbase.thirdparty.com.google.common.io.Closeables;
import org.junit.After;
import org.junit.Before;

public abstract class TestReplicationSyncUpToolBase {
    protected static final HBaseTestingUtility UTIL1 = new HBaseTestingUtility();
    protected static final HBaseTestingUtility UTIL2 = new HBaseTestingUtility();
    protected static final TableName TN1 = TableName.valueOf((String)"t1_syncup");
    protected static final TableName TN2 = TableName.valueOf((String)"t2_syncup");
    protected static final byte[] FAMILY = Bytes.toBytes((String)"cf1");
    protected static final byte[] QUALIFIER = Bytes.toBytes((String)"q1");
    protected static final byte[] NO_REP_FAMILY = Bytes.toBytes((String)"norep");
    protected TableDescriptor t1SyncupSource;
    protected TableDescriptor t1SyncupTarget;
    protected TableDescriptor t2SyncupSource;
    protected TableDescriptor t2SyncupTarget;
    protected Connection conn1;
    protected Connection conn2;
    protected Table ht1Source;
    protected Table ht2Source;
    protected Table ht1TargetAtPeer1;
    protected Table ht2TargetAtPeer1;

    protected void customizeClusterConf(Configuration conf) {
    }

    @Before
    public void setUp() throws Exception {
        this.customizeClusterConf(UTIL1.getConfiguration());
        this.customizeClusterConf(UTIL2.getConfiguration());
        TestReplicationBase.configureClusters(UTIL1, UTIL2);
        UTIL1.startMiniZKCluster();
        UTIL2.setZkCluster(UTIL1.getZkCluster());
        UTIL1.startMiniCluster(2);
        UTIL2.startMiniCluster(4);
        this.t1SyncupSource = TableDescriptorBuilder.newBuilder((TableName)TN1).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])FAMILY).setScope(1).build()).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])NO_REP_FAMILY)).build();
        this.t1SyncupTarget = TableDescriptorBuilder.newBuilder((TableName)TN1).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY)).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])NO_REP_FAMILY)).build();
        this.t2SyncupSource = TableDescriptorBuilder.newBuilder((TableName)TN2).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])FAMILY).setScope(1).build()).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])NO_REP_FAMILY)).build();
        this.t2SyncupTarget = TableDescriptorBuilder.newBuilder((TableName)TN2).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY)).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])NO_REP_FAMILY)).build();
    }

    @After
    public void tearDown() throws Exception {
        Closeables.close((Closeable)this.ht1Source, (boolean)true);
        Closeables.close((Closeable)this.ht2Source, (boolean)true);
        Closeables.close((Closeable)this.ht1TargetAtPeer1, (boolean)true);
        Closeables.close((Closeable)this.ht2TargetAtPeer1, (boolean)true);
        Closeables.close((Closeable)this.conn1, (boolean)true);
        Closeables.close((Closeable)this.conn2, (boolean)true);
        UTIL2.shutdownMiniCluster();
        UTIL1.shutdownMiniCluster();
    }

    final void setupReplication() throws Exception {
        Admin admin1 = UTIL1.getAdmin();
        admin1.createTable(this.t1SyncupSource);
        admin1.createTable(this.t2SyncupSource);
        Admin admin2 = UTIL2.getAdmin();
        admin2.createTable(this.t1SyncupTarget);
        admin2.createTable(this.t2SyncupTarget);
        Connection conn1 = ConnectionFactory.createConnection((Configuration)UTIL1.getConfiguration());
        this.ht1Source = conn1.getTable(TN1);
        this.ht2Source = conn1.getTable(TN2);
        Connection conn2 = ConnectionFactory.createConnection((Configuration)UTIL2.getConfiguration());
        this.ht1TargetAtPeer1 = conn2.getTable(TN1);
        this.ht2TargetAtPeer1 = conn2.getTable(TN2);
        ReplicationPeerConfig rpc = ReplicationPeerConfig.newBuilder().setClusterKey(UTIL2.getClusterKey()).build();
        admin1.addReplicationPeer("1", rpc);
    }

    final void syncUp(HBaseTestingUtility util) throws Exception {
        ToolRunner.run((Configuration)util.getConfiguration(), (Tool)new ReplicationSyncUp(), (String[])new String[0]);
    }

    final void shutDownSourceHBaseCluster() throws Exception {
        Closeables.close((Closeable)this.ht1Source, (boolean)true);
        Closeables.close((Closeable)this.ht2Source, (boolean)true);
        UTIL1.shutdownMiniHBaseCluster();
    }

    final void shutDownTargetHBaseCluster() throws Exception {
        Closeables.close((Closeable)this.ht1TargetAtPeer1, (boolean)true);
        Closeables.close((Closeable)this.ht2TargetAtPeer1, (boolean)true);
        UTIL2.shutdownMiniHBaseCluster();
    }

    final void restartSourceHBaseCluster(int numServers) throws Exception {
        Closeables.close((Closeable)this.ht1Source, (boolean)true);
        Closeables.close((Closeable)this.ht2Source, (boolean)true);
        UTIL1.restartHBaseCluster(numServers);
        this.ht1Source = UTIL1.getConnection().getTable(TN1);
        this.ht2Source = UTIL1.getConnection().getTable(TN2);
    }

    final void restartTargetHBaseCluster(int numServers) throws Exception {
        Closeables.close((Closeable)this.ht1TargetAtPeer1, (boolean)true);
        Closeables.close((Closeable)this.ht2TargetAtPeer1, (boolean)true);
        UTIL2.restartHBaseCluster(numServers);
        this.ht1TargetAtPeer1 = UTIL2.getConnection().getTable(TN1);
        this.ht2TargetAtPeer1 = UTIL2.getConnection().getTable(TN2);
    }
}

