/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.StartMiniClusterOption;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNameTestRule;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.executor.ExecutorType;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.ServerRegionReplicaUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestRegionReplicaWaitForPrimaryFlushConf {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionReplicaWaitForPrimaryFlushConf.class);
    private static final byte[] FAMILY = Bytes.toBytes((String)"family_test");
    private TableName tableName;
    @Rule
    public final TableNameTestRule name = new TableNameTestRule();
    private static final HBaseTestingUtility HTU = new HBaseTestingUtility();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Configuration conf = HTU.getConfiguration();
        conf.setBoolean("hbase.region.replica.replication.enabled", true);
        conf.setBoolean("hbase.region.replica.wait.for.primary.flush", false);
        HTU.startMiniCluster(StartMiniClusterOption.builder().numRegionServers(2).build());
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        HTU.shutdownMiniCluster();
    }

    @Test
    public void testSecondaryReplicaReadEnabled() throws Exception {
        this.tableName = this.name.getTableName();
        TableDescriptor tableDescriptor = TableDescriptorBuilder.newBuilder((TableName)this.tableName).setRegionReplication(2).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY)).setRegionMemStoreReplication(true).build();
        HTU.getAdmin().createTable(tableDescriptor);
        ArrayList<Pair> regionAndRegionServers = new ArrayList<Pair>(Arrays.asList(null, null));
        for (int i = 0; i < 2; ++i) {
            HRegionServer rs = HTU.getMiniHBaseCluster().getRegionServer(i);
            List onlineRegions = rs.getRegions(this.tableName);
            for (HRegion region : onlineRegions) {
                int replicaId = region.getRegionInfo().getReplicaId();
                Assert.assertNull((Object)regionAndRegionServers.get(replicaId));
                regionAndRegionServers.set(replicaId, new Pair((Object)region, (Object)rs));
            }
        }
        for (Pair pair : regionAndRegionServers) {
            Assert.assertNotNull((Object)pair);
        }
        HRegionServer secondaryRs = (HRegionServer)regionAndRegionServers.get(1).getSecond();
        try {
            secondaryRs.getExecutorService().getExecutorThreadPool(ExecutorType.RS_REGION_REPLICA_FLUSH_OPS);
            Assert.fail();
        }
        catch (NullPointerException e) {
            Assert.assertTrue((e != null ? 1 : 0) != 0);
        }
        HRegion secondaryRegion = (HRegion)regionAndRegionServers.get(1).getFirst();
        Assert.assertFalse((boolean)ServerRegionReplicaUtil.isRegionReplicaWaitForPrimaryFlushEnabled((Configuration)secondaryRegion.conf));
        Assert.assertTrue((boolean)secondaryRegion.isReadsEnabled());
    }
}

