/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.region;

import java.io.IOException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.master.region.MasterRegionTestBase;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.storefiletracker.StoreFileTrackerFactory;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, MediumTests.class})
public class TestMasterRegionInitialize
extends MasterRegionTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMasterRegionInitialize.class);

    @Test
    public void testUpgrade() throws IOException {
        Path rootDir = new Path(this.htu.getDataTestDir(), REGION_DIR_NAME);
        Path tableDir = CommonFSUtils.getTableDir((Path)rootDir, (TableName)this.region.region.getTableDescriptor().getTableName());
        Path initializingFlag = new Path(tableDir, ".initializing");
        Path initializedFlag = new Path(tableDir, ".initialized");
        HRegionFileSystem hfs = this.region.region.getRegionFileSystem();
        Assert.assertFalse((boolean)hfs.getFileSystem().exists(initializingFlag));
        Assert.assertTrue((boolean)hfs.getFileSystem().exists(initializedFlag));
        byte[] row = Bytes.toBytes((String)"row");
        byte[] cf = CF1;
        byte[] cq = Bytes.toBytes((String)"qual");
        byte[] value = Bytes.toBytes((String)"value");
        this.region.update(r -> r.put(new Put(row).addColumn(cf, cq, value)));
        Assert.assertEquals((Object)HRegion.FlushResult.Result.FLUSHED_NO_COMPACTION_NEEDED, (Object)this.region.flush(true).getResult());
        hfs.getFileSystem().delete(initializedFlag, true);
        FSTableDescriptors.deleteTableDescriptors((FileSystem)hfs.getFileSystem(), (Path)tableDir);
        Assert.assertNull((Object)FSTableDescriptors.getTableDescriptorFromFs((FileSystem)hfs.getFileSystem(), (Path)tableDir));
        this.region.close(false);
        this.htu.getConfiguration().set("hbase.store.file-tracker.impl", StoreFileTrackerFactory.Trackers.FILE.name());
        this.createMasterRegion();
        hfs = this.region.region.getRegionFileSystem();
        Assert.assertFalse((boolean)hfs.getFileSystem().exists(initializingFlag));
        Assert.assertTrue((boolean)hfs.getFileSystem().exists(initializedFlag));
        TableDescriptor td = FSTableDescriptors.getTableDescriptorFromFs((FileSystem)hfs.getFileSystem(), (Path)tableDir);
        Assert.assertEquals((Object)StoreFileTrackerFactory.Trackers.FILE.name(), (Object)td.getValue("hbase.store.file-tracker.impl"));
        Assert.assertArrayEquals((byte[])value, (byte[])this.region.get(new Get(row)).getValue(cf, cq));
    }

    @Test
    public void testInitializingCleanup() throws IOException {
        Path rootDir = new Path(this.htu.getDataTestDir(), REGION_DIR_NAME);
        Path tableDir = CommonFSUtils.getTableDir((Path)rootDir, (TableName)this.region.region.getTableDescriptor().getTableName());
        Path initializingFlag = new Path(tableDir, ".initializing");
        Path initializedFlag = new Path(tableDir, ".initialized");
        HRegionFileSystem hfs = this.region.region.getRegionFileSystem();
        Assert.assertFalse((boolean)hfs.getFileSystem().exists(initializingFlag));
        Assert.assertTrue((boolean)hfs.getFileSystem().exists(initializedFlag));
        byte[] row = Bytes.toBytes((String)"row");
        byte[] cf = CF1;
        byte[] cq = Bytes.toBytes((String)"qual");
        byte[] value = Bytes.toBytes((String)"value");
        this.region.update(r -> r.put(new Put(row).addColumn(cf, cq, value)));
        hfs.getFileSystem().delete(initializedFlag, true);
        if (!hfs.getFileSystem().mkdirs(initializingFlag)) {
            throw new IOException("can not touch " + initializedFlag);
        }
        this.region.close(false);
        this.createMasterRegion();
        hfs = this.region.region.getRegionFileSystem();
        Assert.assertFalse((boolean)hfs.getFileSystem().exists(initializingFlag));
        Assert.assertTrue((boolean)hfs.getFileSystem().exists(initializedFlag));
        Assert.assertTrue((boolean)this.region.get(new Get(row)).isEmpty());
    }
}

