/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.FromClientSideBase;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.metrics.ScanMetrics;
import org.apache.hadoop.hbase.client.metrics.ScanMetricsRegionInfo;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FutureUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runners.Parameterized;

@Category(value={ClientTests.class, LargeTests.class})
public class TestTableScanMetrics
extends FromClientSideBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestTableScanMetrics.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final TableName TABLE_NAME = TableName.valueOf((String)TestTableScanMetrics.class.getSimpleName());
    private static final byte[] CF = Bytes.toBytes((String)"cf");
    private static final byte[] CQ = Bytes.toBytes((String)"cq");
    private static final byte[] VALUE = Bytes.toBytes((String)"value");
    private static final Random RAND = new Random(11L);
    private static int NUM_REGIONS;
    private static Connection CONN;
    @Parameterized.Parameter(value=0)
    public String scannerName;
    @Parameterized.Parameter(value=1)
    public Scan originalScan;

    @Parameterized.Parameters(name="{index}: scanner={0}")
    public static List<Object[]> params() {
        return Arrays.asList({"ForwardScanner", new Scan()}, {"ReverseScanner", new Scan().setReversed(true)});
    }

    @BeforeClass
    public static void setUp() throws Exception {
        TEST_UTIL.startMiniCluster(2);
        try (Table table = TEST_UTIL.createMultiRegionTable(TABLE_NAME, CF);){
            table.put(Arrays.asList(new Put(Bytes.toBytes((String)"xxx1")).addColumn(CF, CQ, VALUE), new Put(Bytes.toBytes((String)"yyy1")).addColumn(CF, CQ, VALUE), new Put(Bytes.toBytes((String)"zzz1")).addColumn(CF, CQ, VALUE)));
        }
        CONN = ConnectionFactory.createConnection((Configuration)TEST_UTIL.getConfiguration());
        NUM_REGIONS = TEST_UTIL.getHBaseCluster().getRegions(TABLE_NAME).size();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    private Scan generateScan(byte[] smallerRow, byte[] largerRow) throws IOException {
        Scan scan = new Scan(this.originalScan);
        if (this.originalScan.isReversed()) {
            scan.withStartRow(largerRow, true);
            scan.withStopRow(smallerRow, true);
        } else {
            scan.withStartRow(smallerRow, true);
            scan.withStopRow(largerRow, true);
        }
        return scan;
    }

    private ScanMetrics assertScannedRowsAndGetScanMetrics(Scan scan, int expectedCount) throws IOException {
        ScanMetrics scanMetrics;
        int countOfRows = 0;
        try (Table table = CONN.getTable(TABLE_NAME);
             ResultScanner scanner = table.getScanner(scan);){
            for (Result result : scanner) {
                Assert.assertFalse((boolean)result.isEmpty());
                ++countOfRows;
            }
            scanMetrics = scanner.getScanMetrics();
        }
        Assert.assertEquals((long)expectedCount, (long)countOfRows);
        return scanMetrics;
    }

    @Test
    public void testScanMetricsDisabled() throws Exception {
        Scan scan = this.generateScan(Bytes.toBytes((String)"xxx1"), Bytes.toBytes((String)"zzz1"));
        ScanMetrics scanMetrics = this.assertScannedRowsAndGetScanMetrics(scan, 3);
        Assert.assertNull((Object)scanMetrics);
    }

    @Test
    public void testScanMetricsWithScanMetricByRegionDisabled() throws Exception {
        Scan scan = this.generateScan(Bytes.toBytes((String)"xxx1"), Bytes.toBytes((String)"zzz1"));
        scan.setScanMetricsEnabled(true);
        int expectedRowsScanned = 3;
        ScanMetrics scanMetrics = this.assertScannedRowsAndGetScanMetrics(scan, expectedRowsScanned);
        Assert.assertNotNull((Object)scanMetrics);
        Map metricsMap = scanMetrics.getMetricsMap(false);
        Assert.assertEquals((long)expectedRowsScanned, (long)scanMetrics.countOfRegions.get());
        Assert.assertEquals((long)expectedRowsScanned, (long)((Long)metricsMap.get("ROWS_SCANNED")));
        Assert.assertTrue((boolean)scanMetrics.collectMetricsByRegion().isEmpty());
    }

    @Test
    public void testScanMetricsResetWithScanMetricsByRegionDisabled() throws Exception {
        Scan scan = this.generateScan(Bytes.toBytes((String)"xxx1"), Bytes.toBytes((String)"zzz1"));
        scan.setScanMetricsEnabled(true);
        int expectedRowsScanned = 3;
        ScanMetrics scanMetrics = this.assertScannedRowsAndGetScanMetrics(scan, expectedRowsScanned);
        Assert.assertNotNull((Object)scanMetrics);
        Map metricsMap = scanMetrics.getMetricsMap();
        Assert.assertEquals((long)expectedRowsScanned, (long)((Long)metricsMap.get("REGIONS_SCANNED")));
        Assert.assertEquals((long)expectedRowsScanned, (long)((Long)metricsMap.get("ROWS_SCANNED")));
        Assert.assertEquals((long)0L, (long)scanMetrics.countOfRegions.get());
        Assert.assertEquals((long)0L, (long)scanMetrics.countOfRowsScanned.get());
    }

    @Test
    public void testScanMetricsByRegionForSingleRegionScan() throws Exception {
        Scan scan = this.generateScan(Bytes.toBytes((String)"xxx1"), Bytes.toBytes((String)"xxx1"));
        scan.setEnableScanMetricsByRegion(true);
        int expectedRowsScanned = 1;
        ScanMetrics scanMetrics = this.assertScannedRowsAndGetScanMetrics(scan, expectedRowsScanned);
        Assert.assertNotNull((Object)scanMetrics);
        Map metricsMap = scanMetrics.getMetricsMap(false);
        Assert.assertEquals((long)expectedRowsScanned, (long)((Long)metricsMap.get("REGIONS_SCANNED")));
        Assert.assertEquals((long)expectedRowsScanned, (long)((Long)metricsMap.get("ROWS_SCANNED")));
        Map scanMetricsByRegion = scanMetrics.collectMetricsByRegion(false);
        Assert.assertEquals((long)expectedRowsScanned, (long)scanMetricsByRegion.size());
        for (Map.Entry entry : scanMetricsByRegion.entrySet()) {
            ScanMetricsRegionInfo scanMetricsRegionInfo = (ScanMetricsRegionInfo)entry.getKey();
            metricsMap = (Map)entry.getValue();
            Assert.assertNotNull((Object)scanMetricsRegionInfo.getEncodedRegionName());
            Assert.assertNotNull((Object)scanMetricsRegionInfo.getServerName());
            Assert.assertEquals((long)expectedRowsScanned, (long)((Long)metricsMap.get("REGIONS_SCANNED")));
            Assert.assertEquals((long)expectedRowsScanned, (long)((Long)metricsMap.get("ROWS_SCANNED")));
        }
    }

    @Test
    public void testScanMetricsByRegionForMultiRegionScan() throws Exception {
        Scan scan = this.generateScan(HConstants.EMPTY_BYTE_ARRAY, HConstants.EMPTY_BYTE_ARRAY);
        scan.setEnableScanMetricsByRegion(true);
        int expectedRowsScanned = 3;
        ScanMetrics scanMetrics = this.assertScannedRowsAndGetScanMetrics(scan, expectedRowsScanned);
        Assert.assertNotNull((Object)scanMetrics);
        Assert.assertEquals((long)NUM_REGIONS, (long)scanMetrics.countOfRegions.get());
        Assert.assertEquals((long)expectedRowsScanned, (long)scanMetrics.countOfRowsScanned.get());
        Map scanMetricsByRegion = scanMetrics.collectMetricsByRegion(false);
        Assert.assertEquals((long)NUM_REGIONS, (long)scanMetricsByRegion.size());
        int rowsScannedAcrossAllRegions = 0;
        for (Map.Entry entry : scanMetricsByRegion.entrySet()) {
            ScanMetricsRegionInfo scanMetricsRegionInfo = (ScanMetricsRegionInfo)entry.getKey();
            Map metricsMap = (Map)entry.getValue();
            Assert.assertNotNull((Object)scanMetricsRegionInfo.getEncodedRegionName());
            Assert.assertNotNull((Object)scanMetricsRegionInfo.getServerName());
            Assert.assertEquals((long)1L, (long)((Long)metricsMap.get("REGIONS_SCANNED")));
            if ((Long)metricsMap.get("ROWS_SCANNED") == 1L) {
                ++rowsScannedAcrossAllRegions;
                continue;
            }
            Assert.assertEquals((long)0L, (long)((Long)metricsMap.get("ROWS_SCANNED")));
        }
        Assert.assertEquals((long)expectedRowsScanned, (long)rowsScannedAcrossAllRegions);
    }

    @Test
    public void testScanMetricsByRegionReset() throws Exception {
        Map metricsMap;
        ScanMetricsRegionInfo scanMetricsRegionInfo;
        Scan scan = this.generateScan(Bytes.toBytes((String)"xxx1"), Bytes.toBytes((String)"zzz1"));
        scan.setEnableScanMetricsByRegion(true);
        int expectedRowsScanned = 3;
        ScanMetrics scanMetrics = this.assertScannedRowsAndGetScanMetrics(scan, expectedRowsScanned);
        Assert.assertNotNull((Object)scanMetrics);
        Map scanMetricsByRegion = scanMetrics.collectMetricsByRegion();
        Assert.assertEquals((long)expectedRowsScanned, (long)scanMetricsByRegion.size());
        for (Map.Entry entry : scanMetricsByRegion.entrySet()) {
            scanMetricsRegionInfo = (ScanMetricsRegionInfo)entry.getKey();
            metricsMap = (Map)entry.getValue();
            Assert.assertNotNull((Object)scanMetricsRegionInfo.getEncodedRegionName());
            Assert.assertNotNull((Object)scanMetricsRegionInfo.getServerName());
            Assert.assertEquals((long)1L, (long)((Long)metricsMap.get("REGIONS_SCANNED")));
            Assert.assertEquals((long)1L, (long)((Long)metricsMap.get("ROWS_SCANNED")));
        }
        scanMetricsByRegion = scanMetrics.collectMetricsByRegion(false);
        Assert.assertEquals((long)expectedRowsScanned, (long)scanMetricsByRegion.size());
        for (Map.Entry entry : scanMetricsByRegion.entrySet()) {
            scanMetricsRegionInfo = (ScanMetricsRegionInfo)entry.getKey();
            metricsMap = (Map)entry.getValue();
            Assert.assertNotNull((Object)scanMetricsRegionInfo.getEncodedRegionName());
            Assert.assertNotNull((Object)scanMetricsRegionInfo.getServerName());
            Assert.assertEquals((long)0L, (long)((Long)metricsMap.get("REGIONS_SCANNED")));
            Assert.assertEquals((long)0L, (long)((Long)metricsMap.get("ROWS_SCANNED")));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConcurrentUpdatesAndResetOfScanMetricsByRegion() throws Exception {
        ThreadPoolExecutor executor = (ThreadPoolExecutor)Executors.newFixedThreadPool(2);
        TableName tableName = TableName.valueOf((String)(TestTableScanMetrics.class.getSimpleName() + "_testConcurrentUpdatesAndResetToScanMetricsByRegion"));
        try (Table table = TEST_UTIL.createMultiRegionTable(tableName, CF);){
            Map expectedScanMetricsByRegion;
            TEST_UTIL.loadTable(table, CF);
            HashMap<ScanMetricsRegionInfo, Map<String, Long>> concurrentScanMetricsByRegion = new HashMap<ScanMetricsRegionInfo, Map<String, Long>>();
            Scan scan = this.generateScan(HConstants.EMPTY_BYTE_ARRAY, HConstants.EMPTY_BYTE_ARRAY);
            scan.setEnableScanMetricsByRegion(true);
            scan.setCaching(2);
            try (final ResultScanner rs = table.getScanner(scan);){
                ScanMetrics scanMetrics = rs.getScanMetrics();
                final AtomicInteger rowsScanned = new AtomicInteger(0);
                final CountDownLatch latch = new CountDownLatch(1);
                Runnable tableScanner = new Runnable(){

                    @Override
                    public void run() {
                        for (Result r : rs) {
                            Assert.assertFalse((boolean)r.isEmpty());
                            rowsScanned.incrementAndGet();
                        }
                        latch.countDown();
                    }
                };
                Runnable metricsCollector = this.getPeriodicScanMetricsCollector(scanMetrics, concurrentScanMetricsByRegion, latch);
                executor.execute(tableScanner);
                executor.execute(metricsCollector);
                latch.await();
                this.mergeScanMetricsByRegion(scanMetrics.collectMetricsByRegion(), concurrentScanMetricsByRegion);
                Assert.assertEquals((long)HBaseTestingUtility.ROWS.length, (long)rowsScanned.get());
            }
            scan = this.generateScan(HConstants.EMPTY_BYTE_ARRAY, HConstants.EMPTY_BYTE_ARRAY);
            scan.setEnableScanMetricsByRegion(true);
            scan.setCaching(2);
            try (ResultScanner rs = table.getScanner(scan);){
                ScanMetrics scanMetrics = rs.getScanMetrics();
                int rowsScanned = 0;
                for (Result r : rs) {
                    Assert.assertFalse((boolean)r.isEmpty());
                    ++rowsScanned;
                }
                Assert.assertEquals((long)HBaseTestingUtility.ROWS.length, (long)rowsScanned);
                expectedScanMetricsByRegion = scanMetrics.collectMetricsByRegion();
                for (Map.Entry entry : expectedScanMetricsByRegion.entrySet()) {
                    ScanMetricsRegionInfo scanMetricsRegionInfo = (ScanMetricsRegionInfo)entry.getKey();
                    Map metricsMap = (Map)entry.getValue();
                    metricsMap.remove("MILLIS_BETWEEN_NEXTS");
                    metricsMap.remove("RPC_SCAN_PROCESSING_TIME");
                    metricsMap.remove("RPC_SCAN_QUEUE_WAIT_TIME");
                    Assert.assertNotNull((Object)scanMetricsRegionInfo.getEncodedRegionName());
                    Assert.assertNotNull((Object)scanMetricsRegionInfo.getServerName());
                    Assert.assertEquals((long)1L, (long)((Long)metricsMap.get("REGIONS_SCANNED")));
                    long rowsScannedFromMetrics = (Long)metricsMap.get("ROWS_SCANNED");
                    Assert.assertTrue((rowsScannedFromMetrics == 1L || rowsScannedFromMetrics == 703L ? 1 : 0) != 0);
                }
            }
            Assert.assertEquals((Object)expectedScanMetricsByRegion, concurrentScanMetricsByRegion);
        }
        finally {
            TEST_UTIL.deleteTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRPCCallProcessingAndQueueWaitTimeMetrics() throws Exception {
        int numThreads = 20;
        Configuration conf = TEST_UTIL.getConfiguration();
        int handlerCount = conf.getInt("hbase.regionserver.handler.count", 30);
        Assert.assertTrue((20 > 6 * handlerCount ? 1 : 0) != 0);
        ThreadPoolExecutor executor = (ThreadPoolExecutor)Executors.newFixedThreadPool(20);
        TableName tableName = TableName.valueOf((String)(TestTableScanMetrics.class.getSimpleName() + "_testRPCCallProcessingAndQueueWaitTimeMetrics"));
        final AtomicLong totalScanRpcTime = new AtomicLong(0L);
        final AtomicLong totalQueueWaitTime = new AtomicLong(0L);
        final CountDownLatch latch = new CountDownLatch(20);
        try (final Table table = TEST_UTIL.createMultiRegionTable(tableName, CF);){
            TEST_UTIL.loadTable(table, CF);
            for (int i = 0; i < 20; ++i) {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Scan scan = TestTableScanMetrics.this.generateScan(HConstants.EMPTY_BYTE_ARRAY, HConstants.EMPTY_BYTE_ARRAY);
                            scan.setEnableScanMetricsByRegion(true);
                            scan.setCaching(2);
                            try (ResultScanner rs = table.getScanner(scan);){
                                Result r;
                                while ((r = rs.next()) != null) {
                                    Assert.assertFalse((boolean)r.isEmpty());
                                }
                                ScanMetrics scanMetrics = rs.getScanMetrics();
                                Map metricsMap = scanMetrics.getMetricsMap();
                                totalScanRpcTime.addAndGet((Long)metricsMap.get("RPC_SCAN_PROCESSING_TIME"));
                                totalQueueWaitTime.addAndGet((Long)metricsMap.get("RPC_SCAN_QUEUE_WAIT_TIME"));
                            }
                            latch.countDown();
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
            }
            latch.await();
            executor.shutdown();
            executor.awaitTermination(10L, TimeUnit.SECONDS);
            Assert.assertTrue((totalScanRpcTime.get() > 0L ? 1 : 0) != 0);
            Assert.assertTrue((totalQueueWaitTime.get() > 0L ? 1 : 0) != 0);
        }
        finally {
            TEST_UTIL.deleteTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScanMetricsByRegionWithRegionMove() throws Exception {
        TableName tableName = TableName.valueOf((String)(TestTableScanMetrics.class.getSimpleName() + "testScanMetricsByRegionWithRegionMove"));
        try (Table table = TEST_UTIL.createMultiRegionTable(tableName, CF);){
            TEST_UTIL.loadTable(table, CF);
            byte[] bbb = Bytes.toBytes((String)"bbb");
            byte[] ccc = Bytes.toBytes((String)"ccc");
            byte[] ddc = Bytes.toBytes((String)"ddc");
            long expectedCountOfRowsScannedInMovedRegion = 0L;
            for (byte[] row : HBaseTestingUtility.ROWS) {
                if (Bytes.compareTo((byte[])row, (byte[])bbb) < 0 || Bytes.compareTo((byte[])row, (byte[])ccc) >= 0) continue;
                ++expectedCountOfRowsScannedInMovedRegion;
            }
            byte[] movedRegion = null;
            Scan scan = this.generateScan(bbb, ddc);
            scan.setEnableScanMetricsByRegion(true);
            scan.setMaxResultSize(8000L);
            try (ResultScanner rs = table.getScanner(scan);){
                boolean isFirstScanOfRegion = true;
                for (Result r : rs) {
                    byte[] row = r.getRow();
                    if (!isFirstScanOfRegion) continue;
                    movedRegion = this.moveRegion(tableName, row);
                    isFirstScanOfRegion = false;
                }
                Assert.assertNotNull(movedRegion);
                ScanMetrics scanMetrics = rs.getScanMetrics();
                Map scanMetricsByRegion = scanMetrics.collectMetricsByRegion();
                long actualCountOfRowsScannedInMovedRegion = 0L;
                HashSet<ServerName> serversForMovedRegion = new HashSet<ServerName>();
                Assert.assertEquals((long)3L, (long)scanMetricsByRegion.size());
                for (Map.Entry entry : scanMetricsByRegion.entrySet()) {
                    ScanMetricsRegionInfo scanMetricsRegionInfo = (ScanMetricsRegionInfo)entry.getKey();
                    Map metricsMap = (Map)entry.getValue();
                    if (scanMetricsRegionInfo.getEncodedRegionName().equals(Bytes.toString((byte[])movedRegion))) {
                        long rowsScanned = (Long)metricsMap.get("ROWS_SCANNED");
                        actualCountOfRowsScannedInMovedRegion += rowsScanned;
                        serversForMovedRegion.add(scanMetricsRegionInfo.getServerName());
                        Assert.assertTrue(((Long)metricsMap.get("RPC_RETRIES") == 1L || (Long)metricsMap.get("NOT_SERVING_REGION_EXCEPTION") == 1L ? 1 : 0) != 0);
                    }
                    Assert.assertEquals((long)1L, (long)((Long)metricsMap.get("REGIONS_SCANNED")));
                }
                Assert.assertEquals((long)expectedCountOfRowsScannedInMovedRegion, (long)actualCountOfRowsScannedInMovedRegion);
                Assert.assertEquals((long)2L, (long)serversForMovedRegion.size());
            }
        }
        finally {
            TEST_UTIL.deleteTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScanMetricsByRegionWithRegionSplit() throws Exception {
        TableName tableName = TableName.valueOf((String)(TestTableScanMetrics.class.getSimpleName() + "testScanMetricsByRegionWithRegionSplit"));
        try (Table table = TEST_UTIL.createMultiRegionTable(tableName, CF);){
            TEST_UTIL.loadTable(table, CF);
            byte[] bbb = Bytes.toBytes((String)"bbb");
            byte[] bmw = Bytes.toBytes((String)"bmw");
            byte[] ccb = Bytes.toBytes((String)"ccb");
            long expectedCountOfRowsScannedInRegion = 0L;
            for (byte[] row : HBaseTestingUtility.ROWS) {
                if (Bytes.compareTo((byte[])row, (byte[])bbb) < 0 || Bytes.compareTo((byte[])row, (byte[])ccb) > 0) continue;
                ++expectedCountOfRowsScannedInRegion;
            }
            HashSet expectedSplitRegionRes = new HashSet();
            Scan scan = this.generateScan(bbb, ccb);
            scan.setEnableScanMetricsByRegion(true);
            scan.setMaxResultSize(8000L);
            try (ResultScanner rs = table.getScanner(scan);){
                boolean isFirstScanOfRegion = true;
                for (Result r : rs) {
                    if (!isFirstScanOfRegion) continue;
                    this.splitRegion(tableName, bbb, bmw).forEach(region -> expectedSplitRegionRes.add(Bytes.toString((byte[])region)));
                    isFirstScanOfRegion = false;
                }
                ScanMetrics scanMetrics = rs.getScanMetrics();
                Map scanMetricsByRegion = scanMetrics.collectMetricsByRegion();
                long actualCountOfRowsScannedInRegion = 0L;
                long rpcRetiesCount = 0L;
                long notServingRegionExceptionCount = 0L;
                HashSet<String> splitRegionRes = new HashSet<String>();
                Assert.assertEquals((long)3L, (long)scanMetricsByRegion.size());
                for (Map.Entry entry : scanMetricsByRegion.entrySet()) {
                    ScanMetricsRegionInfo scanMetricsRegionInfo = (ScanMetricsRegionInfo)entry.getKey();
                    Map metricsMap = (Map)entry.getValue();
                    long rowsScanned = (Long)metricsMap.get("ROWS_SCANNED");
                    actualCountOfRowsScannedInRegion += rowsScanned;
                    splitRegionRes.add(scanMetricsRegionInfo.getEncodedRegionName());
                    if ((Long)metricsMap.get("RPC_RETRIES") == 1L) {
                        ++rpcRetiesCount;
                    }
                    if ((Long)metricsMap.get("NOT_SERVING_REGION_EXCEPTION") == 1L) {
                        ++notServingRegionExceptionCount;
                    }
                    Assert.assertEquals((long)1L, (long)((Long)metricsMap.get("REGIONS_SCANNED")));
                }
                Assert.assertEquals((long)expectedCountOfRowsScannedInRegion, (long)actualCountOfRowsScannedInRegion);
                Assert.assertEquals((long)1L, (long)rpcRetiesCount);
                Assert.assertEquals((long)1L, (long)notServingRegionExceptionCount);
                Assert.assertEquals(expectedSplitRegionRes, splitRegionRes);
            }
        }
        finally {
            TEST_UTIL.deleteTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScanMetricsByRegionWithRegionMerge() throws Exception {
        TableName tableName = TableName.valueOf((String)(TestTableScanMetrics.class.getSimpleName() + "testScanMetricsByRegionWithRegionMerge"));
        try (Table table = TEST_UTIL.createMultiRegionTable(tableName, CF);){
            TEST_UTIL.loadTable(table, CF);
            byte[] bbb = Bytes.toBytes((String)"bbb");
            byte[] ccc = Bytes.toBytes((String)"ccc");
            byte[] ddc = Bytes.toBytes((String)"ddc");
            long expectedCountOfRowsScannedInRegions = 0L;
            for (byte[] row : HBaseTestingUtility.ROWS) {
                if (Bytes.compareTo((byte[])row, (byte[])bbb) < 0 || Bytes.compareTo((byte[])row, (byte[])ddc) > 0) continue;
                ++expectedCountOfRowsScannedInRegions;
            }
            HashSet expectedMergeRegionsRes = new HashSet();
            String mergedRegionEncodedName = null;
            Scan scan = this.generateScan(bbb, ddc);
            scan.setEnableScanMetricsByRegion(true);
            scan.setMaxResultSize(8000L);
            try (ResultScanner rs = table.getScanner(scan);){
                boolean isFirstScanOfRegion = true;
                for (Result r : rs) {
                    if (!isFirstScanOfRegion) continue;
                    List<byte[]> out = this.mergeRegions(tableName, bbb, ccc);
                    mergedRegionEncodedName = Bytes.toString((byte[])out.get(2));
                    out.forEach(region -> expectedMergeRegionsRes.add(Bytes.toString((byte[])region)));
                    isFirstScanOfRegion = false;
                }
                ScanMetrics scanMetrics = rs.getScanMetrics();
                Map scanMetricsByRegion = scanMetrics.collectMetricsByRegion();
                long actualCountOfRowsScannedInRegions = 0L;
                HashSet<String> mergeRegionsRes = new HashSet<String>();
                boolean containsMergedRegionInScanMetrics = false;
                Assert.assertEquals((long)2L, (long)scanMetricsByRegion.size());
                for (Map.Entry entry : scanMetricsByRegion.entrySet()) {
                    ScanMetricsRegionInfo scanMetricsRegionInfo = (ScanMetricsRegionInfo)entry.getKey();
                    Map metricsMap = (Map)entry.getValue();
                    long rowsScanned = (Long)metricsMap.get("ROWS_SCANNED");
                    actualCountOfRowsScannedInRegions += rowsScanned;
                    mergeRegionsRes.add(scanMetricsRegionInfo.getEncodedRegionName());
                    if (scanMetricsRegionInfo.getEncodedRegionName().equals(mergedRegionEncodedName)) {
                        containsMergedRegionInScanMetrics = true;
                        Assert.assertEquals((long)1L, (long)((Long)metricsMap.get("RPC_RETRIES")));
                    } else {
                        Assert.assertEquals((long)1L, (long)((Long)metricsMap.get("NOT_SERVING_REGION_EXCEPTION")));
                    }
                    Assert.assertEquals((long)1L, (long)((Long)metricsMap.get("REGIONS_SCANNED")));
                }
                Assert.assertEquals((long)expectedCountOfRowsScannedInRegions, (long)actualCountOfRowsScannedInRegions);
                Assert.assertTrue((boolean)expectedMergeRegionsRes.containsAll(mergeRegionsRes));
                Assert.assertTrue((boolean)containsMergedRegionInScanMetrics);
            }
        }
        finally {
            TEST_UTIL.deleteTable(tableName);
        }
    }

    private Runnable getPeriodicScanMetricsCollector(final ScanMetrics scanMetrics, final Map<ScanMetricsRegionInfo, Map<String, Long>> scanMetricsByRegionCollection, final CountDownLatch latch) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    while (latch.getCount() > 0L) {
                        Map scanMetricsByRegion = scanMetrics.collectMetricsByRegion();
                        TestTableScanMetrics.this.mergeScanMetricsByRegion(scanMetricsByRegion, scanMetricsByRegionCollection);
                        Thread.sleep(RAND.nextInt(10));
                    }
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    private void mergeScanMetricsByRegion(Map<ScanMetricsRegionInfo, Map<String, Long>> srcMap, Map<ScanMetricsRegionInfo, Map<String, Long>> dstMap) {
        for (Map.Entry<ScanMetricsRegionInfo, Map<String, Long>> entry : srcMap.entrySet()) {
            ScanMetricsRegionInfo scanMetricsRegionInfo = entry.getKey();
            Map<String, Long> metricsMap = entry.getValue();
            metricsMap.remove("MILLIS_BETWEEN_NEXTS");
            metricsMap.remove("RPC_SCAN_PROCESSING_TIME");
            metricsMap.remove("RPC_SCAN_QUEUE_WAIT_TIME");
            if (dstMap.containsKey(scanMetricsRegionInfo)) {
                Map<String, Long> dstMetricsMap = dstMap.get(scanMetricsRegionInfo);
                for (Map.Entry<String, Long> metricEntry : metricsMap.entrySet()) {
                    String metricName = metricEntry.getKey();
                    Long existingValue = dstMetricsMap.get(metricName);
                    Long newValue = metricEntry.getValue();
                    dstMetricsMap.put(metricName, existingValue + newValue);
                }
                continue;
            }
            dstMap.put(scanMetricsRegionInfo, metricsMap);
        }
    }

    private byte[] moveRegion(TableName tableName, byte[] startRow) throws IOException {
        Admin admin = TEST_UTIL.getAdmin();
        RegionLocator regionLocator = CONN.getRegionLocator(tableName);
        HRegionLocation loc = regionLocator.getRegionLocation(startRow, true);
        byte[] encodedRegionName = loc.getRegion().getEncodedNameAsBytes();
        ServerName initialServerName = loc.getServerName();
        admin.move(encodedRegionName);
        ServerName finalServerName = regionLocator.getRegionLocation(startRow, true).getServerName();
        Assert.assertNotEquals((Object)initialServerName, (Object)finalServerName);
        return encodedRegionName;
    }

    private List<byte[]> splitRegion(TableName tableName, byte[] startRow, byte[] splitKey) throws IOException {
        Admin admin = TEST_UTIL.getAdmin();
        RegionLocator regionLocator = CONN.getRegionLocator(tableName);
        HRegionLocation topLoc = regionLocator.getRegionLocation(startRow, true);
        byte[] initialEncodedTopRegionName = topLoc.getRegion().getEncodedNameAsBytes();
        ServerName initialTopServerName = topLoc.getServerName();
        HRegionLocation bottomLoc = regionLocator.getRegionLocation(splitKey, true);
        byte[] initialEncodedBottomRegionName = bottomLoc.getRegion().getEncodedNameAsBytes();
        ServerName initialBottomServerName = bottomLoc.getServerName();
        Assert.assertEquals((Object)initialTopServerName, (Object)initialBottomServerName);
        Assert.assertTrue((boolean)Bytes.equals((byte[])initialEncodedTopRegionName, (byte[])initialEncodedBottomRegionName));
        FutureUtils.get((Future)admin.splitRegionAsync(initialEncodedTopRegionName, splitKey));
        topLoc = regionLocator.getRegionLocation(startRow, true);
        byte[] finalEncodedTopRegionName = topLoc.getRegion().getEncodedNameAsBytes();
        bottomLoc = regionLocator.getRegionLocation(splitKey, true);
        byte[] finalEncodedBottomRegionName = bottomLoc.getRegion().getEncodedNameAsBytes();
        Assert.assertFalse((boolean)Bytes.equals((byte[])finalEncodedTopRegionName, (byte[])finalEncodedBottomRegionName));
        Assert.assertFalse((boolean)Bytes.equals((byte[])initialEncodedTopRegionName, (byte[])finalEncodedBottomRegionName));
        Assert.assertFalse((boolean)Bytes.equals((byte[])initialEncodedBottomRegionName, (byte[])finalEncodedTopRegionName));
        return Arrays.asList(initialEncodedTopRegionName, finalEncodedTopRegionName, finalEncodedBottomRegionName);
    }

    private List<byte[]> mergeRegions(TableName tableName, byte[] topRegion, byte[] bottomRegion) throws IOException {
        Admin admin = TEST_UTIL.getAdmin();
        RegionLocator regionLocator = CONN.getRegionLocator(tableName);
        HRegionLocation topLoc = regionLocator.getRegionLocation(topRegion, true);
        byte[] initialEncodedTopRegionName = topLoc.getRegion().getEncodedNameAsBytes();
        String initialTopRegionEndKey = Bytes.toString((byte[])topLoc.getRegion().getEndKey());
        HRegionLocation bottomLoc = regionLocator.getRegionLocation(bottomRegion, true);
        byte[] initialEncodedBottomRegionName = bottomLoc.getRegion().getEncodedNameAsBytes();
        String initialBottomRegionStartKey = Bytes.toString((byte[])bottomLoc.getRegion().getStartKey());
        Assert.assertFalse((boolean)Bytes.equals((byte[])initialEncodedTopRegionName, (byte[])initialEncodedBottomRegionName));
        Assert.assertEquals((Object)initialBottomRegionStartKey, (Object)initialTopRegionEndKey);
        FutureUtils.get((Future)admin.mergeRegionsAsync((byte[][])new byte[][]{initialEncodedTopRegionName, initialEncodedBottomRegionName}, false));
        topLoc = regionLocator.getRegionLocation(topRegion, true);
        byte[] finalEncodedTopRegionName = topLoc.getRegion().getEncodedNameAsBytes();
        bottomLoc = regionLocator.getRegionLocation(bottomRegion, true);
        byte[] finalEncodedBottomRegionName = bottomLoc.getRegion().getEncodedNameAsBytes();
        Assert.assertTrue((boolean)Bytes.equals((byte[])finalEncodedTopRegionName, (byte[])finalEncodedBottomRegionName));
        Assert.assertFalse((boolean)Bytes.equals((byte[])initialEncodedTopRegionName, (byte[])finalEncodedTopRegionName));
        Assert.assertFalse((boolean)Bytes.equals((byte[])initialEncodedBottomRegionName, (byte[])finalEncodedTopRegionName));
        return Arrays.asList(initialEncodedTopRegionName, initialEncodedBottomRegionName, finalEncodedTopRegionName);
    }
}

