/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.ConnectionRegistry;
import org.apache.hadoop.hbase.client.ConnectionRegistryFactory;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionReplicaTestHelper;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractTestRegionLocator {
    protected static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    protected static TableName TABLE_NAME = TableName.valueOf((String)"Locator");
    protected static byte[] FAMILY = Bytes.toBytes((String)"family");
    protected static int REGION_REPLICATION = 3;
    protected static byte[][] SPLIT_KEYS;

    protected static void startClusterAndCreateTable() throws Exception {
        UTIL.startMiniCluster(3);
        HBaseTestingUtility.setReplicas(UTIL.getAdmin(), TableName.META_TABLE_NAME, REGION_REPLICATION);
        TableDescriptor td = TableDescriptorBuilder.newBuilder((TableName)TABLE_NAME).setRegionReplication(REGION_REPLICATION).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY)).build();
        SPLIT_KEYS = new byte[9][];
        for (int i = 0; i < 9; ++i) {
            AbstractTestRegionLocator.SPLIT_KEYS[i] = Bytes.toBytes((String)Integer.toString(i + 1));
        }
        UTIL.getAdmin().createTable(td, SPLIT_KEYS);
        UTIL.waitTableAvailable(TABLE_NAME);
        try (ConnectionRegistry registry = ConnectionRegistryFactory.getRegistry((Configuration)UTIL.getConfiguration());){
            RegionReplicaTestHelper.waitUntilAllMetaReplicasAreReady(UTIL, registry);
        }
        UTIL.getAdmin().balancerSwitch(false, true);
    }

    @After
    public void tearDownAfterTest() throws IOException {
        this.clearCache(TABLE_NAME);
        this.clearCache(TableName.META_TABLE_NAME);
    }

    private byte[] getStartKey(int index) {
        return index == 0 ? HConstants.EMPTY_START_ROW : SPLIT_KEYS[index - 1];
    }

    private byte[] getEndKey(int index) {
        return index == SPLIT_KEYS.length ? HConstants.EMPTY_END_ROW : SPLIT_KEYS[index];
    }

    private void assertStartKeys(byte[][] startKeys) {
        Assert.assertEquals((long)(SPLIT_KEYS.length + 1), (long)startKeys.length);
        for (int i = 0; i < startKeys.length; ++i) {
            Assert.assertArrayEquals((byte[])this.getStartKey(i), (byte[])startKeys[i]);
        }
    }

    private void assertEndKeys(byte[][] endKeys) {
        Assert.assertEquals((long)(SPLIT_KEYS.length + 1), (long)endKeys.length);
        for (int i = 0; i < endKeys.length; ++i) {
            Assert.assertArrayEquals((byte[])this.getEndKey(i), (byte[])endKeys[i]);
        }
    }

    @Test
    public void testStartEndKeys() throws IOException {
        this.assertStartKeys(this.getStartKeys(TABLE_NAME));
        this.assertEndKeys(this.getEndKeys(TABLE_NAME));
        Pair<byte[][], byte[][]> startEndKeys = this.getStartEndKeys(TABLE_NAME);
        this.assertStartKeys((byte[][])startEndKeys.getFirst());
        this.assertEndKeys((byte[][])startEndKeys.getSecond());
    }

    private void assertRegionLocation(HRegionLocation loc, int index, int replicaId) {
        RegionInfo region = loc.getRegion();
        byte[] startKey = this.getStartKey(index);
        Assert.assertArrayEquals((byte[])startKey, (byte[])region.getStartKey());
        Assert.assertArrayEquals((byte[])this.getEndKey(index), (byte[])region.getEndKey());
        Assert.assertEquals((long)replicaId, (long)region.getReplicaId());
        ServerName expected = this.findRegionLocation(TABLE_NAME, region.getStartKey(), replicaId);
        Assert.assertEquals((Object)expected, (Object)loc.getServerName());
    }

    private ServerName findRegionLocation(TableName tableName, byte[] startKey, int replicaId) {
        return UTIL.getMiniHBaseCluster().getRegionServerThreads().stream().map(t -> t.getRegionServer()).filter(rs -> rs.getRegions(tableName).stream().map(Region::getRegionInfo).anyMatch(r -> r.containsRow(startKey) && r.getReplicaId() == replicaId)).findFirst().get().getServerName();
    }

    @Test
    public void testGetRegionLocation() throws IOException {
        for (int i = 0; i <= SPLIT_KEYS.length; ++i) {
            for (int replicaId = 0; replicaId < REGION_REPLICATION; ++replicaId) {
                this.assertRegionLocation(this.getRegionLocation(TABLE_NAME, this.getStartKey(i), replicaId), i, replicaId);
            }
        }
    }

    @Test
    public void testGetRegionLocations() throws IOException {
        for (int i = 0; i <= SPLIT_KEYS.length; ++i) {
            List<HRegionLocation> locs = this.getRegionLocations(TABLE_NAME, this.getStartKey(i));
            Assert.assertEquals((long)REGION_REPLICATION, (long)locs.size());
            for (int replicaId = 0; replicaId < REGION_REPLICATION; ++replicaId) {
                this.assertRegionLocation(locs.get(replicaId), i, replicaId);
            }
        }
    }

    @Test
    public void testGetAllRegionLocations() throws IOException {
        List<HRegionLocation> locs = this.getAllRegionLocations(TABLE_NAME);
        Assert.assertEquals((long)(REGION_REPLICATION * (SPLIT_KEYS.length + 1)), (long)locs.size());
        Collections.sort(locs, (l1, l2) -> {
            int c = Bytes.compareTo((byte[])l1.getRegion().getStartKey(), (byte[])l2.getRegion().getStartKey());
            if (c != 0) {
                return c;
            }
            return Integer.compare(l1.getRegion().getReplicaId(), l2.getRegion().getReplicaId());
        });
        for (int i = 0; i <= SPLIT_KEYS.length; ++i) {
            for (int replicaId = 0; replicaId < REGION_REPLICATION; ++replicaId) {
                this.assertRegionLocation(locs.get(i * REGION_REPLICATION + replicaId), i, replicaId);
            }
        }
    }

    private void assertMetaStartOrEndKeys(byte[][] keys) {
        Assert.assertEquals((long)1L, (long)keys.length);
        Assert.assertArrayEquals((byte[])HConstants.EMPTY_BYTE_ARRAY, (byte[])keys[0]);
    }

    private void assertMetaRegionLocation(HRegionLocation loc, int replicaId) {
        RegionInfo region = loc.getRegion();
        Assert.assertArrayEquals((byte[])HConstants.EMPTY_START_ROW, (byte[])region.getStartKey());
        Assert.assertArrayEquals((byte[])HConstants.EMPTY_END_ROW, (byte[])region.getEndKey());
        Assert.assertEquals((long)replicaId, (long)region.getReplicaId());
        ServerName expected = this.findRegionLocation(TableName.META_TABLE_NAME, region.getStartKey(), replicaId);
        Assert.assertEquals((Object)expected, (Object)loc.getServerName());
    }

    private void assertMetaRegionLocations(List<HRegionLocation> locs) {
        Assert.assertEquals((long)REGION_REPLICATION, (long)locs.size());
        for (int replicaId = 0; replicaId < REGION_REPLICATION; ++replicaId) {
            this.assertMetaRegionLocation(locs.get(replicaId), replicaId);
        }
    }

    @Test
    public void testMeta() throws IOException {
        this.assertMetaStartOrEndKeys(this.getStartKeys(TableName.META_TABLE_NAME));
        this.assertMetaStartOrEndKeys(this.getEndKeys(TableName.META_TABLE_NAME));
        Pair<byte[][], byte[][]> startEndKeys = this.getStartEndKeys(TableName.META_TABLE_NAME);
        this.assertMetaStartOrEndKeys((byte[][])startEndKeys.getFirst());
        this.assertMetaStartOrEndKeys((byte[][])startEndKeys.getSecond());
        for (int replicaId = 0; replicaId < REGION_REPLICATION; ++replicaId) {
            this.assertMetaRegionLocation(this.getRegionLocation(TableName.META_TABLE_NAME, HConstants.EMPTY_START_ROW, replicaId), replicaId);
        }
        this.assertMetaRegionLocations(this.getRegionLocations(TableName.META_TABLE_NAME, HConstants.EMPTY_START_ROW));
        this.assertMetaRegionLocations(this.getAllRegionLocations(TableName.META_TABLE_NAME));
    }

    protected abstract byte[][] getStartKeys(TableName var1) throws IOException;

    protected abstract byte[][] getEndKeys(TableName var1) throws IOException;

    protected abstract Pair<byte[][], byte[][]> getStartEndKeys(TableName var1) throws IOException;

    protected abstract HRegionLocation getRegionLocation(TableName var1, byte[] var2, int var3) throws IOException;

    protected abstract List<HRegionLocation> getRegionLocations(TableName var1, byte[] var2) throws IOException;

    protected abstract List<HRegionLocation> getAllRegionLocations(TableName var1) throws IOException;

    protected abstract void clearCache(TableName var1) throws IOException;
}

