/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import java.util.Collection;
import java.util.Map;
import org.testng.ISuite;
import org.testng.ISuiteResult;
import org.testng.ITestContext;
import org.testng.ITestResult;
import org.testng.collections.Maps;
import org.testng.internal.invokers.SuiteRunnerMap;
import org.testng.xml.XmlSuite;

class SuiteResultCounts {
    int m_total = 0;
    int m_passes = 0;
    int m_skipped = 0;
    int m_failed = 0;
    int m_confFailures = 0;
    int m_confSkips = 0;
    int m_retries = 0;
    private static final String SKIPPED = "skipped";
    private static final String RETRIED = "retried";

    SuiteResultCounts() {
    }

    public void calculateResultCounts(XmlSuite xmlSuite, SuiteRunnerMap suiteRunnerMap) {
        ISuite iSuite = suiteRunnerMap.get(xmlSuite);
        if (iSuite == null) {
            return;
        }
        Map<String, ISuiteResult> results = iSuite.getResults();
        if (results == null) {
            return;
        }
        Collection<ISuiteResult> tempSuiteResult = results.values();
        for (ISuiteResult isr : tempSuiteResult) {
            ITestContext ctx = isr.getTestContext();
            int passes = ctx.getPassedTests().size();
            Map<String, Integer> seggregated = SuiteResultCounts.seggregateSkippedTests(ctx);
            int skipped = seggregated.get(SKIPPED);
            this.m_skipped += skipped;
            int retried = seggregated.get(RETRIED);
            this.m_retries += retried;
            int failed = ctx.getFailedTests().size() + ctx.getFailedButWithinSuccessPercentageTests().size();
            this.m_failed += failed;
            this.m_confFailures += ctx.getFailedConfigurations().size();
            this.m_confSkips += ctx.getSkippedConfigurations().size();
            this.m_passes += passes;
            this.m_total += passes + failed + skipped + retried;
        }
        for (XmlSuite childSuite : xmlSuite.getChildSuites()) {
            this.calculateResultCounts(childSuite, suiteRunnerMap);
        }
    }

    private static Map<String, Integer> seggregateSkippedTests(ITestContext context) {
        int skipped = 0;
        int retried = 0;
        for (ITestResult result : context.getSkippedTests().getAllResults()) {
            if (result.wasRetried()) {
                ++retried;
                continue;
            }
            ++skipped;
        }
        Map<String, Integer> data = Maps.newHashMap();
        data.put(SKIPPED, skipped);
        data.put(RETRIED, retried);
        return data;
    }
}

