/*
 * Decompiled with CFR 0.152.
 */
package org.grails.taglib;

import grails.core.GrailsApplication;
import grails.core.GrailsClass;
import grails.core.gsp.GrailsTagLibClass;
import grails.core.support.GrailsApplicationAware;
import groovy.lang.GroovyObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.grails.core.exceptions.GrailsConfigurationException;
import org.grails.taglib.NamespacedTagDispatcher;
import org.grails.taglib.TemplateNamespacedTagDispatcher;
import org.grails.taglib.encoder.WithCodecHelper;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class TagLibraryLookup
implements ApplicationContextAware,
GrailsApplicationAware,
InitializingBean {
    protected ApplicationContext applicationContext;
    protected GrailsApplication grailsApplication;
    protected Map<String, Map<String, Object>> tagNamespaces = new LinkedHashMap<String, Map<String, Object>>();
    protected Map<String, NamespacedTagDispatcher> namespaceDispatchers = new LinkedHashMap<String, NamespacedTagDispatcher>();
    protected Map<String, Set<String>> tagsThatReturnObjectForNamespace = new LinkedHashMap<String, Set<String>>();
    protected Map<String, Map<String, Map<String, Object>>> encodeAsForTagNamespaces = new LinkedHashMap<String, Map<String, Map<String, Object>>>();

    @Override
    public void afterPropertiesSet() throws Exception {
        if (this.grailsApplication == null || this.applicationContext == null) {
            return;
        }
        try {
            this.registerTagLibraries();
        }
        catch (GrailsConfigurationException grailsConfigurationException) {
            // empty catch block
        }
        this.registerTemplateNamespace();
        this.registerNamespaceDispatchers();
    }

    private void registerNamespaceDispatchers() {
        for (String namespace : this.tagNamespaces.keySet()) {
            this.registerNamespaceDispatcher(namespace);
        }
    }

    protected void registerNamespaceDispatcher(String namespace) {
        this.namespaceDispatchers.put(namespace, new NamespacedTagDispatcher(namespace, null, this.grailsApplication, this));
    }

    protected void registerTagLibraries() {
        GrailsClass[] taglibs;
        for (GrailsClass grailsClass : taglibs = this.grailsApplication.getArtefacts("TagLib")) {
            this.registerTagLib((GrailsTagLibClass)grailsClass, true);
        }
    }

    protected void registerTemplateNamespace() {
        this.namespaceDispatchers.put("tmpl", new TemplateNamespacedTagDispatcher(null, this.grailsApplication, this));
    }

    public void registerTagLib(GrailsTagLibClass taglib2) {
        this.registerTagLib(taglib2, false);
    }

    private void registerTagLib(GrailsTagLibClass taglib2, boolean isInitialization) {
        Map<String, Object> tags;
        Set<String> tagsThatReturnObject;
        String namespace = taglib2.getNamespace();
        if (!isInitialization) {
            this.registerNamespaceDispatcher(namespace);
        }
        if ((tagsThatReturnObject = this.tagsThatReturnObjectForNamespace.get(namespace)) == null) {
            tagsThatReturnObject = new HashSet<String>();
            this.tagsThatReturnObjectForNamespace.put(namespace, tagsThatReturnObject);
        }
        if ((tags = this.tagNamespaces.get(namespace)) == null) {
            tags = new HashMap<String, Object>();
            this.tagNamespaces.put(namespace, tags);
        }
        for (String tagName : taglib2.getTagNames()) {
            this.putTagLib(tags, tagName, taglib2);
            tagsThatReturnObject.remove(tagName);
        }
        for (String tagName : taglib2.getTagNamesThatReturnObject()) {
            tagsThatReturnObject.add(tagName);
        }
        Map<String, Map<String, Object>> encodeAsForTagNamespace = this.encodeAsForTagNamespaces.get(namespace);
        if (encodeAsForTagNamespace == null) {
            encodeAsForTagNamespace = new HashMap<String, Map<String, Object>>();
            this.encodeAsForTagNamespaces.put(namespace, encodeAsForTagNamespace);
        }
        Map<String, Object> defaultEncodeAsForTagLib = null;
        if (taglib2.getDefaultEncodeAs() != null) {
            defaultEncodeAsForTagLib = Collections.unmodifiableMap(WithCodecHelper.makeSettingsCanonical(taglib2.getDefaultEncodeAs()));
        }
        for (String tagName : taglib2.getTagNames()) {
            Object codecInfo = taglib2.getEncodeAsForTag(tagName);
            Map<String, Object> codecInfoMap = WithCodecHelper.mergeSettingsAndMakeCanonical(codecInfo, defaultEncodeAsForTagLib);
            if (codecInfoMap == null) continue;
            encodeAsForTagNamespace.put(tagName, codecInfoMap);
        }
    }

    protected void putTagLib(Map<String, Object> tags, String name, GrailsTagLibClass taglib2) {
        tags.put(name, this.applicationContext.getBean(taglib2.getFullName()));
    }

    public GroovyObject lookupTagLibrary(String namespace, String tagName) {
        Map<String, Object> tags = this.tagNamespaces.get(namespace);
        if (tags == null) {
            return null;
        }
        return (GroovyObject)tags.get(tagName);
    }

    public boolean doesTagReturnObject(String namespace, String tagName) {
        Set<String> tagsThatReturnObject = this.tagsThatReturnObjectForNamespace.get(namespace);
        return tagsThatReturnObject != null && tagsThatReturnObject.contains(tagName);
    }

    public Map<String, Object> getEncodeAsForTag(String namespace, String tagName) {
        Map<String, Map<String, Object>> encodeAsForTagNamespace = this.encodeAsForTagNamespaces.get(namespace);
        return encodeAsForTagNamespace != null ? encodeAsForTagNamespace.get(tagName) : null;
    }

    public NamespacedTagDispatcher lookupNamespaceDispatcher(String namespace) {
        return this.namespaceDispatchers.get(namespace);
    }

    public boolean hasNamespace(String namespace) {
        return this.namespaceDispatchers.containsKey(namespace);
    }

    public Set<String> getAvailableNamespaces() {
        return this.namespaceDispatchers.keySet();
    }

    public Set<String> getAvailableTags(String namespace) {
        Map<String, Object> tags = this.tagNamespaces.get(namespace);
        if (tags == null) {
            return Collections.emptySet();
        }
        return tags.keySet();
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public void setGrailsApplication(GrailsApplication grailsApplication) {
        this.grailsApplication = grailsApplication;
    }
}

