/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.dbms.derby;

import org.apache.empire.data.DataType;
import org.apache.empire.db.DBDDLGenerator;
import org.apache.empire.db.DBSQLBuilder;
import org.apache.empire.db.DBTableColumn;
import org.apache.empire.dbms.derby.DBMSHandlerDerby;

public class DerbyDDLGenerator
extends DBDDLGenerator<DBMSHandlerDerby> {
    public DerbyDDLGenerator(DBMSHandlerDerby dbms) {
        super(dbms);
        this.initDataTypes();
    }

    private void initDataTypes() {
        this.DATATYPE_BOOLEAN = "SMALLINT";
    }

    @Override
    protected boolean appendColumnDataType(DataType type, double size, DBTableColumn c, DBSQLBuilder sql) {
        switch (type) {
            case AUTOINC: {
                super.appendColumnDataType(type, size, c, sql);
                if (((DBMSHandlerDerby)this.dbms).isUseSequenceTable()) break;
                sql.append(" GENERATED ALWAYS AS IDENTITY");
                break;
            }
            default: {
                return super.appendColumnDataType(type, size, c, sql);
            }
        }
        return true;
    }

    @Override
    protected void appendColumnDesc(DBTableColumn c, boolean alter, DBSQLBuilder sql) {
        c.addSQL(sql, 1L);
        if (alter) {
            sql.append(" SET DATA TYPE ");
        } else {
            sql.append(" ");
        }
        if (!this.appendColumnDataType(c.getDataType(), c.getSize(), c, sql)) {
            return;
        }
        if (this.isDDLColumnDefaults() && !c.isAutoGenerated() && c.getDefaultValue() != null) {
            sql.append(" DEFAULT ");
            sql.appendValue(c.getDataType(), c.getDefaultValue());
        }
        if (c.isRequired() || c.isAutoGenerated()) {
            sql.append(" NOT NULL");
        }
    }
}

