/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.impl;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import org.apache.directory.api.ldap.model.cursor.Cursor;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapOtherException;
import org.apache.directory.api.ldap.model.filter.AndNode;
import org.apache.directory.api.ldap.model.filter.ApproximateNode;
import org.apache.directory.api.ldap.model.filter.AssertionNode;
import org.apache.directory.api.ldap.model.filter.BranchNode;
import org.apache.directory.api.ldap.model.filter.EqualityNode;
import org.apache.directory.api.ldap.model.filter.ExprNode;
import org.apache.directory.api.ldap.model.filter.ExtensibleNode;
import org.apache.directory.api.ldap.model.filter.GreaterEqNode;
import org.apache.directory.api.ldap.model.filter.LeafNode;
import org.apache.directory.api.ldap.model.filter.LessEqNode;
import org.apache.directory.api.ldap.model.filter.NotNode;
import org.apache.directory.api.ldap.model.filter.OrNode;
import org.apache.directory.api.ldap.model.filter.PresenceNode;
import org.apache.directory.api.ldap.model.filter.ScopeNode;
import org.apache.directory.api.ldap.model.filter.SimpleNode;
import org.apache.directory.api.ldap.model.filter.SubstringNode;
import org.apache.directory.api.util.Strings;
import org.apache.directory.server.core.api.partition.Partition;
import org.apache.directory.server.core.api.partition.PartitionTxn;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.Index;
import org.apache.directory.server.xdbm.IndexNotFoundException;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.server.xdbm.search.Optimizer;

public class DefaultOptimizer
implements Optimizer {
    static final String CANDIDATES_ANNOTATION_KEY = "candidates";
    static final String COUNT_ANNOTATION = "count";
    private final Store db;
    private String contextEntryId;

    public DefaultOptimizer(Store db) {
        this.db = db;
    }

    private String getContextEntryId(PartitionTxn partitionTxn) throws LdapException {
        if (this.contextEntryId == null) {
            try {
                this.contextEntryId = this.db.getEntryId(partitionTxn, ((Partition)((Object)this.db)).getSuffixDn());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.contextEntryId == null) {
            return Partition.DEFAULT_ID;
        }
        return this.contextEntryId;
    }

    @Override
    public Long annotate(PartitionTxn partitionTxn, ExprNode node) throws LdapException {
        Long count = Long.MAX_VALUE;
        if (node instanceof ScopeNode) {
            count = this.getScopeScan(partitionTxn, (ScopeNode)node);
        } else if (!(node instanceof AssertionNode)) {
            if (node.isLeaf()) {
                LeafNode leaf = (LeafNode)node;
                try {
                    if (node instanceof PresenceNode) {
                        count = this.getPresenceScan(partitionTxn, (PresenceNode)leaf);
                    }
                    if (node instanceof EqualityNode) {
                        count = this.getEqualityScan(partitionTxn, (EqualityNode)leaf);
                    }
                    if (node instanceof GreaterEqNode) {
                        count = this.getGreaterLessScan(partitionTxn, (GreaterEqNode)leaf, true);
                    }
                    if (node instanceof LessEqNode) {
                        count = this.getGreaterLessScan(partitionTxn, (SimpleNode)leaf, false);
                    }
                    if (node instanceof SubstringNode) {
                        count = this.getSubstringScan(partitionTxn, (SubstringNode)leaf);
                    }
                    if (node instanceof ExtensibleNode) {
                        count = this.getFullScan(partitionTxn, leaf);
                    }
                    if (node instanceof ApproximateNode) {
                        count = this.getEqualityScan(partitionTxn, (ApproximateNode)leaf);
                    }
                    throw new IllegalArgumentException(I18n.err(I18n.ERR_711, new Object[0]));
                }
                catch (IOException | IndexNotFoundException e) {
                    throw new LdapOtherException(e.getMessage(), e);
                }
            } else if (node instanceof AndNode) {
                count = this.getConjunctionScan(partitionTxn, (AndNode)node);
            } else if (node instanceof OrNode) {
                count = this.getDisjunctionScan(partitionTxn, (OrNode)node);
            } else if (node instanceof NotNode) {
                this.annotate(partitionTxn, ((NotNode)node).getFirstChild());
                count = Long.MAX_VALUE;
            } else {
                count = Long.MAX_VALUE;
            }
        }
        if (count < 0L) {
            count = Long.MAX_VALUE;
        }
        node.set(COUNT_ANNOTATION, count);
        return count;
    }

    private long getConjunctionScan(PartitionTxn partitionTxn, BranchNode node) throws LdapException {
        long count = Long.MAX_VALUE;
        List<ExprNode> children = node.getChildren();
        for (ExprNode child : children) {
            if (count == 1L && child instanceof ScopeNode) break;
            this.annotate(partitionTxn, child);
            count = Math.min((Long)child.get(COUNT_ANNOTATION), count);
            if (count != 0L) continue;
            break;
        }
        return count;
    }

    private long getDisjunctionScan(PartitionTxn partitionTxn, BranchNode node) throws LdapException {
        List<ExprNode> children = node.getChildren();
        long total = 0L;
        for (ExprNode child : children) {
            this.annotate(partitionTxn, child);
            if ((total += ((Long)child.get(COUNT_ANNOTATION)).longValue()) != Long.MAX_VALUE) continue;
            break;
        }
        return total;
    }

    private <V> long getEqualityScan(PartitionTxn partitionTxn, SimpleNode<V> node) throws LdapException, IndexNotFoundException, IOException {
        if (this.db.hasIndexOn(node.getAttributeType())) {
            Index<?, String> idx = this.db.getIndex(node.getAttributeType());
            String normalizedKey = node.getValue().isSchemaAware() ? node.getValue().getNormalized() : node.getAttributeType().getEquality().getNormalizer().normalize(node.getValue().getString());
            Cursor<String> result = idx.forwardValueCursor(partitionTxn, normalizedKey);
            HashSet<String> values = new HashSet<String>();
            int nbFound = 0;
            for (String value : result) {
                values.add(value);
                if (++nbFound != 100) continue;
                break;
            }
            result.close();
            if (nbFound < 100) {
                node.set(CANDIDATES_ANNOTATION_KEY, values);
                return values.size();
            }
            node.set(CANDIDATES_ANNOTATION_KEY, null);
            return idx.count(partitionTxn, node.getValue().getNormalized());
        }
        return Long.MAX_VALUE;
    }

    private <V> long getGreaterLessScan(PartitionTxn partitionTxn, SimpleNode<V> node, boolean isGreaterThan) throws LdapException, IndexNotFoundException {
        if (this.db.hasIndexOn(node.getAttributeType())) {
            Index<?, String> idx = this.db.getIndex(node.getAttributeType());
            if (isGreaterThan) {
                return idx.greaterThanCount(partitionTxn, node.getValue().getString());
            }
            return idx.lessThanCount(partitionTxn, node.getValue().getString());
        }
        return Long.MAX_VALUE;
    }

    private long getSubstringScan(PartitionTxn partitionTxn, SubstringNode node) throws LdapException, IndexNotFoundException {
        if (this.db.hasIndexOn(node.getAttributeType())) {
            Index<?, String> idx = this.db.getIndex(node.getAttributeType());
            String initial = node.getInitial();
            if (Strings.isEmpty(initial)) {
                return idx.count(partitionTxn);
            }
            return idx.greaterThanCount(partitionTxn, initial);
        }
        return Long.MAX_VALUE;
    }

    private long getFullScan(PartitionTxn partitionTxn, LeafNode node) throws LdapException, IndexNotFoundException {
        if (this.db.hasIndexOn(node.getAttributeType())) {
            Index<?, String> idx = this.db.getIndex(node.getAttributeType());
            return idx.count(partitionTxn);
        }
        return Long.MAX_VALUE;
    }

    private long getPresenceScan(PartitionTxn partitionTxn, PresenceNode node) throws LdapException {
        if (this.db.hasUserIndexOn(node.getAttributeType()) || node.getAttributeType().getOid().equals("2.5.18.5")) {
            Index<String, String> presenceIndex = this.db.getPresenceIndex();
            return presenceIndex.count(partitionTxn, node.getAttributeType().getOid());
        }
        if (this.db.hasSystemIndexOn(node.getAttributeType()) || node.getAttributeType().getOid() == "1.3.6.1.1.16.4") {
            return this.db.count(partitionTxn);
        }
        return Long.MAX_VALUE;
    }

    private long getScopeScan(PartitionTxn partitionTxn, ScopeNode node) throws LdapException {
        String id = node.getBaseId();
        switch (node.getScope()) {
            case OBJECT: {
                return 1L;
            }
            case ONELEVEL: {
                return this.db.getChildCount(partitionTxn, id);
            }
            case SUBTREE: {
                if (id == this.getContextEntryId(partitionTxn)) {
                    return this.db.count(partitionTxn);
                }
                return (long)this.db.getRdnIndex().reverseLookup(partitionTxn, id).getNbDescendants() + 1L;
            }
        }
        throw new IllegalArgumentException(I18n.err(I18n.ERR_713, new Object[0]));
    }
}

