/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.authz;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.directory.SearchControls;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.entry.ModificationOperation;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapOperationException;
import org.apache.directory.api.ldap.model.filter.EqualityNode;
import org.apache.directory.api.ldap.model.filter.OrNode;
import org.apache.directory.api.ldap.model.message.AliasDerefMode;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.DnFactory;
import org.apache.directory.server.core.api.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.api.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.api.partition.Partition;
import org.apache.directory.server.core.api.partition.PartitionNexus;
import org.apache.directory.server.i18n.I18n;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupCache {
    private static final Logger LOG = LoggerFactory.getLogger(GroupCache.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private final PartitionNexus nexus;
    private final DirectoryService directoryService;
    private SchemaManager schemaManager;
    private DnFactory dnFactory;
    private Dn administratorsGroupDn;
    private Dn adminSystemDn;
    private static final Set<String> EMPTY_GROUPS = new HashSet<String>();
    private final Map<String, Set<String>> groups = new ConcurrentHashMap<String, Set<String>>();

    public GroupCache(DirectoryService dirService) throws LdapException {
        this.directoryService = dirService;
        this.schemaManager = dirService.getSchemaManager();
        this.dnFactory = dirService.getDnFactory();
        this.nexus = dirService.getPartitionNexus();
        this.administratorsGroupDn = this.parseNormalized("cn=Administrators,ou=groups,ou=system");
        this.initialize(dirService.getAdminSession());
    }

    private Dn parseNormalized(String name) throws LdapException {
        return this.dnFactory.create(name);
    }

    private void initialize(CoreSession session) throws LdapException {
        Set<String> suffixes = this.nexus.listSuffixes();
        for (String suffix : suffixes) {
            OrNode filter = new OrNode();
            AttributeType ocAt = this.directoryService.getAtProvider().getObjectClass();
            filter.addNode(new EqualityNode(ocAt, new Value(ocAt, "groupOfNames")));
            filter.addNode(new EqualityNode(ocAt, new Value(ocAt, "groupOfUniqueNames")));
            Dn baseDn = this.dnFactory.create(suffix);
            SearchControls ctls = new SearchControls();
            ctls.setSearchScope(2);
            ctls.setReturningAttributes(new String[]{"*", "+"});
            Partition partition = this.nexus.getPartition(baseDn);
            SearchOperationContext searchOperationContext = new SearchOperationContext(session, baseDn, filter, ctls);
            searchOperationContext.setAliasDerefMode(AliasDerefMode.DEREF_ALWAYS);
            searchOperationContext.setPartition(partition);
            searchOperationContext.setTransaction(partition.beginReadTransaction());
            EntryFilteringCursor results = this.nexus.search(searchOperationContext);
            try {
                while (results.next()) {
                    Attribute members;
                    Entry result = (Entry)results.get();
                    Dn groupDn = result.getDn();
                    if (!groupDn.isSchemaAware()) {
                        groupDn = new Dn(this.schemaManager, groupDn);
                    }
                    if ((members = this.getMemberAttribute(result)) != null) {
                        HashSet<String> memberSet = new HashSet<String>(members.size());
                        this.addMembers(memberSet, members);
                        this.groups.put(groupDn.getNormName(), memberSet);
                        continue;
                    }
                    LOG.warn("Found group '{}' without any member or uniqueMember attributes", (Object)groupDn.getName());
                }
                results.close();
            }
            catch (Exception e) {
                LOG.error("Exception while initializing the groupCache:  {}", e.getCause());
                throw new LdapOperationException(e.getMessage(), e);
            }
        }
        this.adminSystemDn = new Dn(this.schemaManager, "0.9.2342.19200300.100.1.1= admin ,2.5.4.11= system ");
        if (IS_DEBUG) {
            LOG.debug("group cache contents on startup:\n {}", (Object)this.groups);
        }
    }

    private Attribute getMemberAttribute(Entry entry) {
        Attribute member = entry.get(this.directoryService.getAtProvider().getMember());
        if (member != null) {
            return member;
        }
        Attribute uniqueMember = entry.get(this.directoryService.getAtProvider().getUniqueMember());
        if (uniqueMember != null) {
            return uniqueMember;
        }
        return null;
    }

    private void addMembers(Set<String> memberSet, Attribute members) throws LdapException {
        for (Value value : members) {
            String member = value.getString();
            Dn memberDn = null;
            try {
                memberDn = this.parseNormalized(member);
            }
            catch (LdapException e) {
                LOG.warn("Malformed member Dn in groupOf[Unique]Names entry.  Member not added to GroupCache.", e);
                continue;
            }
            memberSet.add(memberDn.getNormName());
        }
    }

    private void removeMembers(Set<String> memberSet, Attribute members) throws LdapException {
        for (Value value : members) {
            String member = value.getString();
            Dn memberDn = null;
            try {
                memberDn = this.parseNormalized(member);
            }
            catch (LdapException e) {
                LOG.warn("Malformed member Dn in groupOf[Unique]Names entry.  Member not removed from GroupCache.", e);
                continue;
            }
            memberSet.remove(memberDn.getNormName());
        }
    }

    public void groupAdded(String name, Entry entry) throws LdapException {
        Attribute members = this.getMemberAttribute(entry);
        if (members == null) {
            return;
        }
        HashSet<String> memberSet = new HashSet<String>(members.size());
        this.addMembers(memberSet, members);
        this.groups.put(name, memberSet);
        if (IS_DEBUG) {
            LOG.debug("group cache contents after adding '{}' :\n {}", (Object)name, (Object)this.groups);
        }
    }

    public void groupDeleted(Dn name, Entry entry) throws LdapException {
        Attribute members = this.getMemberAttribute(entry);
        if (members == null) {
            return;
        }
        this.groups.remove(name.getNormName());
        if (IS_DEBUG) {
            LOG.debug("group cache contents after deleting '{}' :\n {}", (Object)name.getName(), (Object)this.groups);
        }
    }

    private void modify(Set<String> memberSet, ModificationOperation modOp, Attribute members) throws LdapException {
        switch (modOp) {
            case ADD_ATTRIBUTE: {
                this.addMembers(memberSet, members);
                break;
            }
            case REPLACE_ATTRIBUTE: {
                if (members.size() <= 0) break;
                memberSet.clear();
                this.addMembers(memberSet, members);
                break;
            }
            case REMOVE_ATTRIBUTE: {
                this.removeMembers(memberSet, members);
                break;
            }
            default: {
                throw new InternalError(I18n.err(I18n.ERR_235, new Object[]{modOp}));
            }
        }
    }

    public void groupModified(Dn name, List<Modification> mods, Entry entry, SchemaManager schemaManager) throws LdapException {
        Attribute members = null;
        AttributeType memberAttr = null;
        Attribute oc = entry.get(this.directoryService.getAtProvider().getObjectClass());
        if (oc.contains("groupOfNames")) {
            memberAttr = this.directoryService.getAtProvider().getMember();
            members = entry.get(memberAttr);
        }
        if (oc.contains("groupOfUniqueNames")) {
            memberAttr = this.directoryService.getAtProvider().getUniqueMember();
            members = entry.get(memberAttr);
        }
        if (members == null) {
            return;
        }
        for (Modification modification : mods) {
            if (memberAttr.getOid() != modification.getAttribute().getId()) continue;
            Set<String> memberSet = this.groups.get(name.getNormName());
            if (memberSet == null) break;
            this.modify(memberSet, modification.getOperation(), modification.getAttribute());
            break;
        }
        if (IS_DEBUG) {
            LOG.debug("group cache contents after modifying '{}' :\n {}", (Object)name.getName(), (Object)this.groups);
        }
    }

    public void groupModified(Dn name, ModificationOperation modOp, Entry mods) throws LdapException {
        Attribute members = this.getMemberAttribute(mods);
        if (members == null) {
            return;
        }
        Set<String> memberSet = this.groups.get(name.getNormName());
        if (memberSet != null) {
            this.modify(memberSet, modOp, members);
        }
        if (IS_DEBUG) {
            LOG.debug("group cache contents after modifying '{}' :\n {}", (Object)name.getName(), (Object)this.groups);
        }
    }

    public final boolean isPrincipalAnAdministrator(String principalDn) {
        if (principalDn.equals(this.adminSystemDn.getNormName())) {
            return true;
        }
        Set<String> members = this.groups.get(this.administratorsGroupDn.getNormName());
        if (members == null) {
            LOG.warn("What do you mean there is no administrators group? This is bad news.");
            return false;
        }
        return members.contains(principalDn);
    }

    public Set<String> getGroups(String memberDn) throws LdapException {
        HashSet<String> memberGroups = null;
        for (Map.Entry<String, Set<String>> entry : this.groups.entrySet()) {
            String group = entry.getKey();
            Set<String> members = entry.getValue();
            if (members == null || !members.contains(memberDn)) continue;
            if (memberGroups == null) {
                memberGroups = new HashSet<String>();
            }
            memberGroups.add(group);
        }
        if (memberGroups == null) {
            return EMPTY_GROUPS;
        }
        return memberGroups;
    }

    public boolean groupRenamed(Dn oldName, Dn newName) {
        Set<String> members = this.groups.get(oldName.getNormName());
        if (members != null) {
            this.groups.remove(oldName.getNormName());
            this.groups.put(newName.getNormName(), members);
            if (IS_DEBUG) {
                LOG.debug("group cache contents after renaming '{}' :\n{}", (Object)oldName.getName(), (Object)this.groups);
            }
            return true;
        }
        return false;
    }
}

