/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.data.impl.builder;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Inject;
import jakarta.persistence.PersistenceException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.deltaspike.core.api.provider.BeanProvider;
import org.apache.deltaspike.core.util.ClassUtils;
import org.apache.deltaspike.data.api.QueryInvocationException;
import org.apache.deltaspike.data.impl.builder.QueryBuilder;
import org.apache.deltaspike.data.impl.handler.CdiQueryInvocationContext;
import org.apache.deltaspike.data.impl.util.bean.BeanDestroyable;
import org.apache.deltaspike.data.spi.DelegateQueryHandler;
import org.apache.deltaspike.data.spi.QueryInvocationContext;

@ApplicationScoped
public class DelegateQueryBuilder
extends QueryBuilder {
    @Inject
    private BeanManager beanManager;
    private final Map<Method, Bean<DelegateQueryHandler>> lookupCache = new HashMap<Method, Bean<DelegateQueryHandler>>();

    @Override
    public Object execute(CdiQueryInvocationContext context) {
        try {
            DelegateQueryHandler delegate = this.lookup(context);
            if (delegate != null) {
                Object result = this.invoke(delegate, context);
                if (result instanceof Collection && context.getRepositoryMethodMetadata().isReturnsStream()) {
                    return ((Collection)result).stream();
                }
                if (context.getRepositoryMethodMetadata().isReturnsOptional() && !(result instanceof Optional)) {
                    return Optional.ofNullable(result);
                }
                return result;
            }
        }
        catch (PersistenceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QueryInvocationException((Throwable)e, (QueryInvocationContext)context);
        }
        throw new QueryInvocationException("No DelegateQueryHandler found", (QueryInvocationContext)context);
    }

    private DelegateQueryHandler lookup(CdiQueryInvocationContext context) {
        Bean selectedBean = this.lookupCache.get(context.getMethod());
        if (selectedBean == null) {
            Set beans = BeanProvider.getBeanDefinitions(DelegateQueryHandler.class, (boolean)true, (boolean)true);
            for (Bean bean : beans) {
                if (!ClassUtils.containsPossiblyGenericMethod((Class)bean.getBeanClass(), (Method)context.getMethod())) continue;
                selectedBean = bean;
            }
            if (selectedBean != null) {
                this.lookupCache.put(context.getMethod(), selectedBean);
            }
        }
        if (selectedBean != null) {
            CreationalContext cc = this.beanManager.createCreationalContext(selectedBean);
            DelegateQueryHandler instance = (DelegateQueryHandler)this.beanManager.getReference(selectedBean, DelegateQueryHandler.class, cc);
            if (selectedBean.getScope().equals(Dependent.class)) {
                context.addDestroyable(new BeanDestroyable<DelegateQueryHandler>(selectedBean, instance, cc));
            }
            return instance;
        }
        return null;
    }

    private Object invoke(DelegateQueryHandler delegate, CdiQueryInvocationContext context) {
        try {
            Method extract = ClassUtils.extractPossiblyGenericMethod(delegate.getClass(), (Method)context.getMethod());
            return extract.invoke((Object)delegate, context.getMethodParameters());
        }
        catch (InvocationTargetException e) {
            if (e.getCause() != null && e.getCause() instanceof PersistenceException) {
                throw (PersistenceException)e.getCause();
            }
            throw new QueryInvocationException((Throwable)e, (QueryInvocationContext)context);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

