/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import java.util.Objects;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;

public class ReattachSessionMessage
extends PacketImpl {
    private String name;
    private int lastConfirmedCommandID;

    public ReattachSessionMessage(String name, int lastConfirmedCommandID) {
        super((byte)32);
        this.name = name;
        this.lastConfirmedCommandID = lastConfirmedCommandID;
    }

    public ReattachSessionMessage() {
        super((byte)32);
    }

    public String getName() {
        return this.name;
    }

    public int getLastConfirmedCommandID() {
        return this.lastConfirmedCommandID;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        buffer.writeString(this.name);
        buffer.writeInt(this.lastConfirmedCommandID);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        this.name = buffer.readString();
        this.lastConfirmedCommandID = buffer.readInt();
    }

    @Override
    public final boolean isRequiresConfirmations() {
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.lastConfirmedCommandID, this.name);
    }

    @Override
    protected String getPacketString() {
        StringBuilder sb = new StringBuilder(super.getPacketString());
        sb.append(", lastConfirmedCommandID=" + this.lastConfirmedCommandID);
        sb.append(", name=" + this.name);
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ReattachSessionMessage)) {
            return false;
        }
        ReattachSessionMessage other = (ReattachSessionMessage)obj;
        return this.lastConfirmedCommandID == other.lastConfirmedCommandID && Objects.equals(this.name, other.name);
    }
}

