/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.crypto;

import javax.annotation.Nonnull;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.crypto.SigningUtil;
import org.opensaml.xmlsec.algorithm.AlgorithmSupport;

public final class XMLSigningUtil {
    private XMLSigningUtil() {
    }

    @Nonnull
    public static byte[] signWithURI(@Nonnull Credential signingCredential, @Nonnull String algorithmURI, @Nonnull byte[] input) throws SecurityException {
        String jcaAlgorithmID = AlgorithmSupport.getAlgorithmID(algorithmURI);
        if (jcaAlgorithmID == null) {
            throw new SecurityException("Could not derive JCA algorithm identifier from algorithm URI");
        }
        boolean isHMAC = AlgorithmSupport.isHMAC(algorithmURI);
        return SigningUtil.sign((Credential)signingCredential, (String)jcaAlgorithmID, (boolean)isHMAC, (byte[])input);
    }

    public static boolean verifyWithURI(@Nonnull Credential verificationCredential, @Nonnull String algorithmURI, @Nonnull byte[] signature, @Nonnull byte[] input) throws SecurityException {
        String jcaAlgorithmID = AlgorithmSupport.getAlgorithmID(algorithmURI);
        if (jcaAlgorithmID == null) {
            throw new SecurityException("Could not derive JCA algorithm identifier from algorithm URI");
        }
        boolean isHMAC = AlgorithmSupport.isHMAC(algorithmURI);
        return SigningUtil.verify((Credential)verificationCredential, (String)jcaAlgorithmID, (boolean)isHMAC, (byte[])signature, (byte[])input);
    }
}

