/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis.util.jdom;

import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.staxutils.StaxUtils;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMFactory;
import org.jdom.Namespace;
import org.jdom.Parent;
import org.jdom.UncheckedJDOMFactory;

public class StaxBuilder {
    private static final Map<String, Integer> ATTR_TYPES = new HashMap<String, Integer>(32);
    protected boolean cfgIgnoreWS;
    private JDOMFactory factory;
    private Map<String, String> additionalNamespaces;
    private boolean isReadingMidStream;

    public StaxBuilder() {
    }

    public StaxBuilder(Map<String, String> namespaces) {
        this.additionalNamespaces = namespaces;
    }

    public Map<String, String> getAdditionalNamespaces() {
        return this.additionalNamespaces;
    }

    public void setAdditionalNamespaces(Map<String, String> additionalNamespaces) {
        this.additionalNamespaces = additionalNamespaces;
    }

    public void setFactory(JDOMFactory f) {
        this.factory = f;
    }

    public void setIgnoreWhitespace(boolean state) {
        this.cfgIgnoreWS = state;
    }

    public JDOMFactory getFactory() {
        return this.factory;
    }

    public Document build(XMLStreamReader r) throws XMLStreamException {
        this.isReadingMidStream = true;
        return this.buildInternal(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document build(InputStream is) throws XMLStreamException {
        this.isReadingMidStream = false;
        XMLStreamReader reader = null;
        try {
            reader = StaxUtils.createXMLStreamReader((InputStream)is);
            Document document = this.buildInternal(reader);
            return document;
        }
        finally {
            StaxUtils.close((XMLStreamReader)reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document build(Reader reader) throws XMLStreamException {
        this.isReadingMidStream = false;
        XMLStreamReader streamReader = null;
        try {
            streamReader = StaxUtils.createXMLStreamReader((Reader)reader);
            Document document = this.buildInternal(streamReader);
            return document;
        }
        finally {
            StaxUtils.close((XMLStreamReader)streamReader);
        }
    }

    private Document buildInternal(XMLStreamReader r) throws XMLStreamException {
        JDOMFactory f = this.factory;
        if (f == null) {
            f = new UncheckedJDOMFactory();
        }
        Document doc = f.document(null);
        this.buildTree(f, r, doc);
        return doc;
    }

    private void buildTree(JDOMFactory f, XMLStreamReader r, Document doc) throws XMLStreamException {
        Element current = null;
        int event = r.getEventType();
        if (event == -1) {
            event = r.next();
        }
        while (true) {
            boolean noadd = false;
            CDATA child = null;
            switch (event) {
                case 12: {
                    child = f.cdata(r.getText());
                    break;
                }
                case 6: {
                    if (this.cfgIgnoreWS) {
                        noadd = true;
                        break;
                    }
                }
                case 4: {
                    if (current == null) {
                        noadd = true;
                        break;
                    }
                    child = f.text(r.getText());
                    break;
                }
                case 5: {
                    child = f.comment(r.getText());
                    break;
                }
                case 8: {
                    return;
                }
                case 2: {
                    if (current != null) {
                        current = current.getParentElement();
                    }
                    noadd = true;
                    if (!this.isReadingMidStream || current != null) break;
                    return;
                }
                case 14: 
                case 15: {
                    noadd = true;
                    break;
                }
                case 9: {
                    child = f.entityRef(r.getLocalName());
                    break;
                }
                case 3: {
                    child = f.processingInstruction(r.getPITarget(), r.getPIData());
                    break;
                }
                case 1: {
                    Namespace ns;
                    String prefix;
                    int i;
                    Element newElem = null;
                    String nsURI = r.getNamespaceURI();
                    String elemPrefix = r.getPrefix();
                    String ln = r.getLocalName();
                    newElem = nsURI == null || nsURI.length() == 0 ? (elemPrefix == null || elemPrefix.length() == 0 ? f.element(ln) : f.element(ln, elemPrefix, "")) : f.element(ln, elemPrefix, nsURI);
                    if (current == null) {
                        doc.setRootElement(newElem);
                        if (this.additionalNamespaces != null) {
                            for (String prefix2 : this.additionalNamespaces.keySet()) {
                                String uri = this.additionalNamespaces.get(prefix2);
                                newElem.addNamespaceDeclaration(Namespace.getNamespace((String)prefix2, (String)uri));
                            }
                        }
                    } else {
                        f.addContent((Parent)current, (Content)newElem);
                    }
                    int len = r.getNamespaceCount();
                    for (i = 0; i < len; ++i) {
                        prefix = r.getNamespacePrefix(i);
                        ns = Namespace.getNamespace((String)prefix, (String)r.getNamespaceURI(i));
                        if (prefix != null && prefix.equals(elemPrefix)) continue;
                        f.addNamespaceDeclaration(newElem, ns);
                    }
                    len = r.getAttributeCount();
                    for (i = 0; i < len; ++i) {
                        prefix = r.getAttributePrefix(i);
                        ns = prefix == null || prefix.length() == 0 ? Namespace.NO_NAMESPACE : newElem.getNamespace(prefix);
                        Attribute attr = f.attribute(r.getAttributeLocalName(i), r.getAttributeValue(i), StaxBuilder.resolveAttrType(r.getAttributeType(i)), ns);
                        f.setAttribute(newElem, attr);
                    }
                    current = newElem;
                    noadd = true;
                    break;
                }
            }
            if (!noadd && child != null) {
                if (current == null) {
                    f.addContent((Parent)doc, (Content)child);
                } else {
                    f.addContent((Parent)current, (Content)child);
                }
            }
            if (!r.hasNext()) break;
            event = r.next();
        }
    }

    private static int resolveAttrType(String typeStr) {
        Integer i;
        if (typeStr != null && typeStr.length() > 0 && (i = ATTR_TYPES.get(typeStr)) != null) {
            return i;
        }
        return 0;
    }

    static {
        ATTR_TYPES.put("CDATA", 1);
        ATTR_TYPES.put("cdata", 1);
        ATTR_TYPES.put("ID", 2);
        ATTR_TYPES.put("id", 2);
        ATTR_TYPES.put("IDREF", 3);
        ATTR_TYPES.put("idref", 3);
        ATTR_TYPES.put("IDREFS", 4);
        ATTR_TYPES.put("idrefs", 4);
        ATTR_TYPES.put("ENTITY", 5);
        ATTR_TYPES.put("entity", 5);
        ATTR_TYPES.put("ENTITIES", 6);
        ATTR_TYPES.put("entities", 6);
        ATTR_TYPES.put("NMTOKEN", 7);
        ATTR_TYPES.put("nmtoken", 7);
        ATTR_TYPES.put("NMTOKENS", 8);
        ATTR_TYPES.put("nmtokens", 8);
        ATTR_TYPES.put("NOTATION", 9);
        ATTR_TYPES.put("notation", 9);
        ATTR_TYPES.put("ENUMERATED", 10);
        ATTR_TYPES.put("enumerated", 10);
    }
}

