/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.common;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;

public class VelocityWriter
extends BufferedWriter {
    private final String newLine = System.getProperty("line.separator");

    public VelocityWriter(Writer out) {
        super(out);
    }

    public VelocityWriter(Writer out, int size) {
        super(out, size);
    }

    @Override
    public void write(char[] chars) throws IOException {
        String str = new String(chars);
        if (str.indexOf("\r\n") >= 0 && this.newLine != null) {
            super.write(str.replaceAll("\r\n", this.newLine));
            return;
        }
        if (str.indexOf(10) >= 0 && this.newLine != null) {
            super.write(str.replaceAll("\n", this.newLine));
            return;
        }
        super.write(str);
    }

    @Override
    public void write(String str) throws IOException {
        if (str.indexOf("\r\n") >= 0 && this.newLine != null) {
            super.write(str.replaceAll("\r\n", this.newLine));
            return;
        }
        if (str.indexOf(10) >= 0 && this.newLine != null) {
            super.write(str.replaceAll("\n", this.newLine));
            return;
        }
        super.write(str);
    }
}

