/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat;

import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Collection;
import java.util.Objects;
import java.util.SortedSet;
import java.util.function.Consumer;
import org.apache.commons.io.function.IOSupplier;
import org.apache.rat.ConfigurationException;
import org.apache.rat.Defaults;
import org.apache.rat.commandline.StyleSheets;
import org.apache.rat.config.AddLicenseHeaders;
import org.apache.rat.config.exclusion.ExclusionProcessor;
import org.apache.rat.config.exclusion.StandardCollection;
import org.apache.rat.config.results.ClaimValidator;
import org.apache.rat.document.DocumentName;
import org.apache.rat.document.DocumentNameMatcher;
import org.apache.rat.document.DocumentNameMatcherSupplier;
import org.apache.rat.license.ILicense;
import org.apache.rat.license.ILicenseFamily;
import org.apache.rat.license.LicenseSetFactory;
import org.apache.rat.report.IReportable;
import org.apache.rat.utils.DefaultLog;
import org.apache.rat.utils.Log;
import org.apache.rat.utils.ReportingSet;

public class ReportConfiguration {
    private final LicenseSetFactory licenseSetFactory = new LicenseSetFactory();
    private boolean addingLicenses;
    private boolean addingLicensesForced;
    private String copyrightMessage;
    private IOSupplier<OutputStream> out;
    private IOSupplier<InputStream> styleSheet;
    private IReportable reportable;
    private final ExclusionProcessor exclusionProcessor;
    private LicenseSetFactory.LicenseFilter listFamilies = Defaults.LIST_FAMILIES;
    private LicenseSetFactory.LicenseFilter listLicenses = Defaults.LIST_LICENSES;
    private boolean dryRun = false;
    private Processing archiveProcessing;
    private Processing standardProcessing;
    private final ClaimValidator claimValidator;

    public ReportConfiguration() {
        this.exclusionProcessor = new ExclusionProcessor();
        this.claimValidator = new ClaimValidator();
    }

    public Processing getArchiveProcessing() {
        return this.archiveProcessing == null ? Defaults.ARCHIVE_PROCESSING : this.archiveProcessing;
    }

    public void setArchiveProcessing(Processing archiveProcessing) {
        this.archiveProcessing = archiveProcessing;
    }

    public Processing getStandardProcessing() {
        return this.standardProcessing == null ? Defaults.STANDARD_PROCESSING : this.standardProcessing;
    }

    public void setStandardProcessing(Processing standardProcessing) {
        this.standardProcessing = standardProcessing;
    }

    public void logFamilyCollisions(Log.Level level) {
        this.licenseSetFactory.logFamilyCollisions(level);
    }

    public void familyDuplicateOption(ReportingSet.Options state) {
        this.licenseSetFactory.familyDuplicateOption(state);
    }

    public void logLicenseCollisions(Log.Level level) {
        this.licenseSetFactory.logLicenseCollisions(level);
    }

    public void licenseDuplicateOption(ReportingSet.Options state) {
        this.licenseSetFactory.licenseDuplicateOption(state);
    }

    public void listFamilies(LicenseSetFactory.LicenseFilter filter) {
        this.listFamilies = filter;
    }

    public LicenseSetFactory.LicenseFilter listFamilies() {
        return this.listFamilies;
    }

    public void listLicenses(LicenseSetFactory.LicenseFilter filter) {
        this.listLicenses = filter;
    }

    public LicenseSetFactory.LicenseFilter listLicenses() {
        return this.listLicenses;
    }

    public void setDryRun(boolean state) {
        this.dryRun = state;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public void addExcludedCollection(StandardCollection collection) {
        this.exclusionProcessor.addExcludedCollection(collection);
    }

    public void addExcludedFileProcessor(StandardCollection collection) {
        this.exclusionProcessor.addFileProcessor(collection);
    }

    public void addExcludedFilter(FileFilter fileFilter) {
        this.exclusionProcessor.addExcludedFilter(DocumentNameMatcherSupplier.from(fileFilter));
    }

    public void addExcludedMatcher(String name, DocumentNameMatcher matcher) {
        this.exclusionProcessor.addExcludedFilter(DocumentNameMatcherSupplier.from(name, matcher));
    }

    public void addExcludedPatterns(Iterable<String> patterns) {
        this.exclusionProcessor.addExcludedPatterns(patterns);
    }

    public void addIncludedCollection(StandardCollection collection) {
        this.exclusionProcessor.addIncludedCollection(collection);
    }

    public void addIncludedFilter(FileFilter fileFilter) {
        this.exclusionProcessor.addIncludedFilter(DocumentNameMatcherSupplier.from(fileFilter));
    }

    public void addIncludedPatterns(Iterable<String> patterns) {
        this.exclusionProcessor.addIncludedPatterns(patterns);
    }

    public DocumentNameMatcher getNameMatcher(DocumentName baseDir) {
        return this.exclusionProcessor.getNameMatcher(baseDir);
    }

    public IReportable getReportable() {
        return this.reportable;
    }

    public void setReportable(IReportable reportable) {
        this.reportable = reportable;
    }

    public IOSupplier<InputStream> getStyleSheet() {
        return this.styleSheet;
    }

    public void setStyleSheet(IOSupplier<InputStream> styleSheet) {
        this.styleSheet = styleSheet;
    }

    public void setFrom(Defaults defaults) {
        this.licenseSetFactory.add(defaults.getLicenseSetFactory());
        if (this.getStyleSheet() == null) {
            this.setStyleSheet(StyleSheets.PLAIN.getStyleSheet());
        }
        defaults.getStandardExclusion().forEach(this::addExcludedCollection);
    }

    public void setStyleSheet(File styleSheet) {
        Objects.requireNonNull(styleSheet, "styleSheet file should not be null");
        this.setStyleSheet(styleSheet.toURI());
    }

    public void setStyleSheet(URI styleSheet) {
        Objects.requireNonNull(styleSheet, "styleSheet file should not be null");
        try {
            this.setStyleSheet(styleSheet.toURL());
        }
        catch (MalformedURLException e) {
            throw new ConfigurationException("Unable to process stylesheet", e);
        }
    }

    public void setStyleSheet(URL styleSheet) {
        Objects.requireNonNull(styleSheet, "styleSheet file should not be null");
        this.setStyleSheet(styleSheet::openStream);
    }

    public void setOut(IOSupplier<OutputStream> out) {
        this.out = out;
    }

    public void setOut(File file) {
        File parent;
        Objects.requireNonNull(file, "output file should not be null");
        if (file.exists()) {
            try {
                Files.delete(file.toPath());
            }
            catch (IOException e) {
                DefaultLog.getInstance().warn("Unable to delete file: " + file);
            }
        }
        if (!(parent = file.getParentFile()).mkdirs() && !parent.isDirectory()) {
            DefaultLog.getInstance().warn("Unable to create directory: " + file.getParentFile());
        }
        this.setOut(() -> new FileOutputStream(file, true));
    }

    public IOSupplier<OutputStream> getOutput() {
        return this.out == null ? () -> new NoCloseOutputStream(System.out) : this.out;
    }

    public IOSupplier<PrintWriter> getWriter() {
        return () -> new PrintWriter(new OutputStreamWriter(this.getOutput().get(), StandardCharsets.UTF_8));
    }

    public void addLicense(ILicense license) {
        this.licenseSetFactory.addLicense(license);
    }

    public ILicense addLicense(ILicense.Builder builder) {
        return this.licenseSetFactory.addLicense(builder);
    }

    public void addLicenses(Collection<ILicense> licenses) {
        this.licenseSetFactory.addLicenses(licenses);
    }

    public void addFamily(ILicenseFamily family) {
        this.licenseSetFactory.addFamily(family);
    }

    public void addFamily(ILicenseFamily.Builder builder) {
        this.licenseSetFactory.addFamily(builder);
    }

    public void addFamilies(Collection<ILicenseFamily> families) {
        families.forEach(this::addApprovedLicenseCategory);
    }

    public void addApprovedLicenseCategory(ILicenseFamily approvedILicenseFamily) {
        this.addApprovedLicenseCategory(approvedILicenseFamily.getFamilyCategory());
    }

    public void addApprovedLicenseCategory(String familyCategory) {
        this.licenseSetFactory.addLicenseCategory(familyCategory);
    }

    public void addApprovedLicenseCategories(Collection<String> approvedLicenseCategories) {
        approvedLicenseCategories.forEach(this::addApprovedLicenseCategory);
    }

    public void removeApprovedLicenseCategory(String familyCategory) {
        this.licenseSetFactory.removeLicenseCategory(ILicenseFamily.makeCategory(familyCategory));
    }

    public void removeApprovedLicenseCategories(Collection<String> familyCategory) {
        familyCategory.forEach(this::removeApprovedLicenseCategory);
    }

    public LicenseSetFactory getLicenseSetFactory() {
        return this.licenseSetFactory;
    }

    public SortedSet<String> getLicenseCategories(LicenseSetFactory.LicenseFilter filter) {
        return this.licenseSetFactory.getLicenseCategories(filter);
    }

    public SortedSet<ILicense> getLicenses(LicenseSetFactory.LicenseFilter filter) {
        return this.licenseSetFactory.getLicenses(filter);
    }

    public SortedSet<String> getLicenseIds(LicenseSetFactory.LicenseFilter filter) {
        return this.licenseSetFactory.getLicenseIds(filter);
    }

    public void addApprovedLicenseId(ILicense approvedLicense) {
        this.addApprovedLicenseId(approvedLicense.getId());
    }

    public void addApprovedLicenseId(String licenseId) {
        this.licenseSetFactory.addLicenseId(licenseId);
    }

    public void addApprovedLicenseIds(Collection<String> approvedLicenseIds) {
        approvedLicenseIds.forEach(this::addApprovedLicenseId);
    }

    public void removeApprovedLicenseId(String licenseId) {
        this.licenseSetFactory.removeLicenseId(licenseId);
    }

    public void removeApprovedLicenseIds(Collection<String> licenseIds) {
        licenseIds.forEach(this::removeApprovedLicenseId);
    }

    public String getCopyrightMessage() {
        return this.copyrightMessage;
    }

    public void setCopyrightMessage(String copyrightMessage) {
        this.copyrightMessage = copyrightMessage;
    }

    public boolean isAddingLicensesForced() {
        return this.addingLicensesForced;
    }

    public boolean isAddingLicenses() {
        return this.addingLicenses;
    }

    public void setAddLicenseHeaders(AddLicenseHeaders addLicenseHeaders) {
        this.addingLicenses = false;
        this.addingLicensesForced = false;
        switch (addLicenseHeaders) {
            case FALSE: {
                break;
            }
            case FORCED: {
                this.addingLicensesForced = true;
                this.addingLicenses = true;
                break;
            }
            case TRUE: {
                this.addingLicenses = true;
            }
        }
    }

    public SortedSet<ILicenseFamily> getLicenseFamilies(LicenseSetFactory.LicenseFilter filter) {
        return this.licenseSetFactory.getLicenseFamilies(filter);
    }

    public ClaimValidator getClaimValidator() {
        return this.claimValidator;
    }

    public void validate(Consumer<String> logger) {
        if (this.reportable == null) {
            throw new ConfigurationException("Reportable may not be null");
        }
        if (this.licenseSetFactory.getLicenses(LicenseSetFactory.LicenseFilter.ALL).isEmpty()) {
            throw new ConfigurationException("You must specify at least one license");
        }
    }

    public static enum Processing {
        NOTIFICATION("List file as present"),
        PRESENCE("List any licenses found"),
        ABSENCE("List licenses found and any unknown licences");

        private final String description;

        private Processing(String description) {
            this.description = description;
        }

        public String desc() {
            return this.description;
        }
    }

    public static class NoCloseOutputStream
    extends OutputStream {
        private final OutputStream delegate;

        public NoCloseOutputStream(OutputStream delegate) {
            this.delegate = delegate;
        }

        @Override
        public void write(int arg0) throws IOException {
            this.delegate.write(arg0);
        }

        @Override
        public void close() throws IOException {
            this.delegate.flush();
        }

        public boolean equals(Object obj) {
            return this.delegate.equals(obj);
        }

        @Override
        public void flush() throws IOException {
            this.delegate.flush();
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public String toString() {
            return this.delegate.toString();
        }

        @Override
        public void write(byte[] arg0, int arg1, int arg2) throws IOException {
            this.delegate.write(arg0, arg1, arg2);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.delegate.write(b);
        }
    }
}

