/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.analysis;

import java.util.Collection;
import java.util.SortedSet;
import java.util.function.Predicate;
import org.apache.rat.ConfigurationException;
import org.apache.rat.Defaults;
import org.apache.rat.ReportConfiguration;
import org.apache.rat.analysis.DocumentHeaderAnalyser;
import org.apache.rat.analysis.IHeaderMatcher;
import org.apache.rat.analysis.TikaProcessor;
import org.apache.rat.analysis.UnknownLicense;
import org.apache.rat.api.Document;
import org.apache.rat.api.RatException;
import org.apache.rat.document.DocumentAnalyser;
import org.apache.rat.document.RatDocumentAnalysisException;
import org.apache.rat.license.ILicense;
import org.apache.rat.license.LicenseSetFactory;
import org.apache.rat.utils.DefaultLog;
import org.apache.rat.utils.Log;
import org.apache.rat.walker.ArchiveWalker;

public final class AnalyserFactory {
    private AnalyserFactory() {
    }

    public static DocumentAnalyser createPolicy(Predicate<ILicense> approvalPredicate) {
        return document -> {
            if (document != null) {
                document.getMetaData().setApprovalPredicate(approvalPredicate);
            }
        };
    }

    public static DocumentAnalyser createMultiplexer(DocumentAnalyser ... analysers) {
        return document -> {
            for (DocumentAnalyser analyser : analysers) {
                analyser.analyse(document);
            }
        };
    }

    public static DocumentAnalyser createConfiguredAnalyser(ReportConfiguration configuration) {
        LicenseSetFactory licenseSetFactory = configuration.getLicenseSetFactory();
        SortedSet<ILicense> licenses = licenseSetFactory.getLicenses(LicenseSetFactory.LicenseFilter.ALL);
        if (licenses.isEmpty()) {
            throw new ConfigurationException("At least one license must be defined");
        }
        if (DefaultLog.getInstance().isEnabled(Log.Level.DEBUG)) {
            DefaultLog.getInstance().debug("Currently active licenses are:");
            licenses.forEach(DefaultLog.getInstance()::debug);
        }
        return AnalyserFactory.createMultiplexer(AnalyserFactory.createPolicy(licenseSetFactory.getApprovedLicensePredicate()), new DefaultAnalyser(configuration, licenses));
    }

    private static final class DefaultAnalyser
    implements DocumentAnalyser {
        private final Collection<ILicense> licenses;
        private final ReportConfiguration configuration;
        private final IHeaderMatcher generatedMatcher;

        DefaultAnalyser(ReportConfiguration config, Collection<ILicense> licenses) {
            this.licenses = licenses;
            this.configuration = config;
            this.generatedMatcher = this.configuration.getGeneratedMatcher();
        }

        private Predicate<ILicense> licenseFilter(ReportConfiguration.Processing proc) {
            return license -> {
                switch (proc) {
                    case PRESENCE: {
                        return !license.getLicenseFamily().equals(UnknownLicense.INSTANCE.getLicenseFamily());
                    }
                    case ABSENCE: {
                        return true;
                    }
                }
                return false;
            };
        }

        @Override
        public void analyse(Document document) throws RatDocumentAnalysisException {
            TikaProcessor.process(document);
            switch (document.getMetaData().getDocumentType()) {
                case STANDARD: {
                    new DocumentHeaderAnalyser(this.generatedMatcher, this.licenses).analyse(document);
                    if (this.configuration.getStandardProcessing() == Defaults.STANDARD_PROCESSING) break;
                    Predicate<ILicense> licensePredicate = this.licenseFilter(this.configuration.getStandardProcessing()).negate();
                    document.getMetaData().removeLicenses(licensePredicate);
                    break;
                }
                case ARCHIVE: {
                    if (this.configuration.getArchiveProcessing() == ReportConfiguration.Processing.NOTIFICATION) break;
                    ArchiveWalker archiveWalker = new ArchiveWalker(document);
                    try {
                        Predicate<ILicense> licensePredicate = this.licenseFilter(this.configuration.getArchiveProcessing());
                        for (Document doc : archiveWalker.getDocuments()) {
                            this.analyse(doc);
                            doc.getMetaData().licenses().filter(licensePredicate).forEach(lic -> document.getMetaData().reportOnLicense((ILicense)lic));
                        }
                        break;
                    }
                    catch (RatException e) {
                        throw new RatDocumentAnalysisException(e);
                    }
                }
            }
        }
    }
}

