/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.utils;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;

public interface Log {
    public static String formatLogEntry(String message, Throwable throwable) {
        StringWriter writer = new StringWriter();
        PrintWriter pWriter = new PrintWriter(writer);
        pWriter.print(message);
        pWriter.print(System.lineSeparator());
        throwable.printStackTrace(pWriter);
        return writer.toString();
    }

    public Level getLevel();

    default public void setLevel(Level level) {
        this.warn(String.format("This logger does not support dynamically setting the log level. Setting to %s ignored.", new Object[]{level}));
    }

    default public boolean isEnabled(Level level) {
        return this.getLevel().ordinal() <= level.ordinal();
    }

    public void log(Level var1, String var2);

    default public void log(Level level, Object message) {
        this.log(level, message == null ? "NULL" : message.toString());
    }

    default public void debug(Object message) {
        this.log(Level.DEBUG, message);
    }

    default public void info(Object message) {
        this.log(Level.INFO, message);
    }

    default public void warn(Object message) {
        this.log(Level.WARN, message);
    }

    default public void error(Object message) {
        this.log(Level.ERROR, message);
    }

    default public void log(Level level, String message, Throwable throwable) {
        this.log(level, Log.formatLogEntry(message, throwable));
    }

    default public void log(Level level, Object message, Throwable throwable) {
        this.log(level, message == null ? "NULL" : message.toString(), throwable);
    }

    default public void debug(Object message, Throwable throwable) {
        this.log(Level.DEBUG, message, throwable);
    }

    default public void info(Object message, Throwable throwable) {
        this.log(Level.INFO, message, throwable);
    }

    default public void warn(Object message, Throwable throwable) {
        this.log(Level.WARN, message, throwable);
    }

    default public void error(Object message, Throwable throwable) {
        this.log(Level.ERROR, message, throwable);
    }

    default public Writer asWriter() {
        return this.asWriter(Level.INFO);
    }

    default public Writer asWriter(final Level level) {
        return new Writer(){
            private StringBuilder sb = new StringBuilder();

            @Override
            public void write(char[] cbuf, int off, int len) {
                String txt = String.copyValueOf(cbuf, off, len);
                int pos = txt.indexOf(System.lineSeparator());
                if (pos == -1) {
                    this.sb.append(txt);
                } else {
                    while (pos > -1) {
                        Log.this.log(level, this.sb.append(txt, 0, pos).toString());
                        this.sb.delete(0, this.sb.length());
                        txt = txt.substring(pos + 1);
                        pos = txt.indexOf(System.lineSeparator());
                    }
                    this.sb.append(txt);
                }
            }

            @Override
            public void flush() {
                if (this.sb.length() > 0) {
                    Log.this.log(level, this.sb.toString());
                }
                this.sb = new StringBuilder();
            }

            @Override
            public void close() {
                this.flush();
            }
        };
    }

    public static enum Level {
        DEBUG,
        INFO,
        WARN,
        ERROR,
        OFF;

    }
}

