/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.analysis.matchers;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.rat.ConfigurationException;
import org.apache.rat.analysis.IHeaders;
import org.apache.rat.analysis.matchers.AbstractHeaderMatcher;
import org.apache.rat.config.parameters.ComponentType;
import org.apache.rat.config.parameters.ConfigComponent;

@ConfigComponent(type=ComponentType.MATCHER, name="copyright", desc="A matcher that matches Copyright text. Uses regular expressions and so should only be used when looking for copyrights with specific patterns that are not caught by a standard text matcher. This matcher will match \"(C)\", \"copyright\", or \"\u00a9\". (text is not case sensitive). It will also match things like Copyright (c) joe 1995 as well as Copyright (C) 1995 joe and Copyright (C) joe 1995.")
public class CopyrightMatcher
extends AbstractHeaderMatcher {
    private static final String COPYRIGHT_SYMBOL_DEFN = "\\([Cc]\\)|\u00a9|\\&[Cc][Oo][Pp][Yy]\\;";
    private static final String COPYRIGHT_PATTERN_DEFN = "(\\b)?\\([Cc]\\)|\u00a9|\\&[Cc][Oo][Pp][Yy]\\;|Copyright\\b";
    private static final Pattern COPYRIGHT_PATTERN = Pattern.compile("(\\b)?\\([Cc]\\)|\u00a9|\\&[Cc][Oo][Pp][Yy]\\;|Copyright\\b");
    private static final String ONE_PART = "\\s+((\\([Cc]\\)|\u00a9|\\&[Cc][Oo][Pp][Yy]\\;)\\s+)?%s";
    private static final String TWO_PART = "\\s+((\\([Cc]\\)|\u00a9|\\&[Cc][Oo][Pp][Yy]\\;)\\s+)?%s,?\\s+%s";
    private static final String DOUBLE_DATE_FMT = "%s\\s*-\\s*%s";
    private static final String ARBITRARY_DATE = "[0-9]{4}";
    private final Pattern dateOwnerPattern;
    private final Pattern ownerDatePattern;
    @ConfigComponent(type=ComponentType.PARAMETER, desc="The initial year of the copyright if any")
    private final String start;
    @ConfigComponent(type=ComponentType.PARAMETER, desc="The last year the copyright. Only valid with 'start'")
    private final String end;
    @ConfigComponent(type=ComponentType.PARAMETER, desc="The owner of the copyright")
    private final String owner;

    public CopyrightMatcher(String start, String end, String owner) {
        this(null, start, end, owner);
    }

    private static void assertNumber(String label, String value) {
        try {
            if (StringUtils.isNotEmpty(value)) {
                Integer.parseInt(value);
            }
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException(String.format("'%s' must be numeric (value provided: '%s')", label, value));
        }
    }

    public CopyrightMatcher(String id, String start, String end, String owner) {
        super(id);
        if (StringUtils.isBlank(start) && !StringUtils.isBlank(end)) {
            throw new ConfigurationException("'end' may not be set if 'start' is not set.");
        }
        CopyrightMatcher.assertNumber("start", start);
        CopyrightMatcher.assertNumber("end", end);
        this.start = start;
        this.end = end;
        this.owner = owner;
        String dateDefn = "";
        if (StringUtils.isNotEmpty(start)) {
            dateDefn = StringUtils.isNotEmpty(end) ? String.format(DOUBLE_DATE_FMT, this.start, this.end) : this.start;
        }
        if (StringUtils.isEmpty(owner)) {
            if (StringUtils.isEmpty(dateDefn)) {
                dateDefn = ARBITRARY_DATE;
            }
            this.dateOwnerPattern = Pattern.compile(String.format(ONE_PART, dateDefn));
            this.ownerDatePattern = null;
        } else if (StringUtils.isEmpty(dateDefn)) {
            dateDefn = String.format(DOUBLE_DATE_FMT, "((([0-9]{4}", ")?[0-9]{4}))?");
            this.dateOwnerPattern = Pattern.compile(String.format(TWO_PART, dateDefn, owner));
            this.ownerDatePattern = Pattern.compile(String.format(ONE_PART, owner));
        } else {
            this.dateOwnerPattern = Pattern.compile(String.format(TWO_PART, dateDefn, owner));
            this.ownerDatePattern = Pattern.compile(String.format(TWO_PART, owner, dateDefn));
        }
    }

    public String getStart() {
        return this.start;
    }

    public String getEnd() {
        return this.end;
    }

    public String getOwner() {
        return this.owner;
    }

    @Override
    public boolean matches(IHeaders headers) {
        Matcher matcher;
        String lowerLine = headers.raw().toLowerCase();
        if ((lowerLine.contains("copyright") || lowerLine.contains("(c)") || lowerLine.contains("\u00a9") || lowerLine.contains("&copy;")) && (matcher = COPYRIGHT_PATTERN.matcher(headers.raw())).find()) {
            String buffer = headers.raw().substring(matcher.end());
            matcher = this.dateOwnerPattern.matcher(buffer);
            if (matcher.find() && matcher.start() == 0) {
                return true;
            }
            if (this.ownerDatePattern != null) {
                matcher = this.ownerDatePattern.matcher(buffer);
                return matcher.find() && matcher.start() == 0;
            }
        }
        return false;
    }
}

