## Formatting Decisions

Formatting decision documents are intended to explain our reasoning for making certain formatting decisions.
Typically these documents contain a set of goals, which are found close to the top of the document,
followed by the several options we considered, measuring them up against our goals.
It might not be clear, but these documents are very much feedback driven.
The goals were created by collating feedback as well as the alternatives considered,
most were also collected from feedback.

After version 1.0.0 these decisions will be much harder to back track on,
but what might be unclear is that before version 1.0.0 these decisions are still very much up for debate.

Debating on formatting decisions is easy:
  - Read the document
  - If you see that we unfairly judged an alternative against our goals, this is a feedback opportunity
  - If you think that the goals that we created are not fair, this is a feedback opportunity

Feedback can be given by:
  - [Creating an github issue](https://github.com/WhatsApp/erlfmt/issues/new)
  - Or commenting on the active pull request

See [Pull Requests](https://github.com/WhatsApp/erlfmt/pulls) for incoming formatting decisions and the list below for merged formatting decisions.

As always, you can preferably provide feedback, by simply trying out the `erlfmt` and providing us with examples of what you would like us to reconsider.  We will point you to the appropriate formatting decision document, if one already exists.

## Merged Formatting Decisions

  - [DefaultWidth](./FormattingDecisionDefaultWidth.md)
  - [Ignore](./FormattingDecisionIgnore.md)
  - [Comments](./FormattingDecisionComments.md)
  - [Pipes](./FormattingDecisionPipes.md)
  - [Commas in Lists](./FormattingDecisionCommas.md)
  - [Number of Spaces](./FormattingDecisionSpaces.md)
  - [Multiline Lists](./FormattingDecisionLists.md)
  - [List Comprehensions](./FormattingDecisionListComprehensions.md)
  - [When with Multiline Guards](./FormattingDecisionWhenMultilineGuards.md)
  - [Formatting Decision: Left Associative Equal and Dolon Operators](./FormattingDecisionAssociative.md)
