/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.inference;

import java.util.EnumSet;
import java.util.Objects;
import org.apache.commons.statistics.descriptive.DoubleStatistics;
import org.apache.commons.statistics.descriptive.Statistic;
import org.apache.commons.statistics.distribution.TDistribution;
import org.apache.commons.statistics.inference.AlternativeHypothesis;
import org.apache.commons.statistics.inference.Arguments;
import org.apache.commons.statistics.inference.BaseSignificanceResult;
import org.apache.commons.statistics.inference.DataDispersion;
import org.apache.commons.statistics.inference.InferenceException;
import org.apache.commons.statistics.inference.StatisticUtils;

public final class TTest {
    private static final TTest DEFAULT = new TTest(AlternativeHypothesis.TWO_SIDED, false, 0.0);
    private final AlternativeHypothesis alternative;
    private final boolean equalVariances;
    private final double mu;

    private TTest(AlternativeHypothesis alternative, boolean equalVariances, double mu) {
        this.alternative = alternative;
        this.equalVariances = equalVariances;
        this.mu = mu;
    }

    public static TTest withDefaults() {
        return DEFAULT;
    }

    public TTest with(AlternativeHypothesis v) {
        return new TTest(Objects.requireNonNull(v), this.equalVariances, this.mu);
    }

    public TTest with(DataDispersion v) {
        return new TTest(this.alternative, Objects.requireNonNull(v) == DataDispersion.HOMOSCEDASTIC, this.mu);
    }

    public TTest withMu(double v) {
        return new TTest(this.alternative, this.equalVariances, Arguments.checkFinite(v));
    }

    public double statistic(double m, double v, long n) {
        Arguments.checkNonNegative(v);
        TTest.checkSampleSize(n);
        return TTest.computeT(m - this.mu, v, n);
    }

    public double statistic(double[] x) {
        long n = TTest.checkSampleSize(x.length);
        DoubleStatistics s = DoubleStatistics.of(EnumSet.of(Statistic.MEAN, Statistic.VARIANCE), (double[])x);
        double m = s.getAsDouble(Statistic.MEAN);
        double v = s.getAsDouble(Statistic.VARIANCE);
        return TTest.computeT(m - this.mu, v, n);
    }

    public double pairedStatistic(double[] x, double[] y) {
        long n = TTest.checkSampleSize(x.length);
        double m = StatisticUtils.meanDifference(x, y);
        double v = StatisticUtils.varianceDifference(x, y, m);
        return TTest.computeT(m - this.mu, v, n);
    }

    public double statistic(double m1, double v1, long n1, double m2, double v2, long n2) {
        Arguments.checkNonNegative(v1);
        Arguments.checkNonNegative(v2);
        TTest.checkSampleSize(n1);
        TTest.checkSampleSize(n2);
        return this.equalVariances ? TTest.computeHomoscedasticT(this.mu, m1, v1, n1, m2, v2, n2) : TTest.computeT(this.mu, m1, v1, n1, m2, v2, n2);
    }

    public double statistic(double[] x, double[] y) {
        long n1 = TTest.checkSampleSize(x.length);
        long n2 = TTest.checkSampleSize(y.length);
        DoubleStatistics.Builder b = DoubleStatistics.builder((Statistic[])new Statistic[]{Statistic.MEAN, Statistic.VARIANCE});
        DoubleStatistics s1 = b.build(x);
        double m1 = s1.getAsDouble(Statistic.MEAN);
        double v1 = s1.getAsDouble(Statistic.VARIANCE);
        DoubleStatistics s2 = b.build(y);
        double m2 = s2.getAsDouble(Statistic.MEAN);
        double v2 = s2.getAsDouble(Statistic.VARIANCE);
        return this.equalVariances ? TTest.computeHomoscedasticT(this.mu, m1, v1, n1, m2, v2, n2) : TTest.computeT(this.mu, m1, v1, n1, m2, v2, n2);
    }

    public Result test(double m, double v, long n) {
        double t = this.statistic(m, v, n);
        double df = (double)n - 1.0;
        double p = this.computeP(t, df);
        return new Result(t, df, p);
    }

    public Result test(double[] sample) {
        double t = this.statistic(sample);
        double df = (double)sample.length - 1.0;
        double p = this.computeP(t, df);
        return new Result(t, df, p);
    }

    public Result pairedTest(double[] x, double[] y) {
        double t = this.pairedStatistic(x, y);
        double df = (double)x.length - 1.0;
        double p = this.computeP(t, df);
        return new Result(t, df, p);
    }

    public Result test(double m1, double v1, long n1, double m2, double v2, long n2) {
        double t = this.statistic(m1, v1, n1, m2, v2, n2);
        double df = this.equalVariances ? -2.0 + (double)n1 + (double)n2 : TTest.computeDf(v1, n1, v2, n2);
        double p = this.computeP(t, df);
        return new Result(t, df, p);
    }

    public Result test(double[] x, double[] y) {
        double df;
        double t;
        long n1 = TTest.checkSampleSize(x.length);
        long n2 = TTest.checkSampleSize(y.length);
        DoubleStatistics.Builder b = DoubleStatistics.builder((Statistic[])new Statistic[]{Statistic.MEAN, Statistic.VARIANCE});
        DoubleStatistics s1 = b.build(x);
        double m1 = s1.getAsDouble(Statistic.MEAN);
        double v1 = s1.getAsDouble(Statistic.VARIANCE);
        DoubleStatistics s2 = b.build(y);
        double m2 = s2.getAsDouble(Statistic.MEAN);
        double v2 = s2.getAsDouble(Statistic.VARIANCE);
        if (this.equalVariances) {
            t = TTest.computeHomoscedasticT(this.mu, m1, v1, n1, m2, v2, n2);
            df = -2.0 + (double)n1 + (double)n2;
        } else {
            t = TTest.computeT(this.mu, m1, v1, n1, m2, v2, n2);
            df = TTest.computeDf(v1, n1, v2, n2);
        }
        double p = this.computeP(t, df);
        return new Result(t, df, p);
    }

    private static double computeT(double m, double v, long n) {
        return m / Math.sqrt(v / (double)n);
    }

    private static double computeT(double mu, double m1, double v1, long n1, double m2, double v2, long n2) {
        return (m1 - m2 - mu) / Math.sqrt(v1 / (double)n1 + v2 / (double)n2);
    }

    private static double computeDf(double v1, long n1, double v2, long n2) {
        double d1 = n1;
        double d2 = n2;
        return (v1 / d1 + v2 / d2) * (v1 / d1 + v2 / d2) / (v1 * v1 / (d1 * d1 * (double)(n1 - 1L)) + v2 * v2 / (d2 * d2 * (double)(n2 - 1L)));
    }

    private static double computeHomoscedasticT(double mu, double m1, double v1, long n1, double m2, double v2, long n2) {
        double pooledVariance = ((double)(n1 - 1L) * v1 + (double)(n2 - 1L) * v2) / (-2.0 + (double)n1 + (double)n2);
        return (m1 - m2 - mu) / Math.sqrt(pooledVariance * (1.0 / (double)n1 + 1.0 / (double)n2));
    }

    private double computeP(double t, double degreesOfFreedom) {
        if (this.alternative == AlternativeHypothesis.LESS_THAN) {
            return TDistribution.of((double)degreesOfFreedom).cumulativeProbability(t);
        }
        if (this.alternative == AlternativeHypothesis.GREATER_THAN) {
            return TDistribution.of((double)degreesOfFreedom).survivalProbability(t);
        }
        return 2.0 * TDistribution.of((double)degreesOfFreedom).survivalProbability(Math.abs(t));
    }

    private static long checkSampleSize(long n) {
        if (n <= 1L) {
            throw new InferenceException("Values size %s < 2", n);
        }
        return n;
    }

    public static final class Result
    extends BaseSignificanceResult {
        private final double degreesOfFreedom;

        Result(double statistic, double degreesOfFreedom, double p) {
            super(statistic, p);
            this.degreesOfFreedom = degreesOfFreedom;
        }

        public double getDegreesOfFreedom() {
            return this.degreesOfFreedom;
        }
    }
}

