/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2;

public class VisitTracker<K> {
    private int validateCount = 0;
    private int activateCount = 0;
    private int passivateCount = 0;
    private boolean destroyed = false;
    private int id = 0;
    private K key = null;

    public VisitTracker() {
        this.reset();
    }

    public VisitTracker(int id) {
        this.id = id;
        this.reset();
    }

    public VisitTracker(int id, K key) {
        this.id = id;
        this.key = key;
        this.reset();
    }

    public boolean validate() {
        if (this.destroyed) {
            this.fail("attempted to validate a destroyed object");
        }
        ++this.validateCount;
        return true;
    }

    public void activate() {
        if (this.destroyed) {
            this.fail("attempted to activate a destroyed object");
        }
        ++this.activateCount;
    }

    public void passivate() {
        if (this.destroyed) {
            this.fail("attempted to passivate a destroyed object");
        }
        ++this.passivateCount;
    }

    public void reset() {
        this.validateCount = 0;
        this.activateCount = 0;
        this.passivateCount = 0;
        this.destroyed = false;
    }

    public void destroy() {
        this.destroyed = true;
    }

    public int getValidateCount() {
        return this.validateCount;
    }

    public int getActivateCount() {
        return this.activateCount;
    }

    public int getPassivateCount() {
        return this.passivateCount;
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public int getId() {
        return this.id;
    }

    public K getKey() {
        return this.key;
    }

    public String toString() {
        return "Key: " + this.key + " id: " + this.id;
    }

    private void fail(String message) {
        throw new IllegalStateException(message);
    }
}

