/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.tree;

import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.configuration2.tree.NodeHandler;
import org.apache.commons.configuration2.tree.TrackedNodeHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestTrackedNodeHandler {
    private static ImmutableNode root;
    private NodeHandler<ImmutableNode> parentHandler;
    private TrackedNodeHandler handler;

    @BeforeAll
    public static void setUpBeforeClass() throws Exception {
        root = new ImmutableNode.Builder().name("ROOT").create();
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.parentHandler = (NodeHandler)Mockito.mock(NodeHandler.class);
        this.handler = new TrackedNodeHandler(root, this.parentHandler);
    }

    @Test
    void testGetParent() {
        ImmutableNode node = new ImmutableNode.Builder().name("node").create();
        ImmutableNode parent = new ImmutableNode.Builder().name("parent").create();
        Mockito.when((Object)((ImmutableNode)this.parentHandler.getParent((Object)node))).thenReturn((Object)parent);
        Assertions.assertSame((Object)parent, (Object)this.handler.getParent(node));
        ((NodeHandler)Mockito.verify(this.parentHandler)).getParent((Object)node);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.parentHandler});
    }

    @Test
    void testGetRootNode() {
        Assertions.assertSame((Object)root, (Object)this.handler.getRootNode());
    }
}

