/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.plist;

import java.io.Reader;
import java.util.Calendar;
import java.util.SimpleTimeZone;
import org.apache.commons.configuration2.plist.PropertyListParser;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestPropertyListParser {
    private final PropertyListParser parser = new PropertyListParser((Reader)null);

    @Test
    void testFilterData() throws Exception {
        byte[] expected = new byte[]{32, 32};
        Assertions.assertArrayEquals(null, (byte[])this.parser.filterData(null));
        Assertions.assertArrayEquals((byte[])expected, (byte[])this.parser.filterData("<2020>"));
        Assertions.assertArrayEquals((byte[])expected, (byte[])this.parser.filterData("2020"));
        Assertions.assertArrayEquals((byte[])expected, (byte[])this.parser.filterData("20 20"));
        Assertions.assertArrayEquals((byte[])new byte[]{9, 32}, (byte[])this.parser.filterData("920"));
    }

    @Test
    void testParseDate() throws Exception {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, 2002);
        calendar.set(2, 2);
        calendar.set(5, 22);
        calendar.set(11, 11);
        calendar.set(12, 30);
        calendar.set(13, 0);
        calendar.set(14, 0);
        calendar.setTimeZone(new SimpleTimeZone(3600000, "Apache/Jakarta"));
        Assertions.assertEquals((Object)calendar.getTime(), (Object)this.parser.parseDate("<*D2002-03-22 11:30:00 +0100>"));
    }

    @Test
    void testRemoveQuotes() {
        Assertions.assertEquals((Object)"abc", (Object)this.parser.removeQuotes("abc"));
        Assertions.assertEquals((Object)"abc", (Object)this.parser.removeQuotes("\"abc\""));
        Assertions.assertEquals((Object)"", (Object)this.parser.removeQuotes("\"\""));
        Assertions.assertEquals((Object)"", (Object)this.parser.removeQuotes(""));
        Assertions.assertNull((Object)this.parser.removeQuotes(null));
    }

    @Test
    void testUnescapeQuotes() {
        Assertions.assertEquals((Object)"aaa\"bbb\"ccc", (Object)this.parser.unescapeQuotes("aaa\"bbb\"ccc"));
        Assertions.assertEquals((Object)"aaa\"bbb\"ccc", (Object)this.parser.unescapeQuotes("aaa\\\"bbb\\\"ccc"));
    }
}

