/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.iterators;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.collections4.AbstractObjectTest;
import org.apache.commons.collections4.IteratorUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractIteratorTest<E>
extends AbstractObjectTest {
    public abstract Iterator<E> makeEmptyIterator();

    @Override
    public abstract Iterator<E> makeObject();

    public boolean supportsEmptyIterator() {
        return true;
    }

    public boolean supportsFullIterator() {
        return true;
    }

    public boolean supportsRemove() {
        return true;
    }

    @Test
    public void testEmptyIterator() {
        if (!this.supportsEmptyIterator()) {
            return;
        }
        Iterator it = this.makeEmptyIterator();
        Assertions.assertFalse((boolean)it.hasNext(), (String)"hasNext() should return false for empty iterators");
        Assertions.assertThrows(NoSuchElementException.class, () -> it.next(), (String)"NoSuchElementException must be thrown when Iterator is exhausted");
        this.verify();
        Assertions.assertNotNull((Object)it.toString());
    }

    @Test
    public void testForEachRemaining() {
        List expected = IteratorUtils.toList((Iterator)this.makeObject());
        Object it = this.makeObject();
        ArrayList actual = new ArrayList();
        it.forEachRemaining(actual::add);
        Assertions.assertEquals((Object)expected, actual);
    }

    @Test
    public void testFullIterator() {
        if (!this.supportsFullIterator()) {
            return;
        }
        Object it = this.makeObject();
        Assertions.assertTrue((boolean)it.hasNext(), (String)"hasNext() should return true for at least one element");
        Assertions.assertDoesNotThrow(((Iterator)it)::next, (String)"Full iterators must have at least one element");
        while (it.hasNext()) {
            it.next();
            this.verify();
        }
        Assertions.assertThrows(NoSuchElementException.class, () -> AbstractIteratorTest.lambda$testFullIterator$1((Iterator)it), (String)"NoSuchElementException must be thrown when Iterator is exhausted");
        Assertions.assertNotNull((Object)it.toString());
    }

    @Test
    public void testRemove() {
        Object it = this.makeObject();
        if (!this.supportsRemove()) {
            Assertions.assertThrows(UnsupportedOperationException.class, ((Iterator)it)::remove);
            return;
        }
        Assertions.assertThrows(IllegalStateException.class, () -> AbstractIteratorTest.lambda$testRemove$2((Iterator)it));
        this.verify();
        it.next();
        it.remove();
        Assertions.assertThrows(IllegalStateException.class, () -> AbstractIteratorTest.lambda$testRemove$3((Iterator)it));
    }

    public void verify() {
    }

    private static /* synthetic */ void lambda$testRemove$3(Iterator it) throws Throwable {
        it.remove();
    }

    private static /* synthetic */ void lambda$testRemove$2(Iterator it) throws Throwable {
        it.remove();
    }

    private static /* synthetic */ void lambda$testFullIterator$1(Iterator it) throws Throwable {
        it.next();
    }
}

