/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.net;

import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.CharEncoding;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.net.URLCodec;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class URLCodecTest {
    static final int[] SWISS_GERMAN_STUFF_UNICODE = new int[]{71, 114, 252, 101, 122, 105, 95, 122, 228, 109, 228};
    static final int[] RUSSIAN_STUFF_UNICODE = new int[]{1042, 1089, 1077, 1084, 95, 1087, 1088, 1080, 1074, 1077, 1090};

    URLCodecTest() {
    }

    private String constructString(int[] unicodeChars) {
        StringBuilder buffer = new StringBuilder();
        if (unicodeChars != null) {
            for (int unicodeChar : unicodeChars) {
                buffer.append((char)unicodeChar);
            }
        }
        return buffer.toString();
    }

    @Test
    void testBasicEncodeDecode() throws Exception {
        URLCodec urlCodec = new URLCodec();
        String plain = "Hello there!";
        String encoded = urlCodec.encode("Hello there!");
        Assertions.assertEquals((Object)"Hello+there%21", (Object)encoded, (String)"Basic URL encoding test");
        Assertions.assertEquals((Object)"Hello there!", (Object)urlCodec.decode(encoded), (String)"Basic URL decoding test");
        this.validateState(urlCodec);
    }

    @Test
    void testDecodeInvalid() throws Exception {
        URLCodec urlCodec = new URLCodec();
        Assertions.assertThrows(DecoderException.class, () -> urlCodec.decode("%"));
        Assertions.assertThrows(DecoderException.class, () -> urlCodec.decode("%A"));
        Assertions.assertThrows(DecoderException.class, () -> urlCodec.decode("%WW"));
        Assertions.assertThrows(DecoderException.class, () -> urlCodec.decode("%0W"));
        this.validateState(urlCodec);
    }

    @Test
    void testDecodeInvalidContent() throws DecoderException {
        String ch_msg = this.constructString(SWISS_GERMAN_STUFF_UNICODE);
        URLCodec urlCodec = new URLCodec();
        byte[] input = ch_msg.getBytes(StandardCharsets.ISO_8859_1);
        byte[] output = urlCodec.decode(input);
        Assertions.assertEquals((int)input.length, (int)output.length);
        for (int i = 0; i < input.length; ++i) {
            Assertions.assertEquals((byte)input[i], (byte)output[i]);
        }
        this.validateState(urlCodec);
    }

    @Test
    void testDecodeObjects() throws Exception {
        URLCodec urlCodec = new URLCodec();
        String plain = "Hello+there%21";
        String decoded = (String)urlCodec.decode((Object)"Hello+there%21");
        Assertions.assertEquals((Object)"Hello there!", (Object)decoded, (String)"Basic URL decoding test");
        byte[] plainBA = "Hello+there%21".getBytes(StandardCharsets.UTF_8);
        byte[] decodedBA = (byte[])urlCodec.decode((Object)plainBA);
        decoded = new String(decodedBA);
        Assertions.assertEquals((Object)"Hello there!", (Object)decoded, (String)"Basic URL decoding test");
        Object result = urlCodec.decode(null);
        Assertions.assertNull((Object)result, (String)"Decoding a null Object should return null");
        Assertions.assertThrows(DecoderException.class, () -> urlCodec.decode((Object)3.0), (String)"Trying to url encode a Double object should cause an exception.");
        this.validateState(urlCodec);
    }

    @Test
    void testDecodeStringWithNull() throws Exception {
        URLCodec urlCodec = new URLCodec();
        String test = null;
        String result = urlCodec.decode(test, "charset");
        Assertions.assertNull((Object)result, (String)"Result should be null");
    }

    @Test
    void testDecodeWithNullArray() throws Exception {
        byte[] plain = null;
        byte[] result = URLCodec.decodeUrl(plain);
        Assertions.assertNull((Object)result, (String)"Result should be null");
    }

    @Test
    void testDefaultEncoding() throws Exception {
        String plain = "Hello there!";
        URLCodec urlCodec = new URLCodec("UnicodeBig");
        urlCodec.encode("Hello there!");
        String encoded1 = urlCodec.encode("Hello there!", "UnicodeBig");
        String encoded2 = urlCodec.encode("Hello there!");
        Assertions.assertEquals((Object)encoded1, (Object)encoded2);
        this.validateState(urlCodec);
    }

    @Test
    void testEncodeDecodeNull() throws Exception {
        URLCodec urlCodec = new URLCodec();
        Assertions.assertNull((Object)urlCodec.encode((String)null), (String)"Null string URL encoding test");
        Assertions.assertNull((Object)urlCodec.decode((String)null), (String)"Null string URL decoding test");
        this.validateState(urlCodec);
    }

    @Test
    void testEncodeNull() throws Exception {
        URLCodec urlCodec = new URLCodec();
        byte[] plain = null;
        byte[] encoded = urlCodec.encode(plain);
        Assertions.assertNull((Object)encoded, (String)"Encoding a null string should return null");
        this.validateState(urlCodec);
    }

    @Test
    void testEncodeObjects() throws Exception {
        URLCodec urlCodec = new URLCodec();
        String plain = "Hello there!";
        String encoded = (String)urlCodec.encode((Object)"Hello there!");
        Assertions.assertEquals((Object)"Hello+there%21", (Object)encoded, (String)"Basic URL encoding test");
        byte[] plainBA = "Hello there!".getBytes(StandardCharsets.UTF_8);
        byte[] encodedBA = (byte[])urlCodec.encode((Object)plainBA);
        encoded = new String(encodedBA);
        Assertions.assertEquals((Object)"Hello+there%21", (Object)encoded, (String)"Basic URL encoding test");
        Object result = urlCodec.encode(null);
        Assertions.assertNull((Object)result, (String)"Encoding a null Object should return null");
        Assertions.assertThrows(EncoderException.class, () -> urlCodec.encode((Object)3.0), (String)"Trying to url encode a Double object should cause an exception.");
        this.validateState(urlCodec);
    }

    @Test
    void testEncodeStringWithNull() throws Exception {
        URLCodec urlCodec = new URLCodec();
        String test = null;
        String result = urlCodec.encode(test, "charset");
        Assertions.assertNull((Object)result, (String)"Result should be null");
    }

    @Test
    void testEncodeUrlWithNullBitSet() throws Exception {
        URLCodec urlCodec = new URLCodec();
        String plain = "Hello there!";
        String encoded = new String(URLCodec.encodeUrl(null, (byte[])"Hello there!".getBytes(StandardCharsets.UTF_8)));
        Assertions.assertEquals((Object)"Hello+there%21", (Object)encoded, (String)"Basic URL encoding test");
        Assertions.assertEquals((Object)"Hello there!", (Object)urlCodec.decode(encoded), (String)"Basic URL decoding test");
        this.validateState(urlCodec);
    }

    @Test
    void testInvalidEncoding() {
        URLCodec urlCodec = new URLCodec("NONSENSE");
        String plain = "Hello there!";
        Assertions.assertThrows(EncoderException.class, () -> urlCodec.encode("Hello there!"), (String)"We set the encoding to a bogus NONSENSE value");
        Assertions.assertThrows(DecoderException.class, () -> urlCodec.decode("Hello there!"), (String)"We set the encoding to a bogus NONSENSE value");
        this.validateState(urlCodec);
    }

    @Test
    void testSafeCharEncodeDecode() throws Exception {
        URLCodec urlCodec = new URLCodec();
        String plain = "abc123_-.*";
        String encoded = urlCodec.encode("abc123_-.*");
        Assertions.assertEquals((Object)"abc123_-.*", (Object)encoded, (String)"Safe chars URL encoding test");
        Assertions.assertEquals((Object)"abc123_-.*", (Object)urlCodec.decode(encoded), (String)"Safe chars URL decoding test");
        this.validateState(urlCodec);
    }

    @Test
    void testUnsafeEncodeDecode() throws Exception {
        URLCodec urlCodec = new URLCodec();
        String plain = "~!@#$%^&()+{}\"\\;:`,/[]";
        String encoded = urlCodec.encode("~!@#$%^&()+{}\"\\;:`,/[]");
        Assertions.assertEquals((Object)"%7E%21%40%23%24%25%5E%26%28%29%2B%7B%7D%22%5C%3B%3A%60%2C%2F%5B%5D", (Object)encoded, (String)"Unsafe chars URL encoding test");
        Assertions.assertEquals((Object)"~!@#$%^&()+{}\"\\;:`,/[]", (Object)urlCodec.decode(encoded), (String)"Unsafe chars URL decoding test");
        this.validateState(urlCodec);
    }

    @Test
    void testUTF8RoundTrip() throws Exception {
        String ru_msg = this.constructString(RUSSIAN_STUFF_UNICODE);
        String ch_msg = this.constructString(SWISS_GERMAN_STUFF_UNICODE);
        URLCodec urlCodec = new URLCodec();
        this.validateState(urlCodec);
        Assertions.assertEquals((Object)"%D0%92%D1%81%D0%B5%D0%BC_%D0%BF%D1%80%D0%B8%D0%B2%D0%B5%D1%82", (Object)urlCodec.encode(ru_msg, CharEncoding.UTF_8));
        Assertions.assertEquals((Object)"Gr%C3%BCezi_z%C3%A4m%C3%A4", (Object)urlCodec.encode(ch_msg, CharEncoding.UTF_8));
        Assertions.assertEquals((Object)ru_msg, (Object)urlCodec.decode(urlCodec.encode(ru_msg, CharEncoding.UTF_8), CharEncoding.UTF_8));
        Assertions.assertEquals((Object)ch_msg, (Object)urlCodec.decode(urlCodec.encode(ch_msg, CharEncoding.UTF_8), CharEncoding.UTF_8));
        this.validateState(urlCodec);
    }

    private void validateState(URLCodec urlCodec) {
    }
}

