/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor.cgen;

import java.awt.Component;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.Map;
import org.apache.cayenne.gen.CgenConfiguration;
import org.apache.cayenne.modeler.editor.cgen.ClientModeController;
import org.apache.cayenne.modeler.editor.cgen.CodeGeneratorController;
import org.apache.cayenne.modeler.editor.cgen.CustomModeController;
import org.apache.cayenne.modeler.editor.cgen.GeneratorController;
import org.apache.cayenne.modeler.editor.cgen.GeneratorTabPanel;
import org.apache.cayenne.modeler.editor.cgen.StandardModeController;
import org.apache.cayenne.modeler.util.CayenneController;
import org.apache.cayenne.pref.PreferenceDetail;

public class GeneratorTabController
extends CayenneController {
    private static final String STANDARD_OBJECTS_MODE = "Standard Persistent Objects";
    private static final String CLIENT_OBJECTS_MODE = "Client Persistent Objects";
    private static final String ADVANCED_MODE = "Advanced";
    public static final String GENERATOR_PROPERTY = "generator";
    private static final String[] GENERATION_MODES = new String[]{"Standard Persistent Objects", "Client Persistent Objects", "Advanced"};
    protected GeneratorTabPanel view;
    protected Map<String, GeneratorController> controllers = new HashMap<String, GeneratorController>(3);
    protected PreferenceDetail preferences;

    public GeneratorTabController(CodeGeneratorController parent) {
        super(parent);
        this.controllers.put(STANDARD_OBJECTS_MODE, new StandardModeController(parent));
        this.controllers.put(CLIENT_OBJECTS_MODE, new ClientModeController(parent));
        this.controllers.put(ADVANCED_MODE, new CustomModeController(parent));
        Component[] modePanels = new Component[GENERATION_MODES.length];
        for (int i = 0; i < GENERATION_MODES.length; ++i) {
            modePanels[i] = this.controllers.get(GENERATION_MODES[i]).getView();
        }
        this.view = new GeneratorTabPanel(GENERATION_MODES, modePanels);
        this.initBindings();
        this.view.setPreferredSize(new Dimension(550, 480));
    }

    @Override
    public GeneratorTabPanel getView() {
        return this.view;
    }

    protected CodeGeneratorController getParentController() {
        return (CodeGeneratorController)this.getParent();
    }

    public PreferenceDetail getPreferences() {
        return this.preferences;
    }

    protected void initBindings() {
        this.view.getGenerationMode().addActionListener(action -> {
            String name = (String)this.view.getGenerationMode().getSelectedItem();
            GeneratorController modeController = this.getGeneratorController();
            CgenConfiguration cgenConfiguration = this.getParentController().getCgenConfiguration();
            modeController.updateConfiguration(cgenConfiguration);
            this.controllers.get(name).initForm(cgenConfiguration);
            this.getParentController().getPrevGeneratorController().put(cgenConfiguration.getDataMap(), modeController);
        });
    }

    public void setSelectedController(GeneratorController generatorController) {
        for (String key : this.controllers.keySet()) {
            if (!generatorController.equals(this.controllers.get(key))) continue;
            this.getView().getGenerationMode().setSelectedItem(key);
        }
    }

    GeneratorController getGeneratorController() {
        String name = (String)this.view.getGenerationMode().getSelectedItem();
        return this.controllers.get(name);
    }

    GeneratorController getStandartController() {
        return this.controllers.get(STANDARD_OBJECTS_MODE);
    }

    GeneratorController getCustomModeController() {
        return this.controllers.get(ADVANCED_MODE);
    }

    GeneratorController getClientGeneratorController() {
        return this.controllers.get(CLIENT_OBJECTS_MODE);
    }
}

