/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.objentity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.EmbeddableAttribute;
import org.apache.cayenne.map.EmbeddedAttribute;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.dialog.objentity.BoxCellRenderer;
import org.apache.cayenne.modeler.dialog.objentity.ObjAttributeInfoDialog;
import org.apache.cayenne.modeler.dialog.objentity.ObjAttributeInfoDialogView;
import org.apache.cayenne.modeler.util.CayenneTable;
import org.apache.cayenne.modeler.util.CayenneTableModel;
import org.apache.cayenne.modeler.util.CellEditorForAttributeTable;

public class OverrideEmbeddableAttributeTableModel
extends CayenneTableModel {
    private Map<String, String> overrideAttr;
    private ObjAttribute attr;
    private boolean isAttributeOverrideChange;
    private CellEditorForAttributeTable cellEditor;
    Collection<String> nameAttr;
    private CayenneTable table;
    protected List<EmbeddableAttribute> embeddableList;
    static final int OBJ_ATTRIBUTE = 0;
    static final int OBJ_ATTRIBUTE_TYPE = 1;
    static final int DB_ATTRIBUTE = 2;
    static final int DB_ATTRIBUTE_TYPE = 3;

    public List<EmbeddableAttribute> getEmbeddableList() {
        return this.embeddableList;
    }

    public OverrideEmbeddableAttributeTableModel(ProjectController mediator, Object eventSource, Collection<EmbeddableAttribute> embAttr, ObjAttribute attr) {
        super(mediator, eventSource, new ArrayList<EmbeddableAttribute>(embAttr));
        this.embeddableList = new ArrayList<EmbeddableAttribute>(embAttr);
        this.attr = attr;
        this.isAttributeOverrideChange = false;
        if (attr instanceof EmbeddedAttribute) {
            EmbeddedAttribute embeddedAttribute = (EmbeddedAttribute)attr;
            this.overrideAttr = new TreeMap<String, String>(embeddedAttribute.getAttributeOverrides());
        } else {
            this.overrideAttr = null;
        }
        for (EmbeddableAttribute emb : this.embeddableList) {
            if (this.overrideAttr == null || this.overrideAttr.get(emb.getName()) == null) continue;
            emb.setDbAttributeName(this.overrideAttr.get(emb.getName()));
        }
    }

    public Map<String, String> getOverrideAttr() {
        return this.overrideAttr;
    }

    protected void orderList() {
    }

    @Override
    public Class<?> getElementsClass() {
        return ObjAttribute.class;
    }

    @Override
    public void setUpdatedValueAt(Object value, int row, int col) {
        EmbeddableAttribute attribute = this.getEmbeddableAttribute(row);
        if (col == 2) {
            DbAttribute dbAttr;
            DbEntity currentEnt;
            attribute.setDbAttributeName(value != null ? value.toString() : null);
            this.fireTableCellUpdated(row, col);
            this.isAttributeOverrideChange = true;
            ((ObjAttributeInfoDialogView)((ObjAttributeInfoDialog)this.eventSource).getView()).getSaveButton().setEnabled(true);
            if (value != null && (currentEnt = this.attr.getEntity().getDbEntity()) != null && (dbAttr = currentEnt.getAttribute(value.toString())) != null) {
                this.fireTableCellUpdated(3, col);
            }
            this.fireTableRowsUpdated(row, row);
        }
    }

    public boolean isAttributeOverrideChange() {
        return this.isAttributeOverrideChange;
    }

    public CellEditorForAttributeTable setCellEditor(Collection<String> nameAttr, CayenneTable table) {
        this.table = table;
        this.cellEditor = new CellEditorForAttributeTable(table, Application.getWidgetFactory().createComboBox(nameAttr, true));
        return this.cellEditor;
    }

    public CellEditorForAttributeTable getCellEditor() {
        return this.cellEditor;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == 2;
    }

    public EmbeddableAttribute getEmbeddableAttribute(int row) {
        return row >= 0 && row < this.embeddableList.size() ? this.embeddableList.get(row) : null;
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public Object getValueAt(int row, int column) {
        EmbeddableAttribute attribute = this.getEmbeddableAttribute(row);
        if (column == 0) {
            return attribute.getName();
        }
        if (column == 1) {
            return attribute.getType();
        }
        String dbAttributeName = attribute.getDbAttributeName();
        if (column == 2) {
            return dbAttributeName;
        }
        if (column == 3) {
            return this.getDBAttrType(dbAttributeName);
        }
        return null;
    }

    private String getDBAttrType(String dbAttributeName) {
        DbAttribute dbAttr;
        DbEntity currentEnt = this.attr.getEntity().getDbEntity();
        if (currentEnt != null && currentEnt.getAttributes() != null && dbAttributeName != null && (dbAttr = currentEnt.getAttribute(dbAttributeName)) != null) {
            return TypesMapping.getSqlNameByType(dbAttr.getType());
        }
        return null;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "ObjAttribute";
            }
            case 1: {
                return "Java Type";
            }
            case 2: {
                return "DbAttribute";
            }
            case 3: {
                return "DB Type";
            }
        }
        return "";
    }

    public void setComboBoxes(Collection<String> nameAttr, int column) {
        int count = this.getRowCount();
        for (int i = 0; i < count; ++i) {
            EmbeddableAttribute embAt = this.getEmbeddableAttribute(i);
            if (nameAttr.contains(embAt.getDbAttributeName()) || embAt.getDbAttributeName() == null) continue;
            ArrayList<String> attributeComboForRow = new ArrayList<String>();
            attributeComboForRow.addAll(nameAttr);
            attributeComboForRow.add(embAt.getDbAttributeName());
            JComboBox<String> comboBoxForRow = Application.getWidgetFactory().createComboBox(attributeComboForRow, true);
            this.cellEditor.setEditorAt(new Integer(i), new DefaultCellEditor(comboBoxForRow));
            BoxCellRenderer renderer = new BoxCellRenderer();
            renderer.setNotActiveColumn(attributeComboForRow.size() - 1);
            comboBoxForRow.setRenderer(renderer);
        }
        this.table.getColumnModel().getColumn(column).setCellEditor(this.cellEditor);
    }

    public ObjAttribute getAttribute() {
        return this.attr;
    }

    @Override
    public boolean isColumnSortable(int sortCol) {
        return true;
    }

    @Override
    public void sortByColumn(final int sortCol, boolean isAscent) {
        Collections.sort(this.embeddableList, new Comparator<EmbeddableAttribute>(){

            @Override
            public int compare(EmbeddableAttribute o1, EmbeddableAttribute o2) {
                Integer compareObjAttributesVal = OverrideEmbeddableAttributeTableModel.this.compareObjAttributes(o1, o2);
                if (compareObjAttributesVal != null) {
                    return compareObjAttributesVal;
                }
                String valueToCompare1 = "";
                String valueToCompare2 = "";
                switch (sortCol) {
                    case 0: {
                        valueToCompare1 = o1.getName();
                        valueToCompare2 = o2.getName();
                        break;
                    }
                    case 1: {
                        valueToCompare1 = o1.getType();
                        valueToCompare2 = o2.getType();
                        break;
                    }
                    case 2: {
                        valueToCompare1 = o1.getDbAttributeName();
                        valueToCompare2 = o2.getDbAttributeName();
                        break;
                    }
                    case 3: {
                        valueToCompare1 = OverrideEmbeddableAttributeTableModel.this.getDBAttrType(o1.getDbAttributeName());
                        valueToCompare2 = OverrideEmbeddableAttributeTableModel.this.getDBAttrType(o2.getDbAttributeName());
                    }
                }
                return valueToCompare1 == null ? -1 : (valueToCompare2 == null ? 1 : valueToCompare1.compareTo(valueToCompare2));
            }
        });
        if (!isAscent) {
            Collections.reverse(this.embeddableList);
        }
    }

    private Integer compareObjAttributes(EmbeddableAttribute o1, EmbeddableAttribute o2) {
        if (o1 == null && o2 == null || o1 == o2) {
            return 0;
        }
        if (o1 == null && o2 != null) {
            return -1;
        }
        if (o1 != null && o2 == null) {
            return 1;
        }
        return null;
    }
}

