/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.db.load;

import javax.swing.JFrame;
import org.apache.cayenne.dbsync.DbSyncModule;
import org.apache.cayenne.dbsync.reverse.configuration.ToolsModule;
import org.apache.cayenne.dbsync.reverse.dbimport.DbImportAction;
import org.apache.cayenne.dbsync.reverse.dbimport.DbImportModule;
import org.apache.cayenne.di.DIBootstrap;
import org.apache.cayenne.di.Injector;
import org.apache.cayenne.modeler.dialog.db.load.DbLoaderContext;
import org.apache.cayenne.modeler.dialog.db.load.ModelerSyncModule;
import org.apache.cayenne.modeler.util.LongRunningTask;
import org.apache.cayenne.modeler.util.ProjectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LoadDataMapTask
extends LongRunningTask {
    private static Logger LOGGER = LoggerFactory.getLogger(DbLoaderContext.class);
    private DbLoaderContext context;

    public LoadDataMapTask(JFrame frame, String title, DbLoaderContext context) {
        super(frame, title);
        this.setMinValue(0);
        this.setMaxValue(10);
        this.context = context;
    }

    @Override
    protected void execute() {
        this.context.setStatusNote("Preparing...");
        try {
            this.createAction().execute(this.context.getConfig());
        }
        catch (Exception e) {
            this.context.processException(e, "Error importing database schema.");
        }
        ProjectUtil.cleanObjMappings(this.context.getDataMap());
    }

    private DbImportAction createAction() {
        Injector injector = DIBootstrap.createInjector(new DbSyncModule(), new ToolsModule(LOGGER), new DbImportModule(), new ModelerSyncModule(this.context));
        return injector.getInstance(DbImportAction.class);
    }

    @Override
    protected String getCurrentNote() {
        return this.context.getStatusNote();
    }

    @Override
    protected int getCurrentValue() {
        return this.getMinValue();
    }

    @Override
    protected boolean isIndeterminate() {
        return true;
    }

    @Override
    public boolean isCanceled() {
        return this.context.isStopping();
    }

    @Override
    public void setCanceled(boolean canceled) {
        if (canceled) {
            this.context.setStatusNote("Canceling..");
        }
        this.context.setStopping(canceled);
    }
}

