/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.ResultIterator;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.access.IncrementalFaultList;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.query.EntityResultSegment;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.util.Util;

class MixedResultIncrementalFaultList<E>
extends IncrementalFaultList<E> {
    private Map<Integer, ObjEntity> indexToEntity;
    private boolean scalarResult;

    MixedResultIncrementalFaultList(DataContext dataContext, Query query, int maxFetchSize) {
        super(dataContext, query, maxFetchSize);
    }

    @Override
    IncrementalFaultList.IncrementalListHelper createHelper(QueryMetadata metadata) {
        this.indexToEntity = new HashMap<Integer, ObjEntity>();
        this.scalarResult = true;
        for (Object next : metadata.getResultSetMapping()) {
            if (!(next instanceof EntityResultSegment)) continue;
            EntityResultSegment resultSegment = (EntityResultSegment)next;
            ObjEntity entity = resultSegment.getClassDescriptor().getEntity();
            this.indexToEntity.put(resultSegment.getColumnOffset(), entity);
            this.scalarResult = false;
        }
        if (this.indexToEntity.isEmpty()) {
            return new ScalarArrayListHelper();
        }
        return new MixedArrayListHelper();
    }

    @Override
    protected void fillIn(Query query, List<Object> elementsList) {
        elementsList.clear();
        try (ResultIterator it = this.dataContext.performIteratedQuery(query);){
            while (it.hasNextRow()) {
                elementsList.add(it.nextRow());
            }
        }
        this.unfetchedObjects = elementsList.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void resolveInterval(int fromIndex, int toIndex) {
        if (fromIndex >= toIndex || this.scalarResult) {
            return;
        }
        List list = this.elements;
        synchronized (list) {
            if (this.elements.size() == 0) {
                return;
            }
            if (fromIndex < 0) {
                fromIndex = 0;
            }
            if (toIndex > this.elements.size()) {
                toIndex = this.elements.size();
            }
            for (Map.Entry<Integer, ObjEntity> entry : this.indexToEntity.entrySet()) {
                ArrayList<Expression> quals = new ArrayList<Expression>(this.pageSize);
                int dataIdx = entry.getKey();
                for (int i = fromIndex; i < toIndex; ++i) {
                    Expression nextQualifier;
                    Object[] object = (Object[])this.elements.get(i);
                    if (!this.getHelper().unresolvedSuspect(object[dataIdx]) || (nextQualifier = this.buildIdQualifier(dataIdx, object)) == null) continue;
                    quals.add(nextQualifier);
                }
                int qualsSize = quals.size();
                if (qualsSize == 0) continue;
                ArrayList<Persistent> objects = new ArrayList<Persistent>(qualsSize);
                int fetchSize = this.maxFetchSize > 0 ? this.maxFetchSize : Integer.MAX_VALUE;
                int fetchEnd = Math.min(qualsSize, fetchSize);
                int fetchBegin = 0;
                while (fetchBegin < qualsSize) {
                    ObjectSelect<Persistent> query = this.createSelectQuery(entry.getValue(), quals.subList(fetchBegin, fetchEnd));
                    objects.addAll(query.select(this.dataContext));
                    fetchBegin = fetchEnd;
                    fetchEnd += Math.min(fetchSize, qualsSize - fetchEnd);
                }
                this.updatePageWithResults(objects, dataIdx);
            }
        }
    }

    void updatePageWithResults(List<Persistent> objects, int dataIndex) {
        MixedArrayListHelper helper = (MixedArrayListHelper)this.getHelper();
        for (Persistent object : objects) {
            helper.updateWithResolvedObject(object, dataIndex);
        }
    }

    ObjectSelect<Persistent> createSelectQuery(ObjEntity entity, List<Expression> expressions) {
        ObjectSelect<Persistent> query = ObjectSelect.query(Persistent.class).entityName(entity.getName()).where(ExpressionFactory.joinExp(1, expressions));
        if (entity.equals(this.rootEntity) && this.metadata.getPrefetchTree() != null) {
            query.prefetch(this.metadata.getPrefetchTree());
        }
        return query;
    }

    Expression buildIdQualifier(int index, Object[] data) {
        HashMap<String, Object> map;
        if (data[index] instanceof Map) {
            map = (HashMap<String, Object>)data[index];
        } else {
            if (data[index] == null) {
                return null;
            }
            map = new HashMap<String, Object>();
            int i = 0;
            for (ObjAttribute attribute : this.indexToEntity.get(index).getPrimaryKeys()) {
                map.put(attribute.getDbAttributeName(), data[index + i++]);
            }
        }
        return ExpressionFactory.matchAllDbExp(map, 3);
    }

    class ScalarArrayListHelper
    extends IncrementalFaultList.IncrementalListHelper {
        ScalarArrayListHelper() {
        }

        @Override
        boolean unresolvedSuspect(Object object) {
            return false;
        }

        @Override
        boolean objectsAreEqual(Object object, Object objectInTheList) {
            return objectInTheList.equals(object);
        }

        @Override
        boolean replacesObject(Object object, Object objectInTheList) {
            return false;
        }
    }

    class MixedArrayListHelper
    extends IncrementalFaultList.IncrementalListHelper {
        MixedArrayListHelper() {
        }

        @Override
        boolean unresolvedSuspect(Object object) {
            return !(object instanceof Persistent);
        }

        @Override
        boolean objectsAreEqual(Object object, Object objectInTheList) {
            if (!(object instanceof Object[])) {
                return false;
            }
            return Arrays.equals((Object[])object, (Object[])objectInTheList);
        }

        @Override
        boolean replacesObject(Object object, Object objectInTheList) {
            throw new UnsupportedOperationException();
        }

        boolean replacesObject(Persistent object, Object[] dataInTheList, int dataIdx) {
            Map<String, Object> map = object.getObjectId().getIdSnapshot();
            if (dataInTheList[dataIdx] instanceof Map) {
                Map id = (Map)dataInTheList[dataIdx];
                if (id.size() != map.size()) {
                    return false;
                }
                for (Map.Entry entry : id.entrySet()) {
                    if (Util.nullSafeEquals(entry.getValue(), map.get(entry.getKey()))) continue;
                    return false;
                }
            } else {
                if (dataInTheList[dataIdx] == null) {
                    return false;
                }
                for (Object id : map.values()) {
                    if (dataInTheList[dataIdx++].equals(id)) continue;
                    return false;
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void updateWithResolvedObject(Persistent object, int dataIdx) {
            List list = MixedResultIncrementalFaultList.this.elements;
            synchronized (list) {
                for (Object element : MixedResultIncrementalFaultList.this.elements) {
                    Object[] data = (Object[])element;
                    if (!this.replacesObject(object, data, dataIdx)) continue;
                    data[dataIdx] = object;
                }
            }
        }
    }
}

