/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.naming;

import java.util.Objects;
import java.util.function.Predicate;
import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.configuration.ConfigurationNodeVisitor;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.dbsync.naming.NameUtil;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.EmbeddableAttribute;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.ProcedureParameter;
import org.apache.cayenne.map.QueryDescriptor;

class DeduplicationVisitor
implements ConfigurationNodeVisitor<String> {
    private ConfigurationNode parent;
    private String baseName;
    private String dupesPattern;

    DeduplicationVisitor(ConfigurationNode parent, String baseName, String dupesPattern) {
        this.parent = parent;
        this.baseName = Objects.requireNonNull(baseName);
        this.dupesPattern = Objects.requireNonNull(dupesPattern);
    }

    public String visitDataChannelDescriptor(DataChannelDescriptor channelDescriptor) {
        return this.baseName;
    }

    public String visitDataNodeDescriptor(DataNodeDescriptor nodeDescriptor) {
        return this.resolve(name -> {
            DataChannelDescriptor dataChannelDescriptor = (DataChannelDescriptor)this.parent;
            for (DataNodeDescriptor dataNodeDescriptor : dataChannelDescriptor.getNodeDescriptors()) {
                if (!dataNodeDescriptor.getName().equals(name)) continue;
                return true;
            }
            return false;
        });
    }

    public String visitDataMap(DataMap dataMap) {
        return this.resolve(name -> {
            if (this.parent == null) {
                return false;
            }
            if (this.parent instanceof DataChannelDescriptor) {
                DataChannelDescriptor domain = (DataChannelDescriptor)this.parent;
                return domain.getDataMap(name) != null;
            }
            return false;
        });
    }

    public String visitObjEntity(ObjEntity entity) {
        return this.resolve(name -> ((DataMap)this.parent).getObjEntity(name) != null);
    }

    public String visitDbEntity(DbEntity entity) {
        return this.resolve(name -> ((DataMap)this.parent).getDbEntity(name) != null);
    }

    public String visitEmbeddable(Embeddable embeddable) {
        return this.resolve(name -> {
            DataMap map = (DataMap)this.parent;
            return map.getEmbeddable(map.getNameWithDefaultPackage(name)) != null;
        });
    }

    public String visitEmbeddableAttribute(EmbeddableAttribute attribute) {
        return this.resolve(name -> ((Embeddable)this.parent).getAttribute(name) != null);
    }

    public String visitObjAttribute(ObjAttribute attribute) {
        return this.resolveObjEntityProperty();
    }

    public String visitDbAttribute(DbAttribute attribute) {
        return this.resolveDbEntityProperty();
    }

    public String visitObjRelationship(ObjRelationship relationship) {
        return this.resolveObjEntityProperty();
    }

    public String visitDbRelationship(DbRelationship relationship) {
        return this.resolveDbEntityProperty();
    }

    public String visitProcedure(Procedure procedure) {
        return this.resolve(name -> ((DataMap)this.parent).getProcedure(name) != null);
    }

    public String visitProcedureParameter(ProcedureParameter parameter) {
        return this.resolve(name -> {
            Procedure procedure = (Procedure)this.parent;
            for (ProcedureParameter parameter1 : procedure.getCallParameters()) {
                if (!name.equals(parameter1.getName())) continue;
                return true;
            }
            return false;
        });
    }

    public String visitQuery(QueryDescriptor query) {
        return this.resolve(name -> ((DataMap)this.parent).getQueryDescriptor(name) != null);
    }

    String resolve(Predicate<String> nameChecker) {
        int c = 1;
        String name = this.baseName;
        while (nameChecker.test(name)) {
            name = String.format(this.dupesPattern, this.baseName, c++);
        }
        return name;
    }

    private String resolveDbEntityProperty() {
        return this.resolve(name -> {
            DbEntity entity = (DbEntity)this.parent;
            return entity.getAttribute(name) != null || entity.getRelationship(name) != null;
        });
    }

    private String resolveObjEntityProperty() {
        return this.resolve(name -> {
            ObjEntity entity = (ObjEntity)this.parent;
            if (entity.getAttribute(name) != null || entity.getRelationship(name) != null) {
                return true;
            }
            String conflictingCallback = "get" + NameUtil.capitalize(name);
            return entity.getCallbackMethods().contains(conflictingCallback);
        });
    }
}

