/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.reverse.filters;

import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.cayenne.util.Util;

public class PatternFilter {
    public static final PatternFilter INCLUDE_EVERYTHING = new PatternFilter(){

        @Override
        public boolean isIncluded(String obj) {
            return true;
        }

        @Override
        protected StringBuilder toString(StringBuilder res) {
            return res.append("ALL");
        }
    };
    public static final PatternFilter INCLUDE_NOTHING = new PatternFilter(){

        @Override
        public boolean isIncluded(String obj) {
            return false;
        }

        @Override
        protected StringBuilder toString(StringBuilder res) {
            return res.append("NONE");
        }
    };
    public static final Comparator<Pattern> PATTERN_COMPARATOR = (o1, o2) -> {
        if (o1 != null && o2 != null) {
            return o1.pattern().compareTo(o2.pattern());
        }
        return -1;
    };
    private final SortedSet<Pattern> includes = new TreeSet<Pattern>(PATTERN_COMPARATOR);
    private final SortedSet<Pattern> excludes = new TreeSet<Pattern>(PATTERN_COMPARATOR);

    public SortedSet<Pattern> getIncludes() {
        return this.includes;
    }

    public PatternFilter include(Pattern p) {
        this.includes.add(p);
        return this;
    }

    public PatternFilter exclude(Pattern p) {
        this.excludes.add(p);
        return this;
    }

    public static Pattern pattern(String pattern) {
        if (pattern == null) {
            return null;
        }
        return Pattern.compile(pattern, 2);
    }

    public PatternFilter include(String p) {
        return this.include(PatternFilter.pattern(p));
    }

    public PatternFilter exclude(String p) {
        return this.exclude(PatternFilter.pattern(p));
    }

    public boolean isIncluded(String obj) {
        boolean include = this.includes.isEmpty();
        for (Pattern p : this.includes) {
            if (p == null || !p.matcher(obj).matches()) continue;
            include = true;
            break;
        }
        if (!include) {
            return false;
        }
        for (Pattern p : this.excludes) {
            if (!p.matcher(obj).matches()) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PatternFilter filter = (PatternFilter)o;
        return this.includes.equals(filter.includes) && this.excludes.equals(filter.excludes);
    }

    public int hashCode() {
        return this.includes.hashCode();
    }

    protected StringBuilder toString(StringBuilder res) {
        if (!this.includes.isEmpty()) {
            if (this.includes.size() > 1) {
                res.append("(").append(Util.join(this.includes, " OR ")).append(")");
            } else {
                res.append(this.includes.first().pattern());
            }
        }
        if (!this.excludes.isEmpty()) {
            res.append(" AND NOT (").append(Util.join(this.includes, " OR ")).append(")");
        }
        return res;
    }

    public boolean isEmpty() {
        return this.includes.isEmpty() && this.excludes.isEmpty();
    }
}

