package org.apache.cayenne.testdo.inheritance_people.auto;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;

import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.property.ListProperty;
import org.apache.cayenne.exp.property.NumericProperty;
import org.apache.cayenne.exp.property.PropertyFactory;
import org.apache.cayenne.testdo.inheritance_people.Department;
import org.apache.cayenne.testdo.inheritance_people.Employee;

/**
 * Class _Manager was generated by Cayenne.
 * It is probably a good idea to avoid changing this class manually,
 * since it may be overwritten next time code is regenerated.
 * If you need to make any customizations, please use subclass.
 */
public abstract class _Manager extends Employee {

    private static final long serialVersionUID = 1L; 

    public static final NumericProperty<Integer> PERSON_ID_PK_PROPERTY = PropertyFactory.createNumeric(ExpressionFactory.dbPathExp("PERSON_ID"), Integer.class);
    public static final String PERSON_ID_PK_COLUMN = "PERSON_ID";

    public static final ListProperty<Department> MANAGED_DEPARTMENTS = PropertyFactory.createList("managedDepartments", Department.class);


    protected Object managedDepartments;

    public void addToManagedDepartments(Department obj) {
        addToManyTarget("managedDepartments", obj, true);
    }

    public void removeFromManagedDepartments(Department obj) {
        removeToManyTarget("managedDepartments", obj, true);
    }

    @SuppressWarnings("unchecked")
    public List<Department> getManagedDepartments() {
        return (List<Department>)readProperty("managedDepartments");
    }

    @Override
    public Object readPropertyDirectly(String propName) {
        if(propName == null) {
            throw new IllegalArgumentException();
        }

        switch(propName) {
            case "managedDepartments":
                return this.managedDepartments;
            default:
                return super.readPropertyDirectly(propName);
        }
    }

    @Override
    public void writePropertyDirectly(String propName, Object val) {
        if(propName == null) {
            throw new IllegalArgumentException();
        }

        switch (propName) {
            case "managedDepartments":
                this.managedDepartments = val;
                break;
            default:
                super.writePropertyDirectly(propName, val);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        writeSerialized(out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        readSerialized(in);
    }

    @Override
    protected void writeState(ObjectOutputStream out) throws IOException {
        super.writeState(out);
        out.writeObject(this.managedDepartments);
    }

    @Override
    protected void readState(ObjectInputStream in) throws IOException, ClassNotFoundException {
        super.readState(in);
        this.managedDepartments = in.readObject();
    }

}
